"""
Dict of Conway polynomials for the prime 2. key = degree, value = coefficients as binary digits
From https://www.math.rwth-aachen.de/~Frank.Luebeck/data/ConwayPol/CPimport.txt
"""
# To generate the dict use:
#conway2 = {}
#with open("CPimport.txt") as file:
#    file.readline()
#    for line in file:
#        p, n, poly = eval(line[:-2])
#        if p >2:
#            break
#        s = 0
#        for i in reversed(poly):
#            s <<= 1
#            s |= i
#        conway2[n] = s
#
#with open('conway_polynomials.py', 'w') as file:
#    print("conway_polynomials2 = ", end ="", file=file)
#    print(conway2, file=file)

conway_polynomials2 = {
    1: 3,
    2: 7,
    3: 11,
    4: 19,
    5: 37,
    6: 91,
    7: 131,
    8: 285,
    9: 529,
    10: 1135,
    11: 2053,
    12: 4331,
    13: 8219,
    14: 16553,
    15: 32821,
    16: 65581,
    17: 131081,
    18: 267267,
    19: 524327,
    20: 1050355,
    21: 2097253,
    22: 4202337,
    23: 8388641,
    24: 16901801,
    25: 33554757,
    26: 67126739,
    27: 134223533,
    28: 268443877,
    29: 536870917,
    30: 1073948847,
    31: 2147483657,
    32: 4295000729,
    33: 8589950281,
    34: 17179974135,
    35: 34359741605,
    36: 68733788515,
    37: 137438953535,
    38: 274877925159,
    39: 549755854565,
    40: 1099522486571,
    41: 2199023255561,
    42: 4399239010919,
    43: 8796093022297,
    44: 17592203542555,
    45: 35184373323841,
    46: 70368755859457,
    47: 140737488355361,
    48: 281475018792329,
    49: 562949953422687,
    50: 1125900847118165,
    51: 2251799813788225,
    52: 4503600141354131,
    53: 9007199254741063,
    54: 18014423912784023,
    55: 36028797018967697,
    56: 72057603773459229,
    57: 144115188078554495,
    58: 288230378958036459,
    59: 576460752303423611,
    60: 1152981527954067773,
    61: 2305843009213693991,
    62: 4611686024857219139,
    63: 9223372036884368159,
    64: 18446744083506674871,
    65: 36893488147419166371,
    66: 73787087654379661557,
    67: 147573952589676412967,
    68: 295147905215664022323,
    69: 590295810358722840369,
    70: 1180591647927727357837,
    71: 2361183241434822606891,
    72: 4722366922991769784593,
    73: 9444732965739290427421,
    74: 18889465931753410738441,
    75: 37778931862962039706163,
    76: 75557863726458368213031,
    77: 151115727451828646889493,
    78: 302231455005564442962899,
    79: 604462909807314587353117,
    80: 1208925819973360537480053,
    81: 2417851639229258578235097,
    82: 4835703278458787573512927,
    83: 9671406556917033397649557,
    84: 19342813262948328757476277,
    85: 38685626227668133596217541,
    86: 77371252455346439985387495,
    87: 154742504910672535772822955,
    88: 309485009821541137625447355,
    89: 618970019642690137449562217,
    90: 1237940075579315681023581333,
    91: 2475880078570760549798491667,
    92: 4951760157141837085741142581,
    95: 39614081257132168796791337803,
    96: 79228162527542164406002379741,
    97: 158456325028528675187087900737,
    98: 316912650057160177253982981451,
    100: 1267650600228486663289456659305,
    101: 2535301200456458802993406410947,
    102: 5070602401211513776032670876673,
    103: 10141204801825835211973625643197,
    107: 162259276829213363391578010288303,
    108: 324518553659919347203913599455117,
    109: 649037107316853453566312041152565,
    110: 1298074214634063142158617975876679,
    113: 10384593717069655257060992658440237,
    114: 20769187434342147729183955374942857,
    115: 41538374868278621028243970671967955,
    119: 664613997892457936451903530143834247,
    120: 1329227995913716538677825308440359101,
    121: 2658455991569831745807614120560704709,
    125: 42535295865117307932921825928975990377,
    126: 85070591731127581450756157435838967139,
    127: 170141183460469231731687303715884105731,
    131: 2722258935367507707706996859454145691891,
    132: 5444517870738479143182409563594751805105,
    133: 10889035741470030830827987437816624425313,
    137: 174224571863520493293247799005065324265789,
    139: 696898287454081973172991196020261297062063,
    143: 11150372599265311570767859136324180772083863,
    149: 713623846352979940529142984724747568191374075,
    150: 1427247692710315230689223847577426507309863275,
    151: 2854495385411919762116571938898990272765493257,
    157: 182687704666362864775460604089535377456991567973,
    163: 11692013098647223345629478661730264157247460344009,
    167: 187072209578355573530071658587684226515959365500993,
    169: 748288838313422294120286634350736906063837462221673,
    173: 11972621413014756705924586149611790497021399392059685,
    179: 766247770432944429179173513575154591809369561091801111,
    181: 3064991081731777716716694054300618367237478244367204547,
    191: 3138550867693340381917894711603833208051177722232017256635,
    193: 12554203470773361527671578846415332832204710888928069026295,
    197: 200867255532373784442745261542645325315275374222849104413167,
    199: 803469022129495137770981046170581301261101496891396417650925,
    211: 3291009114642412084309938365114701009965471731267159726697218667,
    223: 13479973333575319897333507543509815336818572211270286240551805124661,
    227: 215679573337205118357336120696157045389097155380324579848828881993851,
    229: 862718293348820473429344482784628181556388621521298319395315527975527,
    233: 13803492693581127574869511724554050904902217944340773110325048447598781,
    239: 883423532389192164791648750371459257913741948437809479060803100646309951,
    241: 3533694129556768659166595001485837031654967793751237916243212402585239929,
    251: 3618502788666131106986593281521497120414687020801267626233049500247285301397,
    257: 231584178474632390847141970017375815706539969331281128078915168015826259280061,
    263: 14821387422376473014217086081112052205218558037201992197050570753012880593912447,
    269: 948568795032094272909893509191171341133987714380927500611236528192824358010355907,
    271: 3794275180128377091639574036764685364535950857523710002444946112771297432041423135,
    277: 242833611528216133864932738352939863330300854881517440156476551217363035650651062455,
    281: 3885337784451458141838923813647037813284813678104279042503624819477808570410416996883,
    283: 15541351137805832567355695254588151253139254712417116170014499277911234281641667985767,
    289: 994646472819573284310764496293641680200912301594695434880927953786318994025066755487183,
    293: 15914343565113172548972231940698266883214596825515126958094847260581103904401068017058395,
    307: 260740604970814219042361048116400404614587954389239840081425977517360806369707098391474864405,
    311: 4171849679533027504677776769862406473833407270227837441302815640277772901915313574263597826217,
    313: 16687398718132110018711107079449625895333629080911349765211262561111091607661254297054391304331,
    317: 266998379490113760299377713271194014325338065294581596243380200977777465722580068752870260867221,
    331: 4374501449566023848745004454235242730706338861786424872851541212819905998398751846447026354046107893,
    337: 279968092772225526319680285071055534765205687154331191862498637620473983897520118172609686658950889703,
    347: 286687326998758938951352611912760867599570623646035140467198604923365359511060601008752319138765710819573,
    349: 1146749307995035755805410447651043470398282494584140561868794419693461438044242404035009276555062843277413,
    353: 18347988927920572092886567162416695526372519913346248989900710715095383008707878464560148424881005492437649,
    359: 1174271291386916613944740298394668513687841274454159935353645485766104512557304221731849499192384351515967847,
    361: 4697085165547666455778961193578674054751365097816639741414581943064418050229216886927397996769537406065884499,
    367: 300613450595050653169853516389035139504087366260264943450533244356122755214669880763353471793250393988087677115,
    373: 19239260838083241802870625048898248928261591440656956380834127638791856333738872368854622194768025215237611323781,
    379: 1231312693637327475383720003129487931408741852202045208373384168882678805359287831606695820465153613775207124697899,
    383: 19701003098197239606139520050071806902539869635232723333974146702122860885748605305707133127442457820403313995153955,
    389: 1260864198284623334792929283204595641762551656654894293374345388935863096687910739565256520156317300505812095689818319,
    397: 322781234760863573706989896500376484291213224103652939103832419567580952752105149328705669160017228929487896496593437155,
    401: 5164499756173817179311838344006023748659411585658447025661318713081295244033682389259290706560275662871806343945494986939,
    409: 1322111937580497197903830616065542079656809365928562438569297590548811582472622691650378420879430569695182424050046716608681
}
