#   Copyright 2024 The PyMC Developers
#
#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

"""Probability distributions."""

from pymc.distributions.censored import Censored
from pymc.distributions.continuous import (
    AsymmetricLaplace,
    Beta,
    Cauchy,
    ChiSquared,
    ExGaussian,
    Exponential,
    Flat,
    Gamma,
    Gumbel,
    HalfCauchy,
    HalfFlat,
    HalfNormal,
    HalfStudentT,
    Interpolated,
    InverseGamma,
    Kumaraswamy,
    Laplace,
    Logistic,
    LogitNormal,
    LogNormal,
    Lognormal,
    Moyal,
    Normal,
    Pareto,
    PolyaGamma,
    Rice,
    SkewNormal,
    SkewStudentT,
    StudentT,
    Triangular,
    TruncatedNormal,
    Uniform,
    VonMises,
    Wald,
    Weibull,
)
from pymc.distributions.custom import CustomDist, DensityDist
from pymc.distributions.discrete import (
    Bernoulli,
    BetaBinomial,
    Binomial,
    Categorical,
    DiscreteUniform,
    DiscreteWeibull,
    Geometric,
    HyperGeometric,
    NegativeBinomial,
    OrderedLogistic,
    OrderedProbit,
    Poisson,
)
from pymc.distributions.distribution import (
    Continuous,
    DiracDelta,
    Discrete,
    Distribution,
    SymbolicRandomVariable,
)
from pymc.distributions.mixture import (
    HurdleGamma,
    HurdleLogNormal,
    HurdleNegativeBinomial,
    HurdlePoisson,
    Mixture,
    NormalMixture,
    ZeroInflatedBinomial,
    ZeroInflatedNegativeBinomial,
    ZeroInflatedPoisson,
)
from pymc.distributions.multivariate import (
    CAR,
    ICAR,
    Dirichlet,
    DirichletMultinomial,
    KroneckerNormal,
    LKJCholeskyCov,
    LKJCorr,
    MatrixNormal,
    Multinomial,
    MvNormal,
    MvStudentT,
    OrderedMultinomial,
    StickBreakingWeights,
    Wishart,
    WishartBartlett,
    ZeroSumNormal,
)
from pymc.distributions.simulator import Simulator
from pymc.distributions.timeseries import (
    AR,
    GARCH11,
    EulerMaruyama,
    GaussianRandomWalk,
    MvGaussianRandomWalk,
    MvStudentTRandomWalk,
    RandomWalk,
)
from pymc.distributions.truncated import Truncated

__all__ = [
    "AR",
    "CAR",
    "GARCH11",
    "ICAR",
    "AsymmetricLaplace",
    "Bernoulli",
    "Beta",
    "BetaBinomial",
    "Binomial",
    "Categorical",
    "Cauchy",
    "Censored",
    "ChiSquared",
    "Continuous",
    "CustomDist",
    "DensityDist",
    "DiracDelta",
    "Dirichlet",
    "DirichletMultinomial",
    "Discrete",
    "DiscreteUniform",
    "DiscreteWeibull",
    "Distribution",
    "EulerMaruyama",
    "ExGaussian",
    "Exponential",
    "Flat",
    "Gamma",
    "GaussianRandomWalk",
    "Geometric",
    "Gumbel",
    "HalfCauchy",
    "HalfFlat",
    "HalfNormal",
    "HalfStudentT",
    "HurdleGamma",
    "HurdleLogNormal",
    "HurdleNegativeBinomial",
    "HurdlePoisson",
    "HyperGeometric",
    "Interpolated",
    "InverseGamma",
    "KroneckerNormal",
    "Kumaraswamy",
    "LKJCholeskyCov",
    "LKJCorr",
    "Laplace",
    "LogNormal",
    "Logistic",
    "LogitNormal",
    "Lognormal",
    "MatrixNormal",
    "Mixture",
    "Moyal",
    "Multinomial",
    "MvGaussianRandomWalk",
    "MvNormal",
    "MvStudentT",
    "MvStudentTRandomWalk",
    "NegativeBinomial",
    "Normal",
    "NormalMixture",
    "OrderedLogistic",
    "OrderedMultinomial",
    "OrderedProbit",
    "Pareto",
    "Poisson",
    "PolyaGamma",
    "RandomWalk",
    "Rice",
    "Simulator",
    "SkewNormal",
    "SkewStudentT",
    "StickBreakingWeights",
    "StudentT",
    "SymbolicRandomVariable",
    "Triangular",
    "Truncated",
    "TruncatedNormal",
    "Uniform",
    "VonMises",
    "Wald",
    "Weibull",
    "Wishart",
    "WishartBartlett",
    "ZeroInflatedBinomial",
    "ZeroInflatedNegativeBinomial",
    "ZeroInflatedPoisson",
    "ZeroSumNormal",
]
