# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pytest_sanic']

package_data = \
{'': ['*']}

install_requires = \
['async_generator>=1.10,<2.0',
 'httpx>=0.15.4',
 'pytest>=5.2',
 'websockets>=8.1,<9.0']

entry_points = \
{'pytest11': ['sanic = pytest_sanic.plugin']}

setup_kwargs = {
    'name': 'pytest-sanic',
    'version': '1.7.0',
    'description': 'a pytest plugin for Sanic',
    'long_description': 'pytest-sanic\n============\n\n.. start-badges\n\n.. list-table::\n    :stub-columns: 1\n\n    * - Build\n      - | |travis|\n    * - Docs\n      - |docs|\n    * - Package\n      - | |version| |wheel| |supported-versions| |supported-implementations|\n\n.. |travis| image:: https://travis-ci.org/yunstanford/pytest-sanic.svg?branch=master\n    :alt: Travis-CI Build Status\n    :target: https://travis-ci.org/yunstanford/pytest-sanic\n\n.. |docs| image:: https://readthedocs.org/projects/pytest-sanic/badge/?style=flat\n    :target: https://readthedocs.org/projects/pytest-sanic\n    :alt: Documentation Status\n\n.. |version| image:: https://img.shields.io/pypi/v/pytest-sanic.svg\n    :alt: PyPI Package latest release\n    :target: https://pypi.python.org/pypi/pytest-sanic\n\n.. |wheel| image:: https://img.shields.io/pypi/wheel/pytest-sanic.svg\n    :alt: PyPI Wheel\n    :target: https://pypi.python.org/pypi/pytest-sanic\n\n.. |supported-versions| image:: https://img.shields.io/pypi/pyversions/pytest-sanic.svg\n    :alt: Supported versions\n    :target: https://pypi.python.org/pypi/pytest-sanic\n\n.. |supported-implementations| image:: https://img.shields.io/pypi/implementation/pytest-sanic.svg\n    :alt: Supported implementations\n    :target: https://pypi.python.org/pypi/pytest-sanic\n\n.. end-badges\n\nA pytest plugin for `Sanic <http://sanic.readthedocs.io/en/latest/>`_. It helps you to test your code asynchronously.\n\nThis plugin provides:\n\n* very easy testing with async coroutines\n* common and useful fixtures\n* asynchronous fixture support\n* test_client/sanic_client for Sanic application\n* test_server for Sanic application\n\n\nYou can find out more here:\n\nhttp://pytest-sanic.readthedocs.io/en/latest/\n\n\n-------\nInstall\n-------\n\n.. code::\n\n    pip install pytest-sanic\n\n\n-----------\nQuick Start\n-----------\n\nYou don\'t have to load ``pytest-sanic`` explicitly. ``pytest`` will do it for you.\n\nYou can set up a fixture for your ``app`` like this:\n\n.. code-block:: python\n\n    import pytest\n    from .app import create_app\n\n    @pytest.yield_fixture\n    def app():\n        app = create_app(test_config, **params)\n        yield app\n\nThis ``app`` fixture can then be used from tests:\n\n.. code-block:: python\n\n    async def test_sanic_db_find_by_id(app):\n        """\n        Let\'s assume that, in db we have,\n            {\n                "id": "123",\n                "name": "Kobe Bryant",\n                "team": "Lakers",\n            }\n        """\n        doc = await app.db["players"].find_by_id("123")\n        assert doc.name == "Kobe Bryant"\n        assert doc.team == "Lakers"\n\nTo send requests to your ``app``, you set up a client fixture using the loop_ and sanic_client_ fixtures:\n\n.. code-block:: python\n\n    @pytest.fixture\n    def test_cli(loop, app, sanic_client):\n        return loop.run_until_complete(sanic_client(app))\n\nThis ``test_cli`` fixture can then be used to send requests to your ``app``:\n\n.. code-block:: python\n\n    async def test_index(test_cli):\n        resp = await test_cli.get(\'/\')\n        assert resp.status == 200\n\n    async def test_player(test_cli):\n        resp = await test_cli.get(\'/player\')\n        assert resp.status == 200\n\n--------------------\nasynchronous fixture\n--------------------\n\n``pytest-sanic`` also supports asynchronous fixtures, just writes them like common pytest fixtures.\n\n.. code-block:: python\n\n    @pytest.fixture\n    async def async_fixture_sleep():\n        await asyncio.sleep(0.1)\n        return "sleep..."\n\n\n--------\nFixtures\n--------\n\nSome fixtures for easy testing.\n\n``loop``\n~~~~~~~~\n\n``pytest-sanic`` creates an event loop and injects it as a fixture. ``pytest`` will use this event loop to run your ``async tests``.\nBy default, fixture ``loop`` is an instance of `asyncio.new_event_loop`. But `uvloop` is also an option for you, by simpy passing\n``--loop uvloop``. Keep mind to just use one single event loop.\n\n\n``unused_port``\n~~~~~~~~~~~~~~~\n\nan unused TCP port on the localhost.\n\n\n``test_server``\n~~~~~~~~~~~~~~~\n\nCreates a TestServer instance by giving a ``Sanic`` application. It\'s very easy to utilize ``test_server`` to create your `Sanic`\napplication server for testing.\n\n.. code-block:: python\n\n    @pytest.yield_fixture\n    def app():\n        app = Sanic("test_sanic_app")\n\n        @app.route("/test_get", methods=[\'GET\'])\n        async def test_get(request):\n            return response.json({"GET": True})\n\n        yield app\n\n    @pytest.fixture\n    def sanic_server(loop, app, test_server):\n        return loop.run_until_complete(test_server(app))\n\nYou can also very easily override this ``loop`` fixture by creating your own, simply like,\n\n.. code-block:: python\n\n    @pytest.yield_fixture\n    def loop():\n        loop = MyEventLoop()\n        yield loop\n        loop.close()\n\n``test_client``\n~~~~~~~~~~~~~~~\n\n``test_client`` has been deprecated, please use `sanic_client` instead, check out `issue <https://github.com/yunstanford/pytest-sanic/issues/22>`_ for more context.\n\n\n``sanic_client``\n~~~~~~~~~~~~~~~~\n\nCreates a TestClient instance by giving a ``Sanic`` application. You can simply have a client by using ``sanic_client``, like\n\n.. code-block:: python\n\n    @pytest.yield_fixture\n    def app():\n        app = Sanic("test_sanic_app")\n\n        @app.route("/test_get", methods=[\'GET\'])\n        async def test_get(request):\n            return response.json({"GET": True})\n\n        @app.route("/test_post", methods=[\'POST\'])\n        async def test_post(request):\n            return response.json({"POST": True})\n\n        @app.route("/test_put", methods=[\'PUT\'])\n        async def test_put(request):\n            return response.json({"PUT": True})\n\n        @app.route("/test_delete", methods=[\'DELETE\'])\n        async def test_delete(request):\n            return response.json({"DELETE": True})\n\n        @app.route("/test_patch", methods=[\'PATCH\'])\n        async def test_patch(request):\n            return response.json({"PATCH": True})\n\n        @app.route("/test_options", methods=[\'OPTIONS\'])\n        async def test_options(request):\n            return response.json({"OPTIONS": True})\n\n        @app.route("/test_head", methods=[\'HEAD\'])\n        async def test_head(request):\n            return response.json({"HEAD": True})\n\n        @app.websocket("/test_ws")\n        async def test_ws(request, ws):\n            data = await ws.recv()\n            await ws.send(data)\n\n        yield app\n\n    @pytest.fixture\n    def test_cli(loop, app, sanic_client):\n        return loop.run_until_complete(sanic_client(app, protocol=WebSocketProtocol))\n\n    #########\n    # Tests #\n    #########\n\n    async def test_fixture_test_client_get(test_cli):\n        """\n        GET request\n        """\n        resp = await test_cli.get(\'/test_get\')\n        assert resp.status == 200\n        resp_json = await resp.json()\n        assert resp_json == {"GET": True}\n\n    async def test_fixture_test_client_post(test_cli):\n        """\n        POST request\n        """\n        resp = await test_cli.post(\'/test_post\')\n        assert resp.status == 200\n        resp_json = await resp.json()\n        assert resp_json == {"POST": True}\n\n    async def test_fixture_test_client_put(test_cli):\n        """\n        PUT request\n        """\n        resp = await test_cli.put(\'/test_put\')\n        assert resp.status == 200\n        resp_json = await resp.json()\n        assert resp_json == {"PUT": True}\n\n    async def test_fixture_test_client_delete(test_cli):\n        """\n        DELETE request\n        """\n        resp = await test_cli.delete(\'/test_delete\')\n        assert resp.status == 200\n        resp_json = await resp.json()\n        assert resp_json == {"DELETE": True}\n\n    async def test_fixture_test_client_patch(test_cli):\n        """\n        PATCH request\n        """\n        resp = await test_cli.patch(\'/test_patch\')\n        assert resp.status == 200\n        resp_json = await resp.json()\n        assert resp_json == {"PATCH": True}\n\n    async def test_fixture_test_client_options(test_cli):\n        """\n        OPTIONS request\n        """\n        resp = await test_cli.options(\'/test_options\')\n        assert resp.status == 200\n        resp_json = await resp.json()\n        assert resp_json == {"OPTIONS": True}\n\n    async def test_fixture_test_client_head(test_cli):\n        """\n        HEAD request\n        """\n        resp = await test_cli.head(\'/test_head\')\n        assert resp.status == 200\n        resp_json = await resp.json()\n        # HEAD should not have body\n        assert resp_json is None\n\n    async def test_fixture_test_client_ws(test_cli):\n        """\n        Websockets\n        """\n        ws_conn = await test_cli.ws_connect(\'/test_ws\')\n        data = \'hello world!\'\n        await ws_conn.send_str(data)\n        msg = await ws_conn.receive()\n        assert msg.data == data\n        await ws_conn.close()\n\n\nsmall notes:\n\n``test_cli.ws_connect`` does not work in ``sanic.__version__ <= \'0.5.4\'``, because of a Sanic bug, but it\nhas been fixed in master branch. And ``websockets.__version__ >= \'4.0\'`` has broken websockets in ``sanic.__version__ <= \'0.6.0\'``, but it has been fixed in `master <https://github.com/channelcat/sanic/commit/bca1e084116335fd939c2ee226070f0428cd5de8>`_.\n\n\n----\nTips\n----\n\n* `Blueprints Testing <https://github.com/yunstanford/pytest-sanic/issues/3>`_\n* ``test_cli.ws_connect`` does not work in ``sanic.__version__ <= \'0.5.4\'``, because of a Sanic bug, but it has been fixed in master branch.\n* `Importing app has loop already running <https://github.com/yunstanford/pytest-sanic/issues/1>`_ when you have `db_init` listeners.\n* `Incorrect coverage report <https://github.com/pytest-dev/pytest-cov/issues/117>`_ with ``pytest-cov``, but we can have workarounds for this issue, it\'s a pytest loading plugin problem essentially.\n* Websockets > 4.0 has broken websockets in ``sanic.__version__ <= \'0.6.0\'``, but it has been fixed in `this commit <https://github.com/channelcat/sanic/commit/bca1e084116335fd939c2ee226070f0428cd5de8>`_\n\n\nFeel free to create issue if you have any question. You can also check out `closed issues <https://github.com/yunstanford/pytest-sanic/issues?q=is%3Aclosed>`_\n\n\n-----------\nDevelopment\n-----------\n\n``pytest-sanic`` accepts contributions on GitHub, in the form of issues or pull requests.\n\n\nBuild.\n\n.. code::\n\n    poetry install\n\n\nRun unit tests.\n\n.. code::\n\n    poetry run pytest ./tests --cov pytest_sanic\n\n\n---------\nReference\n---------\n\nSome useful pytest plugins:\n\n* `pytest-tornado <https://github.com/eugeniy/pytest-tornado>`_\n* `pytest-asyncio <https://github.com/pytest-dev/pytest-asyncio>`_\n* `pytest-aiohttp <https://github.com/aio-libs/pytest-aiohttp>`_\n',
    'author': 'Yun Xu',
    'author_email': 'yunxu1992@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/yunstanford/pytest-sanic',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6.1',
}


setup(**setup_kwargs)
