// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// SECDED encoder generated by util/design/secded_gen.py

module prim_secded_hamming_72_64_enc (
  input        [63:0] data_i,
  output logic [71:0] data_o
);

  always_comb begin : p_encode
    data_o = 72'(data_i);
    data_o[64] = 1'b0 ^ ^(data_o & 72'h00AB55555556AAAD5B);
    data_o[65] = 1'b0 ^ ^(data_o & 72'h00CD9999999B33366D);
    data_o[66] = 1'b0 ^ ^(data_o & 72'h00F1E1E1E1E3C3C78E);
    data_o[67] = 1'b0 ^ ^(data_o & 72'h0001FE01FE03FC07F0);
    data_o[68] = 1'b0 ^ ^(data_o & 72'h0001FFFE0003FFF800);
    data_o[69] = 1'b0 ^ ^(data_o & 72'h0001FFFFFFFC000000);
    data_o[70] = 1'b0 ^ ^(data_o & 72'h00FE00000000000000);
    data_o[71] = 1'b0 ^ ^(data_o & 72'h7FFFFFFFFFFFFFFFFF);
  end

endmodule : prim_secded_hamming_72_64_enc
