![screenshot](https://github.com/user-attachments/assets/87aaad04-f454-42aa-b9ac-e14d41f189ac)

## Unfold Django Admin Theme

[![PyPI - Version](https://img.shields.io/pypi/v/django-unfold.svg?style=for-the-badge)](https://pypi.org/project/django-unfold/)
[![Build](https://img.shields.io/github/actions/workflow/status/unfoldadmin/django-unfold/release.yml?style=for-the-badge)](https://github.com/unfoldadmin/django-unfold/actions?query=workflow%3Arelease)
![Pre Commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white&style=for-the-badge)
![Code Style - Ruff](https://img.shields.io/badge/code%20style-ruff-30173D.svg?style=for-the-badge)

Transform your Django admin into a powerful, modern administrative interface with Unfold. This open-source theme enhances Django's default admin with beautiful design, advanced features, and developer-friendly customization options. Built on proven best practices, Unfold seamlessly integrates with your existing Django admin while providing all the tools needed to create sophisticated administrative areas that both developers and end-users will love.

- **Documentation:** The full documentation is available at [unfoldadmin.com](https://unfoldadmin.com?utm_medium=github&utm_source=unfold).
- **Unfold:** The demo site is available at [unfoldadmin.com](https://unfoldadmin.com?utm_medium=github&utm_source=unfold).
- **Formula:** A repository with a demo implementation is available at [github.com/unfoldadmin/formula](https://github.com/unfoldadmin/formula?utm_medium=github&utm_source=unfold).
- **Turbo:** A Django & Next.js boilerplate implementing Unfold is available at [github.com/unfoldadmin/turbo](https://github.com/unfoldadmin/turbo?utm_medium=github&utm_source=unfold).
- **Discord:** Join our Unfold community on [Discord](https://discord.gg/9sQj9MEbNz).

## Django & Unfold Development Services

Need assistance with implementing Unfold or require custom Django development? Professional consulting and development services are available to help transform your Django admin interface and enhance your web applications. Whether migrating from the native Django admin to Unfold or seeking expert technical guidance, reach out to discuss your project requirements and explore development possibilities. [Get in touch](https://unfoldadmin.com/consulting?utm_medium=github&utm_source=unfold) to learn more about available services.

## Fresh Features & Enhancements

- **Autocomplete filters:** Enhance filter functionality with built-in autocomplete support
- **Site dropdown:** Configurable dropdown menu in the header area for managing custom navigation links
- **Dropdown actions:** Organize action items in customizable dropdown menus
- **Custom tab navigation:** Create flexible, structured tab navigation with customizable routing


## Core Features & Capabilities

- **Visual Interface**: Provides a modern user interface based on the Tailwind CSS framework.
- **Sidebar Navigation**: Simplifies the creation of sidebar menus with icons, collapsible sections, and more.
- **Dark Mode Support**: Includes both light and dark mode themes.
- **Flexible Actions**: Provides multiple ways to define actions throughout the admin interface.
- **Advanced Filters**: Features custom dropdowns, autocomplete, numeric, datetime, and text field filters.
- **Dashboard Tools**: Includes helpers for building custom dashboard pages.
- **UI Components**: Offers reusable interface components such as cards, buttons, and charts.
- **WYSIWYG Editor**: Built-in support for WYSIWYG editing through Trix.
- **Array widget:** Built-in widget for `django.contrib.postgres.fields.ArrayField`
- **Inline tabs:** Group inlines into tab navigation in the change form
- **Model tabs:** Allow defining custom tab navigation for models
- **Fieldset tabs:** Merge multiple fieldsets into tabs in the change form
- **Sortable inlines:** Allow sorting inlines by dragging and dropping
- **Environment label:** Distinguish between environments by displaying a label
- **Nonrelated inlines:** Display nonrelated models as inlines in the change form
- **Favicons:** Built-in support for configuring various site favicons
- **Themes:** Allow customization of color scheme, background color, border radius, and more
- **Font colors:** Adjust font colors for better readability
- **Changeform modes:** Display fields in compressed mode in the change form
- **Language switcher:** Allow changing language directly from the admin area
- **Parallel admin:** Supports [running the default admin](https://unfoldadmin.com/blog/migrating-django-admin-unfold/?utm_medium=github&utm_source=unfold) alongside Unfold.
- **Third-party packages:** Provides default support for multiple popular applications.
- **Configuration:** Allows basic options to be changed in `settings.py`.
- **Dependencies:** Built entirely on `django.contrib.admin`.
- **VS Code:** Project configuration and development container included.
