# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['karp',
 'karp.auth',
 'karp.auth.application',
 'karp.auth.application.queries',
 'karp.auth.domain',
 'karp.auth.domain.entities',
 'karp.auth.domain.value_objects',
 'karp.auth_infrastructure',
 'karp.auth_infrastructure.queries',
 'karp.auth_infrastructure.services',
 'karp.cliapp',
 'karp.db_infrastructure',
 'karp.foundation',
 'karp.foundation.value_objects',
 'karp.lex',
 'karp.lex.application',
 'karp.lex.application.queries',
 'karp.lex.application.repositories',
 'karp.lex.application.use_cases',
 'karp.lex.domain',
 'karp.lex.domain.commands',
 'karp.lex.domain.entities',
 'karp.lex.domain.events',
 'karp.lex.domain.value_objects',
 'karp.lex_infrastructure',
 'karp.lex_infrastructure.queries',
 'karp.lex_infrastructure.repositories',
 'karp.lex_infrastructure.sql',
 'karp.main',
 'karp.main.migrations',
 'karp.main.migrations.versions',
 'karp.search',
 'karp.search.application',
 'karp.search.application.queries',
 'karp.search.application.repositories',
 'karp.search.application.transformers',
 'karp.search.domain',
 'karp.search.domain.query_dsl',
 'karp.search_infrastructure',
 'karp.search_infrastructure.elasticsearch6',
 'karp.search_infrastructure.queries',
 'karp.search_infrastructure.repositories',
 'karp.search_infrastructure.transformers',
 'karp.tests',
 'karp.tests.e2e',
 'karp.tests.factories',
 'karp.tests.foundation',
 'karp.tests.foundation.unit',
 'karp.tests.integration',
 'karp.tests.integration.auth',
 'karp.tests.unit',
 'karp.tests.unit.auth',
 'karp.tests.unit.auth_infrastructure',
 'karp.tests.unit.lex',
 'karp.tests.unit.lex_infrastructure',
 'karp.tests.unit.search',
 'karp.tests.unit.search_infrastructure',
 'karp.util',
 'karp.util.convert',
 'karp.util.logging',
 'karp.utility',
 'karp.webapp',
 'karp.webapp.dependencies',
 'karp.webapp.routes']

package_data = \
{'': ['*'],
 'karp': ['data_files/*', 'schema/*'],
 'karp.tests': ['data/*', 'data/config/*']}

install_requires = \
['PyJWT>=2.1.0,<3.0.0',
 'SQLAlchemy-Utils>=0.38.2,<0.39.0',
 'SQLAlchemy>=1.4.25,<2.0.0',
 'TatSu>=5.6,<6.0',
 'alembic>=1.7.4,<2.0.0',
 'dependency-injector>=4.36.2,<5.0.0',
 'elasticsearch-dsl>=6,<7',
 'elasticsearch>=6,<7',
 'environs>=9.3.4,<10.0.0',
 'fastapi>=0.74,<0.75',
 'injector>=0.19,<0.20',
 'json-streams>=0.11,<0.12',
 'paradigmextract>=0.1.1,<0.2.0',
 'pydantic>=1.8.2,<2.0.0',
 'python-dotenv>=0.19.0,<0.20.0',
 'regex>=2021.9.30,<2022.0.0',
 'sb-json-tools>=0.9.1,<0.10.0',
 'sqlalchemy-json>=0.4.0,<0.5.0',
 'structlog>=21.5.0,<22.0.0',
 'tabulate>=0.8.9,<0.9.0',
 'tenacity>=8.0.1,<9.0.0',
 'tqdm>=4.62.3,<5.0.0',
 'typer>=0.4.0,<0.5.0',
 'urllib3>=1.26.7,<2.0.0',
 'uvicorn>=0.17,<0.18']

extras_require = \
{'mysql': ['mysqlclient>=2.1.0,<3.0.0',
           'PyMySQL>=0.9,<0.10',
           'aiomysql>=0.0.22,<0.0.23'],
 'sqlite': ['aiosqlite>=0.17.0,<0.18.0']}

entry_points = \
{'console_scripts': ['karp-cli = karp.cliapp.main:cliapp'],
 'karp.clicommands': ['entries = karp.cliapp.subapp_entries',
                      'entry_repo = karp.cliapp.subapp_entry_repo',
                      'resource = karp.cliapp.subapp_resource'],
 'karp.infrastructure': ['es6 = karp.infrastructure.elasticsearch6',
                         'jwt = karp.infrastructure.jwt',
                         'sql = karp.infrastructure.sql',
                         'testing = karp.infrastructure.testing']}

setup_kwargs = {
    'name': 'karp-backend',
    'version': '6.0.4',
    'description': 'Karp backend',
    'long_description': "# Karp TNG backend\n\n[![Build Status](https://github.com/spraakbanken/karp-backend/workflows/Build/badge.svg)](https://github.com/spraakbanken/karp-backend/actions)\n\nThis in the version 6 of Karp backend, [for the legacy version (v5)](https://github.com/spraakbanken/karp-backend-v5).\n\n## Setup\n\nThis project uses [poetry](https://python-poetry.org) and\n[MariaDB](https://mariadb.org/).\n\n1. Run `make install` or `make install-dev` for a develop-install (VENV_NAME defaults to .venv)\n2. Install MariaDB and create a database\n3. Setup environment variables (can be placed in a `.env` file in the root and then **?** `pipenv run` sets those):\n   ```\n   export MARIADB_DATABASE=<name of database>\n   export MARIADB_USER=<database user>\n   export MARIADB_PASSWORD=<user's password>\n   export MARIADB_HOST=localhost\n   export AUTH_JWT_PUBKEY_PATH=/path/to/pubkey\n   ```\n4. Activate the virtual environment by running: `source <VENV_NAME>/bin/activate` (VENV_NAME defaults to .venv)\n5. Run `make init-db` to initialize database\n   or `source <VENV_NAME>/bin/activate` and then `alembic upgrade head`\n6. Run `make run-dev` to start development server\n\n   or `source <VENV_NAME>/bin/activate` and then `python wsgi.py`\n\n7. To setup Elasticsearch, download Elasticsearch 6.x or 7.x and start it\n8. Install elasticsearch python libs for the right version\n   1. If you use Elasticsearch 6.x, run `source <VENV_NAME>/bin/activate` and `pip install -e .[elasticsearch6]`\n   2. If you use Elasticsearch 7.x, run `source <VENV_NAME>/bin/activate` and `pip install -e .[elasticsearch7]`\n9. Add environment variables\n\n```\nexport ES_ENABLED=true\nexport ELASTICSEARCH_HOST=localhost:9200\n```\n\n## Create test resources\n\n1. `source <VENV_NAME>/bin/activate` and then:\n2. `karp-cli create --config tests/data/config/places.json`\n3. `karp-cli import --resource_id places --version 1 --data tests/data/places.jsonl`\n4. Do the same for `municipalities`\n5. `karp-cli publish --resource_id places --version 1`\n6. `karp-cli publish --resource_id municipalities --version 1`\n\n## Pre-processing data before publishing\n\nCan be used to have less downtime, because sometimes the preprocessing may\nbe faster on another machine than the machine that talks to Elasticsearch.\nDo `create` and `import` on both machines, with the same data. Use\nmachine 1 to preprocess and use result on machine 2.\n\n1. Create resource and import data as usual.\n2. Run `karp-cli preprocess --resource_id places --version 2 --filename places_preprocessed`\n\n   `places_preprocessed` will contain a pickled dataset containing everything that is needed\n\n3. Run `karp-cli publish_preprocessed --resource_id places --version 2 --data places_preprocessed`\n4. Alternatively run `karp-cli reindex_preprocessed --resource_id places --data places_preprocessed`\n   , if the resource was already published.\n\n## Technologies\n\n### Python\n\n- Pipenv\n- Flask\n- SQLAlchemy\n- Click\n- Elasticsearch\n- Elasticsearch DSL\n\n### Databases\n\n- MariaDB\n- Elasticsearch\n\n## Development\n\n### Version handling\n\nVersion can be bumped with [`bumpversion`](https://pypi.org/project/bumpversion/).\n\nUsage:\n\n- Increase patch number `a.b.X => a.b.(X+1)`: `bumpversion patch`\n- Increase minor number `a.X.c => a.(X+1).c`: `bumpversion minor`\n- Increase major number `X.b.c => (X+1).b.c`: `bumpversion major`\n- To custom version `a.b.c => X.Y.Z`: `bumpversion --new-version X.Y.Z`\n\n`bumpversion` is configured in [`.bumpversion.cfg`](.bumpversion.cfg).\n\nThe version is changed in the following files:\n\n- [`setup.py`](setup.py)\n- [`src/karp/__init__.py`](src/karp/__init__.py)\n- [`.bumpversion.cfg`](.bumpversion.cfg)\n- [`doc/karp_api_spec.yaml`](doc/karp_api_spec.yaml)\n",
    'author': 'Språkbanken at the University of Gothenburg',
    'author_email': 'sb-info@svenska.gu.se',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://spraakbanken.gu.se',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
