"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const calendar_state_1 = require("./calendar-state");
const pipeline_state_1 = require("./pipeline-state");
const alarm_state_1 = require("../../common/alarm-state");
exports.handler = async (event, context) => {
    const pipelineName = event.pipelineName;
    const stageName = event.stageName;
    const calendarState = await calendar_state_1.getCalendarState(event.calendar.calendarName);
    const stageState = await pipeline_state_1.getStageState(pipelineName, stageName);
    const alarmState = await alarm_state_1.getAggregateAlarmState(event.searchTerms);
    const input = {
        pipelineName: pipelineName,
        stageName: stageName,
        transitionType: 'Inbound',
    };
    if (calendarState.state === 'OPEN' && alarmState.state === 'OK') {
        console.log(`Enabling transition: ${JSON.stringify(input, null, 2)}`);
        await pipeline_state_1.enableStageTransition(input, context.functionName, stageState);
    }
    else {
        // If in ALARM, use that as the reason instead of the calendar.
        const reason = alarmState.state === 'ALARM' ? alarmState.summary : calendarState.summary;
        const disableInput = { ...input, reason };
        console.log(`Disabling transition: ${JSON.stringify(disableInput, null, 2)}`);
        await pipeline_state_1.disableStageTransition(disableInput, context.functionName, stageState);
    }
};
//# sourceMappingURL=data:application/json;base64,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