/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.analysis.versioning;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;
import org.ohdsi.analysis.Utils;

public class SemverUtils {
    private static final String JS_LANG = "js";
    private static final String SEMVER_JS = Utils.GetResourceAsString("/semver/semver.js");
    private static final String SEMVER_INTERSECT_JS = Utils.GetResourceAsString("/semver/semver-intersect.js");

    public static String getRangesIntersection(List<String> ranges) {
        Context jsContext = Context.create((String[])new String[]{JS_LANG});
        jsContext.eval(JS_LANG, (CharSequence)("var exports = module = {}; " + SEMVER_JS + " ; var semver = exports;"));
        jsContext.eval(JS_LANG, (CharSequence)SEMVER_INTERSECT_JS);
        String rangesLine = "'" + StringUtils.join(ranges, (String)"', '") + "'";
        try {
            jsContext.eval(JS_LANG, (CharSequence)("var intersection = intersect(" + rangesLine + ").toString()"));
        }
        catch (PolyglotException ex) {
            if (ex.getMessage().matches("Error: Range .+ is not compatible with .+")) {
                return null;
            }
            throw ex;
        }
        return jsContext.getBindings(JS_LANG).getMember("intersection").asString();
    }
}

