/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.cohortdefinition.builders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.builders.BuilderUtils;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaColumn;
import org.ohdsi.circe.cohortdefinition.builders.CriteriaSqlBuilder;
import org.ohdsi.circe.helper.ResourceHelper;

public class ConditionOccurrenceSqlBuilder<T extends ConditionOccurrence>
extends CriteriaSqlBuilder<T> {
    private static final String CONDITION_OCCURRENCE_TEMPLATE = ResourceHelper.GetResourceAsString("/resources/cohortdefinition/sql/conditionOccurrence.sql");
    private final Set<CriteriaColumn> DEFAULT_COLUMNS = new HashSet<CriteriaColumn>(Arrays.asList(CriteriaColumn.START_DATE, CriteriaColumn.END_DATE, CriteriaColumn.VISIT_ID));

    @Override
    protected Set<CriteriaColumn> getDefaultColumns() {
        return this.DEFAULT_COLUMNS;
    }

    @Override
    protected String getQueryTemplate() {
        return CONDITION_OCCURRENCE_TEMPLATE;
    }

    @Override
    protected String getTableColumnForCriteriaColumn(CriteriaColumn column) {
        switch (column) {
            case DOMAIN_CONCEPT: {
                return "C.condition_concept_id";
            }
            case DURATION: {
                return "(DATEDIFF(d,C.condition_start_date, COALESCE(C.condition_end_date, DATEADD(day,1,C.condition_start_date))))";
            }
        }
        throw new IllegalArgumentException("Invalid CriteriaColumn for Condition Occurrence:" + column.toString());
    }

    @Override
    protected String embedCodesetClause(String query, T criteria) {
        return StringUtils.replace((String)query, (String)"@codesetClause", (String)BuilderUtils.getCodesetJoinExpression(((ConditionOccurrence)criteria).codesetId, "co.condition_concept_id", ((ConditionOccurrence)criteria).conditionSourceConcept, "co.condition_source_concept_id"));
    }

    @Override
    protected String embedOrdinalExpression(String query, T criteria, List<String> whereClauses) {
        if (((ConditionOccurrence)criteria).first != null && ((ConditionOccurrence)criteria).first.booleanValue()) {
            whereClauses.add("C.ordinal = 1");
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)", row_number() over (PARTITION BY co.person_id ORDER BY co.condition_start_date, co.condition_occurrence_id) as ordinal");
        } else {
            query = StringUtils.replace((String)query, (String)"@ordinalExpression", (String)"");
        }
        return query;
    }

    @Override
    protected List<String> resolveJoinClauses(T criteria) {
        ArrayList<String> joinClauses = new ArrayList<String>();
        if (((ConditionOccurrence)criteria).age != null || ((ConditionOccurrence)criteria).gender != null && ((ConditionOccurrence)criteria).gender.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.PERSON P on C.person_id = P.person_id");
        }
        if (((ConditionOccurrence)criteria).visitType != null && ((ConditionOccurrence)criteria).visitType.length > 0) {
            joinClauses.add("JOIN @cdm_database_schema.VISIT_OCCURRENCE V on C.visit_occurrence_id = V.visit_occurrence_id and C.person_id = V.person_id");
        }
        if (((ConditionOccurrence)criteria).providerSpecialty != null && ((ConditionOccurrence)criteria).providerSpecialty.length > 0) {
            joinClauses.add("LEFT JOIN @cdm_database_schema.PROVIDER PR on C.provider_id = PR.provider_id");
        }
        return joinClauses;
    }

    @Override
    protected List<String> resolveWhereClauses(T criteria) {
        ArrayList<String> whereClauses = new ArrayList<String>();
        if (((ConditionOccurrence)criteria).occurrenceStartDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.condition_start_date", ((ConditionOccurrence)criteria).occurrenceStartDate));
        }
        if (((ConditionOccurrence)criteria).occurrenceEndDate != null) {
            whereClauses.add(BuilderUtils.buildDateRangeClause("C.condition_end_date", ((ConditionOccurrence)criteria).occurrenceEndDate));
        }
        if (((ConditionOccurrence)criteria).conditionType != null && ((ConditionOccurrence)criteria).conditionType.length > 0) {
            ArrayList<Long> conceptIds = BuilderUtils.getConceptIdsFromConcepts(((ConditionOccurrence)criteria).conditionType);
            whereClauses.add(String.format("C.condition_type_concept_id %s in (%s)", ((ConditionOccurrence)criteria).conditionTypeExclude ? "not" : "", StringUtils.join(conceptIds, (String)",")));
        }
        if (((ConditionOccurrence)criteria).stopReason != null) {
            whereClauses.add(BuilderUtils.buildTextFilterClause("C.stop_reason", ((ConditionOccurrence)criteria).stopReason));
        }
        if (((ConditionOccurrence)criteria).age != null) {
            whereClauses.add(BuilderUtils.buildNumericRangeClause("YEAR(C.condition_start_date) - P.year_of_birth", ((ConditionOccurrence)criteria).age));
        }
        if (((ConditionOccurrence)criteria).gender != null && ((ConditionOccurrence)criteria).gender.length > 0) {
            whereClauses.add(String.format("P.gender_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((ConditionOccurrence)criteria).gender), (String)",")));
        }
        if (((ConditionOccurrence)criteria).providerSpecialty != null && ((ConditionOccurrence)criteria).providerSpecialty.length > 0) {
            whereClauses.add(String.format("PR.specialty_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((ConditionOccurrence)criteria).providerSpecialty), (String)",")));
        }
        if (((ConditionOccurrence)criteria).visitType != null && ((ConditionOccurrence)criteria).visitType.length > 0) {
            whereClauses.add(String.format("V.visit_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((ConditionOccurrence)criteria).visitType), (String)",")));
        }
        if (((ConditionOccurrence)criteria).conditionStatus != null && ((ConditionOccurrence)criteria).conditionStatus.length > 0) {
            whereClauses.add(String.format("C.condition_status_concept_id in (%s)", StringUtils.join(BuilderUtils.getConceptIdsFromConcepts(((ConditionOccurrence)criteria).conditionStatus), (String)",")));
        }
        return whereClauses;
    }
}

