"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.  # noqa: E501

    The version of the OpenAPI document: 2023-07-15
    Contact: developers@klaviyo.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.campaign_clone_query import CampaignCloneQuery
from openapi_client.model.campaign_create_query import CampaignCreateQuery
from openapi_client.model.campaign_message_assign_template_query import CampaignMessageAssignTemplateQuery
from openapi_client.model.campaign_message_partial_update_query import CampaignMessagePartialUpdateQuery
from openapi_client.model.campaign_partial_update_query import CampaignPartialUpdateQuery
from openapi_client.model.campaign_recipient_estimation_job_create_query import CampaignRecipientEstimationJobCreateQuery
from openapi_client.model.campaign_send_job_create_query import CampaignSendJobCreateQuery
from openapi_client.model.campaign_send_job_partial_update_query import CampaignSendJobPartialUpdateQuery
from openapi_client.model.get_create_variants_jobs5_xx_response import GetCreateVariantsJobs5XXResponse


class CampaignsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_campaign_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/',
                'operation_id': 'create_campaign',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_create_query',
                ],
                'required': [
                    'campaign_create_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_create_query':
                        (CampaignCreateQuery,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'campaign_create_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_campaign_clone_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-clone/',
                'operation_id': 'create_campaign_clone',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_clone_query',
                ],
                'required': [
                    'campaign_clone_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_clone_query':
                        (CampaignCloneQuery,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'campaign_clone_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_campaign_message_assign_template_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-message-assign-template/',
                'operation_id': 'create_campaign_message_assign_template',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_message_assign_template_query',
                ],
                'required': [
                    'campaign_message_assign_template_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_message_assign_template_query':
                        (CampaignMessageAssignTemplateQuery,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'campaign_message_assign_template_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_campaign_recipient_estimation_job_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-recipient-estimation-jobs/',
                'operation_id': 'create_campaign_recipient_estimation_job',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_recipient_estimation_job_create_query',
                ],
                'required': [
                    'campaign_recipient_estimation_job_create_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_recipient_estimation_job_create_query':
                        (CampaignRecipientEstimationJobCreateQuery,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'campaign_recipient_estimation_job_create_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_campaign_send_job_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-send-jobs/',
                'operation_id': 'create_campaign_send_job',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'campaign_send_job_create_query',
                ],
                'required': [
                    'campaign_send_job_create_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'campaign_send_job_create_query':
                        (CampaignSendJobCreateQuery,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'campaign_send_job_create_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_campaign_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/{id}/',
                'operation_id': 'delete_campaign',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/{id}/',
                'operation_id': 'get_campaign',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_campaign_message',
                    'fields_campaign',
                    'fields_tag',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_message',
                    'fields_campaign',
                    'fields_tag',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_message',): {

                        "LABEL": "label",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "SEND_TIMES": "send_times",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language",
                        "RENDER_OPTIONS.INCLUDE_CONTACT_CARD": "render_options.include_contact_card",
                        "CREATED_AT": "created_at",
                        "UPDATED_AT": "updated_at"
                    },
                    ('fields_campaign',): {

                        "NAME": "name",
                        "STATUS": "status",
                        "ARCHIVED": "archived",
                        "AUDIENCES": "audiences",
                        "AUDIENCES.INCLUDED": "audiences.included",
                        "AUDIENCES.EXCLUDED": "audiences.excluded",
                        "SEND_OPTIONS": "send_options",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_STRATEGY": "send_strategy",
                        "SEND_STRATEGY.METHOD": "send_strategy.method",
                        "SEND_STRATEGY.OPTIONS_STATIC": "send_strategy.options_static",
                        "SEND_STRATEGY.OPTIONS_STATIC.DATETIME": "send_strategy.options_static.datetime",
                        "SEND_STRATEGY.OPTIONS_STATIC.IS_LOCAL": "send_strategy.options_static.is_local",
                        "SEND_STRATEGY.OPTIONS_STATIC.SEND_PAST_RECIPIENTS_IMMEDIATELY": "send_strategy.options_static.send_past_recipients_immediately",
                        "SEND_STRATEGY.OPTIONS_THROTTLED": "send_strategy.options_throttled",
                        "SEND_STRATEGY.OPTIONS_THROTTLED.DATETIME": "send_strategy.options_throttled.datetime",
                        "SEND_STRATEGY.OPTIONS_THROTTLED.THROTTLE_PERCENTAGE": "send_strategy.options_throttled.throttle_percentage",
                        "SEND_STRATEGY.OPTIONS_STO": "send_strategy.options_sto",
                        "SEND_STRATEGY.OPTIONS_STO.DATE": "send_strategy.options_sto.date",
                        "CREATED_AT": "created_at",
                        "SCHEDULED_AT": "scheduled_at",
                        "UPDATED_AT": "updated_at",
                        "SEND_TIME": "send_time"
                    },
                    ('fields_tag',): {

                        "NAME": "name"
                    },
                    ('include',): {

                        "CAMPAIGN-MESSAGES": "campaign-messages",
                        "TAGS": "tags"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_campaign_message':
                        ([str],),
                    'fields_campaign':
                        ([str],),
                    'fields_tag':
                        ([str],),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_campaign_message': 'fields[campaign-message]',
                    'fields_campaign': 'fields[campaign]',
                    'fields_tag': 'fields[tag]',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'fields_campaign_message': 'query',
                    'fields_campaign': 'query',
                    'fields_tag': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_message': 'csv',
                    'fields_campaign': 'csv',
                    'fields_tag': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_campaign_messages_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/{id}/campaign-messages/',
                'operation_id': 'get_campaign_campaign_messages',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_campaign_message',
                    'fields_campaign',
                    'fields_template',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_message',
                    'fields_campaign',
                    'fields_template',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_message',): {

                        "LABEL": "label",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "SEND_TIMES": "send_times",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language",
                        "RENDER_OPTIONS.INCLUDE_CONTACT_CARD": "render_options.include_contact_card",
                        "CREATED_AT": "created_at",
                        "UPDATED_AT": "updated_at"
                    },
                    ('fields_campaign',): {

                        "NAME": "name",
                        "STATUS": "status",
                        "ARCHIVED": "archived",
                        "AUDIENCES": "audiences",
                        "AUDIENCES.INCLUDED": "audiences.included",
                        "AUDIENCES.EXCLUDED": "audiences.excluded",
                        "SEND_OPTIONS": "send_options",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_STRATEGY": "send_strategy",
                        "SEND_STRATEGY.METHOD": "send_strategy.method",
                        "SEND_STRATEGY.OPTIONS_STATIC": "send_strategy.options_static",
                        "SEND_STRATEGY.OPTIONS_STATIC.DATETIME": "send_strategy.options_static.datetime",
                        "SEND_STRATEGY.OPTIONS_STATIC.IS_LOCAL": "send_strategy.options_static.is_local",
                        "SEND_STRATEGY.OPTIONS_STATIC.SEND_PAST_RECIPIENTS_IMMEDIATELY": "send_strategy.options_static.send_past_recipients_immediately",
                        "SEND_STRATEGY.OPTIONS_THROTTLED": "send_strategy.options_throttled",
                        "SEND_STRATEGY.OPTIONS_THROTTLED.DATETIME": "send_strategy.options_throttled.datetime",
                        "SEND_STRATEGY.OPTIONS_THROTTLED.THROTTLE_PERCENTAGE": "send_strategy.options_throttled.throttle_percentage",
                        "SEND_STRATEGY.OPTIONS_STO": "send_strategy.options_sto",
                        "SEND_STRATEGY.OPTIONS_STO.DATE": "send_strategy.options_sto.date",
                        "CREATED_AT": "created_at",
                        "SCHEDULED_AT": "scheduled_at",
                        "UPDATED_AT": "updated_at",
                        "SEND_TIME": "send_time"
                    },
                    ('fields_template',): {

                        "NAME": "name",
                        "EDITOR_TYPE": "editor_type",
                        "HTML": "html",
                        "TEXT": "text",
                        "CREATED": "created",
                        "UPDATED": "updated"
                    },
                    ('include',): {

                        "CAMPAIGN": "campaign",
                        "TEMPLATE": "template"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_campaign_message':
                        ([str],),
                    'fields_campaign':
                        ([str],),
                    'fields_template':
                        ([str],),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_campaign_message': 'fields[campaign-message]',
                    'fields_campaign': 'fields[campaign]',
                    'fields_template': 'fields[template]',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'fields_campaign_message': 'query',
                    'fields_campaign': 'query',
                    'fields_template': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_message': 'csv',
                    'fields_campaign': 'csv',
                    'fields_template': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_message_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-messages/{id}/',
                'operation_id': 'get_campaign_message',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_campaign_message',
                    'fields_campaign',
                    'fields_template',
                    'include',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_message',
                    'fields_campaign',
                    'fields_template',
                    'include',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_message',): {

                        "LABEL": "label",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "SEND_TIMES": "send_times",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language",
                        "RENDER_OPTIONS.INCLUDE_CONTACT_CARD": "render_options.include_contact_card",
                        "CREATED_AT": "created_at",
                        "UPDATED_AT": "updated_at"
                    },
                    ('fields_campaign',): {

                        "NAME": "name",
                        "STATUS": "status",
                        "ARCHIVED": "archived",
                        "AUDIENCES": "audiences",
                        "AUDIENCES.INCLUDED": "audiences.included",
                        "AUDIENCES.EXCLUDED": "audiences.excluded",
                        "SEND_OPTIONS": "send_options",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_STRATEGY": "send_strategy",
                        "SEND_STRATEGY.METHOD": "send_strategy.method",
                        "SEND_STRATEGY.OPTIONS_STATIC": "send_strategy.options_static",
                        "SEND_STRATEGY.OPTIONS_STATIC.DATETIME": "send_strategy.options_static.datetime",
                        "SEND_STRATEGY.OPTIONS_STATIC.IS_LOCAL": "send_strategy.options_static.is_local",
                        "SEND_STRATEGY.OPTIONS_STATIC.SEND_PAST_RECIPIENTS_IMMEDIATELY": "send_strategy.options_static.send_past_recipients_immediately",
                        "SEND_STRATEGY.OPTIONS_THROTTLED": "send_strategy.options_throttled",
                        "SEND_STRATEGY.OPTIONS_THROTTLED.DATETIME": "send_strategy.options_throttled.datetime",
                        "SEND_STRATEGY.OPTIONS_THROTTLED.THROTTLE_PERCENTAGE": "send_strategy.options_throttled.throttle_percentage",
                        "SEND_STRATEGY.OPTIONS_STO": "send_strategy.options_sto",
                        "SEND_STRATEGY.OPTIONS_STO.DATE": "send_strategy.options_sto.date",
                        "CREATED_AT": "created_at",
                        "SCHEDULED_AT": "scheduled_at",
                        "UPDATED_AT": "updated_at",
                        "SEND_TIME": "send_time"
                    },
                    ('fields_template',): {

                        "NAME": "name",
                        "EDITOR_TYPE": "editor_type",
                        "HTML": "html",
                        "TEXT": "text",
                        "CREATED": "created",
                        "UPDATED": "updated"
                    },
                    ('include',): {

                        "CAMPAIGN": "campaign",
                        "TEMPLATE": "template"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_campaign_message':
                        ([str],),
                    'fields_campaign':
                        ([str],),
                    'fields_template':
                        ([str],),
                    'include':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_campaign_message': 'fields[campaign-message]',
                    'fields_campaign': 'fields[campaign]',
                    'fields_template': 'fields[template]',
                    'include': 'include',
                },
                'location_map': {
                    'id': 'path',
                    'fields_campaign_message': 'query',
                    'fields_campaign': 'query',
                    'fields_template': 'query',
                    'include': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_message': 'csv',
                    'fields_campaign': 'csv',
                    'fields_template': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_message_campaign_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-messages/{id}/campaign/',
                'operation_id': 'get_campaign_message_campaign',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_campaign_message',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_message',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_message',): {

                        "LABEL": "label",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "SEND_TIMES": "send_times",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language",
                        "RENDER_OPTIONS.INCLUDE_CONTACT_CARD": "render_options.include_contact_card",
                        "CREATED_AT": "created_at",
                        "UPDATED_AT": "updated_at"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_campaign_message':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_campaign_message': 'fields[campaign-message]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_campaign_message': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_message': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_message_relationships_campaign_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-messages/{id}/relationships/campaign/',
                'operation_id': 'get_campaign_message_relationships_campaign',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_message_relationships_template_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-messages/{id}/relationships/template/',
                'operation_id': 'get_campaign_message_relationships_template',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_message_template_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-messages/{id}/template/',
                'operation_id': 'get_campaign_message_template',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_campaign_message',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_message',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_message',): {

                        "LABEL": "label",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "SEND_TIMES": "send_times",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language",
                        "RENDER_OPTIONS.INCLUDE_CONTACT_CARD": "render_options.include_contact_card",
                        "CREATED_AT": "created_at",
                        "UPDATED_AT": "updated_at"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_campaign_message':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_campaign_message': 'fields[campaign-message]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_campaign_message': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_message': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_recipient_estimation_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-recipient-estimations/{id}/',
                'operation_id': 'get_campaign_recipient_estimation',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_campaign_recipient_estimation',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_recipient_estimation',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_recipient_estimation',): {

                        "ESTIMATED_RECIPIENT_COUNT": "estimated_recipient_count"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_campaign_recipient_estimation':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_campaign_recipient_estimation': 'fields[campaign-recipient-estimation]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_campaign_recipient_estimation': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_recipient_estimation': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_recipient_estimation_job_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-recipient-estimation-jobs/{id}/',
                'operation_id': 'get_campaign_recipient_estimation_job',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_campaign_recipient_estimation_job',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_recipient_estimation_job',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_recipient_estimation_job',): {

                        "STATUS": "status"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_campaign_recipient_estimation_job':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_campaign_recipient_estimation_job': 'fields[campaign-recipient-estimation-job]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_campaign_recipient_estimation_job': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_recipient_estimation_job': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_relationships_campaign_messages_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/{id}/relationships/campaign-messages/',
                'operation_id': 'get_campaign_relationships_campaign_messages',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_relationships_tags_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/{id}/relationships/tags/',
                'operation_id': 'get_campaign_relationships_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_send_job_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-send-jobs/{id}/',
                'operation_id': 'get_campaign_send_job',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_campaign_send_job',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_send_job',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_send_job',): {

                        "STATUS": "status"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_campaign_send_job':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_campaign_send_job': 'fields[campaign-send-job]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_campaign_send_job': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_send_job': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaign_tags_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/{id}/tags/',
                'operation_id': 'get_campaign_tags',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_tag',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_tag',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_tag',): {

                        "NAME": "name"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_tag':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_tag': 'fields[tag]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_tag': 'query',
                },
                'collection_format_map': {
                    'fields_tag': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_campaigns_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/',
                'operation_id': 'get_campaigns',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'fields_campaign_message',
                    'fields_campaign',
                    'fields_tag',
                    'include',
                    'page_cursor',
                    'sort',
                ],
                'required': [
                    'filter',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_campaign_message',
                    'fields_campaign',
                    'fields_tag',
                    'include',
                    'sort',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_campaign_message',): {

                        "LABEL": "label",
                        "CHANNEL": "channel",
                        "CONTENT": "content",
                        "SEND_TIMES": "send_times",
                        "RENDER_OPTIONS": "render_options",
                        "RENDER_OPTIONS.SHORTEN_LINKS": "render_options.shorten_links",
                        "RENDER_OPTIONS.ADD_ORG_PREFIX": "render_options.add_org_prefix",
                        "RENDER_OPTIONS.ADD_INFO_LINK": "render_options.add_info_link",
                        "RENDER_OPTIONS.ADD_OPT_OUT_LANGUAGE": "render_options.add_opt_out_language",
                        "RENDER_OPTIONS.INCLUDE_CONTACT_CARD": "render_options.include_contact_card",
                        "CREATED_AT": "created_at",
                        "UPDATED_AT": "updated_at"
                    },
                    ('fields_campaign',): {

                        "NAME": "name",
                        "STATUS": "status",
                        "ARCHIVED": "archived",
                        "AUDIENCES": "audiences",
                        "AUDIENCES.INCLUDED": "audiences.included",
                        "AUDIENCES.EXCLUDED": "audiences.excluded",
                        "SEND_OPTIONS": "send_options",
                        "TRACKING_OPTIONS": "tracking_options",
                        "SEND_STRATEGY": "send_strategy",
                        "SEND_STRATEGY.METHOD": "send_strategy.method",
                        "SEND_STRATEGY.OPTIONS_STATIC": "send_strategy.options_static",
                        "SEND_STRATEGY.OPTIONS_STATIC.DATETIME": "send_strategy.options_static.datetime",
                        "SEND_STRATEGY.OPTIONS_STATIC.IS_LOCAL": "send_strategy.options_static.is_local",
                        "SEND_STRATEGY.OPTIONS_STATIC.SEND_PAST_RECIPIENTS_IMMEDIATELY": "send_strategy.options_static.send_past_recipients_immediately",
                        "SEND_STRATEGY.OPTIONS_THROTTLED": "send_strategy.options_throttled",
                        "SEND_STRATEGY.OPTIONS_THROTTLED.DATETIME": "send_strategy.options_throttled.datetime",
                        "SEND_STRATEGY.OPTIONS_THROTTLED.THROTTLE_PERCENTAGE": "send_strategy.options_throttled.throttle_percentage",
                        "SEND_STRATEGY.OPTIONS_STO": "send_strategy.options_sto",
                        "SEND_STRATEGY.OPTIONS_STO.DATE": "send_strategy.options_sto.date",
                        "CREATED_AT": "created_at",
                        "SCHEDULED_AT": "scheduled_at",
                        "UPDATED_AT": "updated_at",
                        "SEND_TIME": "send_time"
                    },
                    ('fields_tag',): {

                        "NAME": "name"
                    },
                    ('include',): {

                        "CAMPAIGN-MESSAGES": "campaign-messages",
                        "TAGS": "tags"
                    },
                    ('sort',): {

                        "CREATED_AT": "created_at",
                        "-CREATED_AT": "-created_at",
                        "ID": "id",
                        "-ID": "-id",
                        "NAME": "name",
                        "-NAME": "-name",
                        "SCHEDULED_AT": "scheduled_at",
                        "-SCHEDULED_AT": "-scheduled_at",
                        "UPDATED_AT": "updated_at",
                        "-UPDATED_AT": "-updated_at"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'fields_campaign_message':
                        ([str],),
                    'fields_campaign':
                        ([str],),
                    'fields_tag':
                        ([str],),
                    'include':
                        ([str],),
                    'page_cursor':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'filter': 'filter',
                    'fields_campaign_message': 'fields[campaign-message]',
                    'fields_campaign': 'fields[campaign]',
                    'fields_tag': 'fields[tag]',
                    'include': 'include',
                    'page_cursor': 'page[cursor]',
                    'sort': 'sort',
                },
                'location_map': {
                    'filter': 'query',
                    'fields_campaign_message': 'query',
                    'fields_campaign': 'query',
                    'fields_tag': 'query',
                    'include': 'query',
                    'page_cursor': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                    'fields_campaign_message': 'csv',
                    'fields_campaign': 'csv',
                    'fields_tag': 'csv',
                    'include': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_campaign_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaigns/{id}/',
                'operation_id': 'update_campaign',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'campaign_partial_update_query',
                ],
                'required': [
                    'id',
                    'campaign_partial_update_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'campaign_partial_update_query':
                        (CampaignPartialUpdateQuery,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'campaign_partial_update_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_campaign_message_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-messages/{id}/',
                'operation_id': 'update_campaign_message',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'campaign_message_partial_update_query',
                ],
                'required': [
                    'id',
                    'campaign_message_partial_update_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'campaign_message_partial_update_query':
                        (CampaignMessagePartialUpdateQuery,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'campaign_message_partial_update_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_campaign_send_job_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/campaign-send-jobs/{id}/',
                'operation_id': 'update_campaign_send_job',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'campaign_send_job_partial_update_query',
                ],
                'required': [
                    'id',
                    'campaign_send_job_partial_update_query',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'campaign_send_job_partial_update_query':
                        (CampaignSendJobPartialUpdateQuery,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                    'campaign_send_job_partial_update_query': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_campaign(
        self,
        campaign_create_query,
        **kwargs
    ):
        """Create Campaign  # noqa: E501

        Creates a campaign given a set of parameters, then returns it.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign(campaign_create_query, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_create_query (CampaignCreateQuery): Creates a campaign from parameters

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_create_query'] = \
            campaign_create_query
        return self.create_campaign_endpoint.call_with_http_info(**kwargs)

    def create_campaign_clone(
        self,
        campaign_clone_query,
        **kwargs
    ):
        """Create Campaign Clone  # noqa: E501

        Clones an existing campaign, returning a new campaign based on the original with a new ID and name.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_clone(campaign_clone_query, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_clone_query (CampaignCloneQuery): Clones a campaign from an existing campaign

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_clone_query'] = \
            campaign_clone_query
        return self.create_campaign_clone_endpoint.call_with_http_info(**kwargs)

    def create_campaign_message_assign_template(
        self,
        campaign_message_assign_template_query,
        **kwargs
    ):
        """Assign Campaign Message Template  # noqa: E501

        Creates a non-reusable version of the template and assigns it to the message.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_message_assign_template(campaign_message_assign_template_query, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_message_assign_template_query (CampaignMessageAssignTemplateQuery): Takes a reusable template, clones it, and assigns the non-reusable clone to the message.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_message_assign_template_query'] = \
            campaign_message_assign_template_query
        return self.create_campaign_message_assign_template_endpoint.call_with_http_info(**kwargs)

    def create_campaign_recipient_estimation_job(
        self,
        campaign_recipient_estimation_job_create_query,
        **kwargs
    ):
        """Create Campaign Recipient Estimation Job  # noqa: E501

        Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_recipient_estimation_job(campaign_recipient_estimation_job_create_query, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_recipient_estimation_job_create_query (CampaignRecipientEstimationJobCreateQuery): Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_recipient_estimation_job_create_query'] = \
            campaign_recipient_estimation_job_create_query
        return self.create_campaign_recipient_estimation_job_endpoint.call_with_http_info(**kwargs)

    def create_campaign_send_job(
        self,
        campaign_send_job_create_query,
        **kwargs
    ):
        """Create Campaign Send Job  # noqa: E501

        Trigger a campaign to send asynchronously<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_send_job(campaign_send_job_create_query, async_req=True)
        >>> result = thread.get()

        Args:
            campaign_send_job_create_query (CampaignSendJobCreateQuery): Trigger the campaign to send asynchronously

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['campaign_send_job_create_query'] = \
            campaign_send_job_create_query
        return self.create_campaign_send_job_endpoint.call_with_http_info(**kwargs)

    def delete_campaign(
        self,
        id,
        **kwargs
    ):
        """Delete Campaign  # noqa: E501

        Delete a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_campaign(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The campaign ID to be deleted

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.delete_campaign_endpoint.call_with_http_info(**kwargs)

    def get_campaign(
        self,
        id,
        **kwargs
    ):
        """Get Campaign  # noqa: E501

        Returns a specific campaign based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The campaign ID to be retrieved

        Keyword Args:
            fields_campaign_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            fields_campaign ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            fields_tag ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#relationships. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_endpoint.call_with_http_info(**kwargs)

    def get_campaign_campaign_messages(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Campaign Messages  # noqa: E501

        Return all messages that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_campaign_messages(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            fields_campaign_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            fields_campaign ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            fields_template ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#relationships. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_campaign_messages_endpoint.call_with_http_info(**kwargs)

    def get_campaign_message(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Message  # noqa: E501

        Returns a specific message based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The message ID to be retrieved

        Keyword Args:
            fields_campaign_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            fields_campaign ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            fields_template ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#relationships. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_message_endpoint.call_with_http_info(**kwargs)

    def get_campaign_message_campaign(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Message Campaign  # noqa: E501

        Return the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_campaign(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            fields_campaign_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_message_campaign_endpoint.call_with_http_info(**kwargs)

    def get_campaign_message_relationships_campaign(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Message Relationships Campaign  # noqa: E501

        Returns the ID of the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_relationships_campaign(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_message_relationships_campaign_endpoint.call_with_http_info(**kwargs)

    def get_campaign_message_relationships_template(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Message Relationships Template  # noqa: E501

        Returns the ID of the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_relationships_template(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_message_relationships_template_endpoint.call_with_http_info(**kwargs)

    def get_campaign_message_template(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Message Template  # noqa: E501

        Return the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_template(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            fields_campaign_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_message_template_endpoint.call_with_http_info(**kwargs)

    def get_campaign_recipient_estimation(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Recipient Estimation  # noqa: E501

        Get the estimated recipient count for a campaign with the provided campaign ID. You can refresh this count by using the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_recipient_estimation(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The ID of the campaign for which to get the estimated number of recipients

        Keyword Args:
            fields_campaign_recipient_estimation ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_recipient_estimation_endpoint.call_with_http_info(**kwargs)

    def get_campaign_recipient_estimation_job(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Recipient Estimation Job  # noqa: E501

        Retrieve the status of a recipient estimation job triggered with the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_recipient_estimation_job(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The ID of the campaign to get recipient estimation status

        Keyword Args:
            fields_campaign_recipient_estimation_job ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_recipient_estimation_job_endpoint.call_with_http_info(**kwargs)

    def get_campaign_relationships_campaign_messages(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Relationships Campaign Messages  # noqa: E501

        Returns the IDs of all messages associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_relationships_campaign_messages(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_relationships_campaign_messages_endpoint.call_with_http_info(**kwargs)

    def get_campaign_relationships_tags(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Relationships Tags  # noqa: E501

        Returns the IDs of all tags associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_relationships_tags(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_relationships_tags_endpoint.call_with_http_info(**kwargs)

    def get_campaign_send_job(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Send Job  # noqa: E501

        Get a campaign send job<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_send_job(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The ID of the campaign to send

        Keyword Args:
            fields_campaign_send_job ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_send_job_endpoint.call_with_http_info(**kwargs)

    def get_campaign_tags(
        self,
        id,
        **kwargs
    ):
        """Get Campaign Tags  # noqa: E501

        Return all tags that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_tags(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): 

        Keyword Args:
            fields_tag ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_campaign_tags_endpoint.call_with_http_info(**kwargs)

    def get_campaigns(
        self,
        filter,
        **kwargs
    ):
        """Get Campaigns  # noqa: E501

        Returns some or all campaigns based on filters. A channel filter is required to list campaigns. Please provide either `?filter=equals(messages.channel,'email')` to list email campaigns, or `?filter=equals(messages.channel,'sms')` to list SMS campaigns.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaigns(filter, async_req=True)
        >>> result = thread.get()

        Args:
            filter (str): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`

        Keyword Args:
            fields_campaign_message ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            fields_campaign ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            fields_tag ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            include ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#relationships. [optional]
            page_cursor (str): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#pagination. [optional]
            sort (str): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sorting. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['filter'] = \
            filter
        return self.get_campaigns_endpoint.call_with_http_info(**kwargs)

    def update_campaign(
        self,
        id,
        campaign_partial_update_query,
        **kwargs
    ):
        """Update Campaign  # noqa: E501

        Update a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign(id, campaign_partial_update_query, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The campaign ID to be retrieved
            campaign_partial_update_query (CampaignPartialUpdateQuery): Update a campaign and return it

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['campaign_partial_update_query'] = \
            campaign_partial_update_query
        return self.update_campaign_endpoint.call_with_http_info(**kwargs)

    def update_campaign_message(
        self,
        id,
        campaign_message_partial_update_query,
        **kwargs
    ):
        """Update Campaign Message  # noqa: E501

        Update a campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign_message(id, campaign_message_partial_update_query, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The message ID to be retrieved
            campaign_message_partial_update_query (CampaignMessagePartialUpdateQuery): Update a message and return it

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['campaign_message_partial_update_query'] = \
            campaign_message_partial_update_query
        return self.update_campaign_message_endpoint.call_with_http_info(**kwargs)

    def update_campaign_send_job(
        self,
        id,
        campaign_send_job_partial_update_query,
        **kwargs
    ):
        """Update Campaign Send Job  # noqa: E501

        Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign_send_job(id, campaign_send_job_partial_update_query, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The ID of the currently sending campaign to cancel or revert
            campaign_send_job_partial_update_query (CampaignSendJobPartialUpdateQuery): Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        kwargs['campaign_send_job_partial_update_query'] = \
            campaign_send_job_partial_update_query
        return self.update_campaign_send_job_endpoint.call_with_http_info(**kwargs)

