"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.  # noqa: E501

    The version of the OpenAPI document: 2023-07-15
    Contact: developers@klaviyo.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from openapi_client.model.get_create_variants_jobs5_xx_response import GetCreateVariantsJobs5XXResponse


class AccountsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_account_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/accounts/{id}/',
                'operation_id': 'get_account',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'fields_account',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'fields_account',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_account',): {

                        "CONTACT_INFORMATION": "contact_information",
                        "CONTACT_INFORMATION.DEFAULT_SENDER_NAME": "contact_information.default_sender_name",
                        "CONTACT_INFORMATION.DEFAULT_SENDER_EMAIL": "contact_information.default_sender_email",
                        "CONTACT_INFORMATION.WEBSITE_URL": "contact_information.website_url",
                        "CONTACT_INFORMATION.ORGANIZATION_NAME": "contact_information.organization_name",
                        "CONTACT_INFORMATION.STREET_ADDRESS": "contact_information.street_address",
                        "CONTACT_INFORMATION.STREET_ADDRESS.ADDRESS1": "contact_information.street_address.address1",
                        "CONTACT_INFORMATION.STREET_ADDRESS.ADDRESS2": "contact_information.street_address.address2",
                        "CONTACT_INFORMATION.STREET_ADDRESS.CITY": "contact_information.street_address.city",
                        "CONTACT_INFORMATION.STREET_ADDRESS.REGION": "contact_information.street_address.region",
                        "CONTACT_INFORMATION.STREET_ADDRESS.COUNTRY": "contact_information.street_address.country",
                        "CONTACT_INFORMATION.STREET_ADDRESS.ZIP": "contact_information.street_address.zip",
                        "INDUSTRY": "industry",
                        "TIMEZONE": "timezone",
                        "PREFERRED_CURRENCY": "preferred_currency",
                        "PUBLIC_API_KEY": "public_api_key"
                    },
                },
                'openapi_types': {
                    'id':
                        (str,),
                    'fields_account':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'fields_account': 'fields[account]',
                },
                'location_map': {
                    'id': 'path',
                    'fields_account': 'query',
                },
                'collection_format_map': {
                    'fields_account': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_accounts_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'Klaviyo-API-Key'
                ],
                'endpoint_path': '/api/accounts/',
                'operation_id': 'get_accounts',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'fields_account',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'fields_account',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('fields_account',): {

                        "CONTACT_INFORMATION": "contact_information",
                        "CONTACT_INFORMATION.DEFAULT_SENDER_NAME": "contact_information.default_sender_name",
                        "CONTACT_INFORMATION.DEFAULT_SENDER_EMAIL": "contact_information.default_sender_email",
                        "CONTACT_INFORMATION.WEBSITE_URL": "contact_information.website_url",
                        "CONTACT_INFORMATION.ORGANIZATION_NAME": "contact_information.organization_name",
                        "CONTACT_INFORMATION.STREET_ADDRESS": "contact_information.street_address",
                        "CONTACT_INFORMATION.STREET_ADDRESS.ADDRESS1": "contact_information.street_address.address1",
                        "CONTACT_INFORMATION.STREET_ADDRESS.ADDRESS2": "contact_information.street_address.address2",
                        "CONTACT_INFORMATION.STREET_ADDRESS.CITY": "contact_information.street_address.city",
                        "CONTACT_INFORMATION.STREET_ADDRESS.REGION": "contact_information.street_address.region",
                        "CONTACT_INFORMATION.STREET_ADDRESS.COUNTRY": "contact_information.street_address.country",
                        "CONTACT_INFORMATION.STREET_ADDRESS.ZIP": "contact_information.street_address.zip",
                        "INDUSTRY": "industry",
                        "TIMEZONE": "timezone",
                        "PREFERRED_CURRENCY": "preferred_currency",
                        "PUBLIC_API_KEY": "public_api_key"
                    },
                },
                'openapi_types': {
                    'fields_account':
                        ([str],),
                },
                'attribute_map': {
                    'fields_account': 'fields[account]',
                },
                'location_map': {
                    'fields_account': 'query',
                },
                'collection_format_map': {
                    'fields_account': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_account(
        self,
        id,
        **kwargs
    ):
        """Get Account  # noqa: E501

        Retrieve a single account object by its account ID. You can only request the account by which the private API key was generated.<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `accounts:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_account(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): The ID of the account

        Keyword Args:
            fields_account ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_account_endpoint.call_with_http_info(**kwargs)

    def get_accounts(
        self,
        **kwargs
    ):
        """Get Accounts  # noqa: E501

        Retrieve the account(s) associated with a given private API key. This will return 1 account object within the array. You can use this to retrieve account-specific data (contact information, timezone, currency, Public API key, etc.) or test if a Private API Key belongs to the correct account prior to performing subsequent actions with the API.\"<br><br>*Rate limits*:<br>Burst: `1/s`<br>Steady: `15/m`  **Scopes:** `accounts:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_accounts(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            fields_account ([str]): For more information please visit https://developers.klaviyo.com/en/v2023-07-15/reference/api-overview#sparse-fieldsets. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.get_accounts_endpoint.call_with_http_info(**kwargs)

