import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Schema for Module Fragment of type Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE
 *
 * @schema CfnCloudFormationArtifactsBucketModuleProps
 */
export interface CfnCloudFormationArtifactsBucketModuleProps {
    /**
     * @schema CfnCloudFormationArtifactsBucketModuleProps#Resources
     */
    readonly resources?: CfnCloudFormationArtifactsBucketModulePropsResources;
}
/**
 * Converts an object of type 'CfnCloudFormationArtifactsBucketModuleProps' to JSON representation.
 */
export declare function toJson_CfnCloudFormationArtifactsBucketModuleProps(obj: CfnCloudFormationArtifactsBucketModuleProps | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudFormationArtifactsBucketModulePropsResources
 */
export interface CfnCloudFormationArtifactsBucketModulePropsResources {
    /**
     * @schema CfnCloudFormationArtifactsBucketModulePropsResources#Bucket
     */
    readonly bucket?: CfnCloudFormationArtifactsBucketModulePropsResourcesBucket;
}
/**
 * Converts an object of type 'CfnCloudFormationArtifactsBucketModulePropsResources' to JSON representation.
 */
export declare function toJson_CfnCloudFormationArtifactsBucketModulePropsResources(obj: CfnCloudFormationArtifactsBucketModulePropsResources | undefined): Record<string, any> | undefined;
/**
 * @schema CfnCloudFormationArtifactsBucketModulePropsResourcesBucket
 */
export interface CfnCloudFormationArtifactsBucketModulePropsResourcesBucket {
    /**
     * @schema CfnCloudFormationArtifactsBucketModulePropsResourcesBucket#Type
     */
    readonly type?: string;
    /**
     * @schema CfnCloudFormationArtifactsBucketModulePropsResourcesBucket#Properties
     */
    readonly properties?: any;
}
/**
 * Converts an object of type 'CfnCloudFormationArtifactsBucketModulePropsResourcesBucket' to JSON representation.
 */
export declare function toJson_CfnCloudFormationArtifactsBucketModulePropsResourcesBucket(obj: CfnCloudFormationArtifactsBucketModulePropsResourcesBucket | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE`
 *
 * @cloudformationResource Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnCloudFormationArtifactsBucketModule extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE";
    /**
     * Resource props.
     */
    readonly props: CfnCloudFormationArtifactsBucketModuleProps;
    /**
     * Create a new `Symphonia::OpenSource::CloudFormationArtifactsBucket::MODULE`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCloudFormationArtifactsBucketModuleProps);
}
