# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime

from pydantic import BaseModel, Field, StrictInt

class ThrottledScheduleOptions(BaseModel):
    """
    ThrottledScheduleOptions
    """
    datetime: datetime = Field(..., description="The time to send at")
    throttle_percentage: StrictInt = Field(..., description="The percentage of recipients per hour to send to. Allowed values: [10, 11, 13, 14, 17, 20, 25, 33, 50]")
    __properties = ["datetime", "throttle_percentage"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ThrottledScheduleOptions:
        """Create an instance of ThrottledScheduleOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ThrottledScheduleOptions:
        """Create an instance of ThrottledScheduleOptions from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ThrottledScheduleOptions.parse_obj(obj)

        _obj = ThrottledScheduleOptions.parse_obj({
            "datetime": obj.get("datetime"),
            "throttle_percentage": obj.get("throttle_percentage")
        })
        return _obj


