# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class TemplateUpdateQueryResourceObjectAttributes(BaseModel):
    """
    TemplateUpdateQueryResourceObjectAttributes
    """
    name: Optional[StrictStr] = Field(None, description="The name of the template")
    html: Optional[StrictStr] = Field(None, description="The HTML of the template")
    text: Optional[StrictStr] = Field(None, description="The plaintext of the template")
    __properties = ["name", "html", "text"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TemplateUpdateQueryResourceObjectAttributes:
        """Create an instance of TemplateUpdateQueryResourceObjectAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if html (nullable) is None
        # and __fields_set__ contains the field
        if self.html is None and "html" in self.__fields_set__:
            _dict['html'] = None

        # set to None if text (nullable) is None
        # and __fields_set__ contains the field
        if self.text is None and "text" in self.__fields_set__:
            _dict['text'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TemplateUpdateQueryResourceObjectAttributes:
        """Create an instance of TemplateUpdateQueryResourceObjectAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return TemplateUpdateQueryResourceObjectAttributes.parse_obj(obj)

        _obj = TemplateUpdateQueryResourceObjectAttributes.parse_obj({
            "name": obj.get("name"),
            "html": obj.get("html"),
            "text": obj.get("text")
        })
        return _obj


