# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conlist, validator
from openapi_client.models.server_bis_subscription_create_query_resource_object_attributes_profile import ServerBISSubscriptionCreateQueryResourceObjectAttributesProfile

class ServerBISSubscriptionCreateQueryResourceObjectAttributes(BaseModel):
    """
    ServerBISSubscriptionCreateQueryResourceObjectAttributes
    """
    channels: conlist(StrictStr) = Field(..., description="The channel(s) through which the profile would like to receive the back in stock notification. This can be leveraged within a back in stock flow to notify the subscriber through their preferred channel(s).")
    profile: Optional[ServerBISSubscriptionCreateQueryResourceObjectAttributesProfile] = None
    __properties = ["channels", "profile"]

    @validator('channels')
    def channels_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in ('EMAIL', 'PUSH', 'SMS'):
                raise ValueError("each list item must be one of ('EMAIL', 'PUSH', 'SMS')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServerBISSubscriptionCreateQueryResourceObjectAttributes:
        """Create an instance of ServerBISSubscriptionCreateQueryResourceObjectAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of profile
        if self.profile:
            _dict['profile'] = self.profile.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ServerBISSubscriptionCreateQueryResourceObjectAttributes:
        """Create an instance of ServerBISSubscriptionCreateQueryResourceObjectAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ServerBISSubscriptionCreateQueryResourceObjectAttributes.parse_obj(obj)

        _obj = ServerBISSubscriptionCreateQueryResourceObjectAttributes.parse_obj({
            "channels": obj.get("channels"),
            "profile": ServerBISSubscriptionCreateQueryResourceObjectAttributesProfile.from_dict(obj.get("profile")) if obj.get("profile") is not None else None
        })
        return _obj


