# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from openapi_client.models.subscription_channels import SubscriptionChannels

class ProfileSubscriptionCreateQueryResourceObjectAttributes(BaseModel):
    """
    ProfileSubscriptionCreateQueryResourceObjectAttributes
    """
    email: Optional[StrictStr] = Field(None, description="The email address to subscribe or to set on the profile if `channels` is specified and the email channel is omitted.")
    phone_number: Optional[StrictStr] = Field(None, description="The phone number to subscribe or to set on the profile if `channels` is specified and the SMS channel is omitted. This must be in E.164 format.")
    subscriptions: Optional[SubscriptionChannels] = None
    __properties = ["email", "phone_number", "subscriptions"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProfileSubscriptionCreateQueryResourceObjectAttributes:
        """Create an instance of ProfileSubscriptionCreateQueryResourceObjectAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of subscriptions
        if self.subscriptions:
            _dict['subscriptions'] = self.subscriptions.to_dict()
        # set to None if email (nullable) is None
        # and __fields_set__ contains the field
        if self.email is None and "email" in self.__fields_set__:
            _dict['email'] = None

        # set to None if phone_number (nullable) is None
        # and __fields_set__ contains the field
        if self.phone_number is None and "phone_number" in self.__fields_set__:
            _dict['phone_number'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProfileSubscriptionCreateQueryResourceObjectAttributes:
        """Create an instance of ProfileSubscriptionCreateQueryResourceObjectAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProfileSubscriptionCreateQueryResourceObjectAttributes.parse_obj(obj)

        _obj = ProfileSubscriptionCreateQueryResourceObjectAttributes.parse_obj({
            "email": obj.get("email"),
            "phone_number": obj.get("phone_number"),
            "subscriptions": SubscriptionChannels.from_dict(obj.get("subscriptions")) if obj.get("subscriptions") is not None else None
        })
        return _obj


