# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Optional
from pydantic import BaseModel, Field, StrictStr

class ProfileLocation(BaseModel):
    """
    ProfileLocation
    """
    address1: Optional[StrictStr] = Field(None, description="First line of street address")
    address2: Optional[StrictStr] = Field(None, description="Second line of street address")
    city: Optional[StrictStr] = Field(None, description="City name")
    country: Optional[StrictStr] = Field(None, description="Country name")
    latitude: Optional[Any] = Field(None, description="Latitude coordinate. We recommend providing a precision of four decimal places.")
    longitude: Optional[Any] = Field(None, description="Longitude coordinate. We recommend providing a precision of four decimal places.")
    region: Optional[StrictStr] = Field(None, description="Region within a country, such as state or province")
    zip: Optional[StrictStr] = Field(None, description="Zip code")
    timezone: Optional[StrictStr] = Field(None, description="Time zone name. We recommend using time zones from the IANA Time Zone Database.")
    ip: Optional[StrictStr] = Field(None, description="IP Address")
    __properties = ["address1", "address2", "city", "country", "latitude", "longitude", "region", "zip", "timezone", "ip"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ProfileLocation:
        """Create an instance of ProfileLocation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if latitude (nullable) is None
        # and __fields_set__ contains the field
        if self.latitude is None and "latitude" in self.__fields_set__:
            _dict['latitude'] = None

        # set to None if longitude (nullable) is None
        # and __fields_set__ contains the field
        if self.longitude is None and "longitude" in self.__fields_set__:
            _dict['longitude'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ProfileLocation:
        """Create an instance of ProfileLocation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ProfileLocation.parse_obj(obj)

        _obj = ProfileLocation.parse_obj({
            "address1": obj.get("address1"),
            "address2": obj.get("address2"),
            "city": obj.get("city"),
            "country": obj.get("country"),
            "latitude": obj.get("latitude"),
            "longitude": obj.get("longitude"),
            "region": obj.get("region"),
            "zip": obj.get("zip"),
            "timezone": obj.get("timezone"),
            "ip": obj.get("ip")
        })
        return _obj


