# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class ImageCreateQueryResourceObjectAttributes(BaseModel):
    """
    ImageCreateQueryResourceObjectAttributes
    """
    name: Optional[StrictStr] = Field(None, description="A name for the image.  Defaults to the filename if not provided.  If the name matches an existing image, a suffix will be added.")
    import_from_url: Optional[StrictStr] = Field(..., description="An existing image url to import the image from. Alternatively, you may specify a base-64 encoded data-uri (`data:image/...`). Supported image formats: jpeg,png,gif. Maximum image size: 5MB.")
    hidden: Optional[StrictBool] = Field(False, description="If true, this image is not shown in the asset library.")
    __properties = ["name", "import_from_url", "hidden"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImageCreateQueryResourceObjectAttributes:
        """Create an instance of ImageCreateQueryResourceObjectAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if import_from_url (nullable) is None
        # and __fields_set__ contains the field
        if self.import_from_url is None and "import_from_url" in self.__fields_set__:
            _dict['import_from_url'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImageCreateQueryResourceObjectAttributes:
        """Create an instance of ImageCreateQueryResourceObjectAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImageCreateQueryResourceObjectAttributes.parse_obj(obj)

        _obj = ImageCreateQueryResourceObjectAttributes.parse_obj({
            "name": obj.get("name"),
            "import_from_url": obj.get("import_from_url"),
            "hidden": obj.get("hidden") if obj.get("hidden") is not None else False
        })
        return _obj


