# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class DeviceMetadata(BaseModel):
    """
    DeviceMetadata
    """
    device_id: Optional[StrictStr] = Field(None, description="Relatively stable ID for the device. Will update on app uninstall and reinstall")
    klaviyo_sdk: Optional[StrictStr] = Field(None, description="The name of the SDK used to create the push token.")
    sdk_version: Optional[StrictStr] = Field(None, description="The version of the SDK used to create the push token")
    device_model: Optional[StrictStr] = Field(None, description="The model of the device")
    os_name: Optional[StrictStr] = Field(None, description="The name of the operating system on the device.")
    os_version: Optional[StrictStr] = Field(None, description="The version of the operating system on the device")
    manufacturer: Optional[StrictStr] = Field(None, description="The manufacturer of the device")
    app_name: Optional[StrictStr] = Field(None, description="The name of the app that created the push token")
    app_version: Optional[StrictStr] = Field(None, description="The version of the app that created the push token")
    app_build: Optional[StrictStr] = Field(None, description="The build of the app that created the push token")
    app_id: Optional[StrictStr] = Field(None, description="The ID of the app that created the push token")
    environment: Optional[StrictStr] = Field(None, description="The environment in which the push token was created")
    __properties = ["device_id", "klaviyo_sdk", "sdk_version", "device_model", "os_name", "os_version", "manufacturer", "app_name", "app_version", "app_build", "app_id", "environment"]

    @validator('klaviyo_sdk')
    def klaviyo_sdk_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('android', 'swift'):
            raise ValueError("must be one of enum values ('android', 'swift')")
        return value

    @validator('os_name')
    def os_name_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('android', 'ios', 'ipados', 'macos', 'tvos'):
            raise ValueError("must be one of enum values ('android', 'ios', 'ipados', 'macos', 'tvos')")
        return value

    @validator('environment')
    def environment_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('debug', 'release'):
            raise ValueError("must be one of enum values ('debug', 'release')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DeviceMetadata:
        """Create an instance of DeviceMetadata from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DeviceMetadata:
        """Create an instance of DeviceMetadata from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return DeviceMetadata.parse_obj(obj)

        _obj = DeviceMetadata.parse_obj({
            "device_id": obj.get("device_id"),
            "klaviyo_sdk": obj.get("klaviyo_sdk"),
            "sdk_version": obj.get("sdk_version"),
            "device_model": obj.get("device_model"),
            "os_name": obj.get("os_name"),
            "os_version": obj.get("os_version"),
            "manufacturer": obj.get("manufacturer"),
            "app_name": obj.get("app_name"),
            "app_version": obj.get("app_version"),
            "app_build": obj.get("app_build"),
            "app_id": obj.get("app_id"),
            "environment": obj.get("environment")
        })
        return _obj


