# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class CouponCodeCreateQueryResourceObjectAttributes(BaseModel):
    """
    CouponCodeCreateQueryResourceObjectAttributes
    """
    unique_code: Optional[StrictStr] = Field(..., description="This is a unique string that will be or is assigned to each customer/profile and is associated with a coupon.")
    expires_at: Optional[datetime] = Field(None, description="The datetime when this coupon code will expire. If not specified or set to null, it will be automatically set to 1 year.")
    __properties = ["unique_code", "expires_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CouponCodeCreateQueryResourceObjectAttributes:
        """Create an instance of CouponCodeCreateQueryResourceObjectAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if unique_code (nullable) is None
        # and __fields_set__ contains the field
        if self.unique_code is None and "unique_code" in self.__fields_set__:
            _dict['unique_code'] = None

        # set to None if expires_at (nullable) is None
        # and __fields_set__ contains the field
        if self.expires_at is None and "expires_at" in self.__fields_set__:
            _dict['expires_at'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CouponCodeCreateQueryResourceObjectAttributes:
        """Create an instance of CouponCodeCreateQueryResourceObjectAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CouponCodeCreateQueryResourceObjectAttributes.parse_obj(obj)

        _obj = CouponCodeCreateQueryResourceObjectAttributes.parse_obj({
            "unique_code": obj.get("unique_code"),
            "expires_at": obj.get("expires_at")
        })
        return _obj


