# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class CatalogCategoryCreateQueryResourceObjectAttributes(BaseModel):
    """
    CatalogCategoryCreateQueryResourceObjectAttributes
    """
    external_id: Optional[StrictStr] = Field(..., description="The ID of the catalog category in an external system.")
    name: Optional[StrictStr] = Field(..., description="The name of the catalog category.")
    integration_type: Optional[StrictStr] = Field('$custom', description="The integration type. Currently only \"$custom\" is supported.")
    catalog_type: Optional[StrictStr] = Field('$default', description="The type of catalog. Currently only \"$default\" is supported.")
    __properties = ["external_id", "name", "integration_type", "catalog_type"]

    @validator('integration_type')
    def integration_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('$custom'):
            raise ValueError("must be one of enum values ('$custom')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CatalogCategoryCreateQueryResourceObjectAttributes:
        """Create an instance of CatalogCategoryCreateQueryResourceObjectAttributes from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if external_id (nullable) is None
        # and __fields_set__ contains the field
        if self.external_id is None and "external_id" in self.__fields_set__:
            _dict['external_id'] = None

        # set to None if name (nullable) is None
        # and __fields_set__ contains the field
        if self.name is None and "name" in self.__fields_set__:
            _dict['name'] = None

        # set to None if integration_type (nullable) is None
        # and __fields_set__ contains the field
        if self.integration_type is None and "integration_type" in self.__fields_set__:
            _dict['integration_type'] = None

        # set to None if catalog_type (nullable) is None
        # and __fields_set__ contains the field
        if self.catalog_type is None and "catalog_type" in self.__fields_set__:
            _dict['catalog_type'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CatalogCategoryCreateQueryResourceObjectAttributes:
        """Create an instance of CatalogCategoryCreateQueryResourceObjectAttributes from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CatalogCategoryCreateQueryResourceObjectAttributes.parse_obj(obj)

        _obj = CatalogCategoryCreateQueryResourceObjectAttributes.parse_obj({
            "external_id": obj.get("external_id"),
            "name": obj.get("name"),
            "integration_type": obj.get("integration_type") if obj.get("integration_type") is not None else '$custom',
            "catalog_type": obj.get("catalog_type") if obj.get("catalog_type") is not None else '$default'
        })
        return _obj


