# coding: utf-8

"""
    Klaviyo API

    The Klaviyo REST API. Please visit https://developers.klaviyo.com for more details.

    The version of the OpenAPI document: 2024-02-15
    Contact: developers@klaviyo.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


import re  # noqa: F401
import io
import warnings

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from enum import EnumMeta

from typing_extensions import Annotated
from pydantic import Field, StrictStr, conlist, validator

from typing import Any, Dict, Optional

from openapi_client.models.campaign_clone_query import CampaignCloneQuery
from openapi_client.models.campaign_create_query import CampaignCreateQuery
from openapi_client.models.campaign_message_assign_template_query import CampaignMessageAssignTemplateQuery
from openapi_client.models.campaign_message_partial_update_query import CampaignMessagePartialUpdateQuery
from openapi_client.models.campaign_partial_update_query import CampaignPartialUpdateQuery
from openapi_client.models.campaign_recipient_estimation_job_create_query import CampaignRecipientEstimationJobCreateQuery
from openapi_client.models.campaign_send_job_create_query import CampaignSendJobCreateQuery
from openapi_client.models.campaign_send_job_partial_update_query import CampaignSendJobPartialUpdateQuery

from openapi_client.api_client import ApiClient
from openapi_client.api_response import ApiResponse
from openapi_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CampaignsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_campaign(self, campaign_create_query : Annotated[CampaignCreateQuery, Field(..., description="Creates a campaign from parameters")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Create Campaign  # noqa: E501

        Creates a campaign given a set of parameters, then returns it.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign(campaign_create_query, async_req=True)
        >>> result = thread.get()

        :param campaign_create_query: Creates a campaign from parameters (required)
        :type campaign_create_query: CampaignCreateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_campaign_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_campaign_with_http_info(campaign_create_query, **kwargs)  # noqa: E501

    @validate_arguments
    def create_campaign_with_http_info(self, campaign_create_query : Annotated[CampaignCreateQuery, Field(..., description="Creates a campaign from parameters")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create Campaign  # noqa: E501

        Creates a campaign given a set of parameters, then returns it.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_with_http_info(campaign_create_query, async_req=True)
        >>> result = thread.get()

        :param campaign_create_query: Creates a campaign from parameters (required)
        :type campaign_create_query: CampaignCreateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'campaign_create_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['campaign_create_query'] is not None:
            _body_params = _params['campaign_create_query']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '201': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaigns/', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_campaign_clone(self, campaign_clone_query : Annotated[CampaignCloneQuery, Field(..., description="Clones a campaign from an existing campaign")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Create Campaign Clone  # noqa: E501

        Clones an existing campaign, returning a new campaign based on the original with a new ID and name.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_clone(campaign_clone_query, async_req=True)
        >>> result = thread.get()

        :param campaign_clone_query: Clones a campaign from an existing campaign (required)
        :type campaign_clone_query: CampaignCloneQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_campaign_clone_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_campaign_clone_with_http_info(campaign_clone_query, **kwargs)  # noqa: E501

    @validate_arguments
    def create_campaign_clone_with_http_info(self, campaign_clone_query : Annotated[CampaignCloneQuery, Field(..., description="Clones a campaign from an existing campaign")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create Campaign Clone  # noqa: E501

        Clones an existing campaign, returning a new campaign based on the original with a new ID and name.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_clone_with_http_info(campaign_clone_query, async_req=True)
        >>> result = thread.get()

        :param campaign_clone_query: Clones a campaign from an existing campaign (required)
        :type campaign_clone_query: CampaignCloneQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'campaign_clone_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_campaign_clone" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['campaign_clone_query'] is not None:
            _body_params = _params['campaign_clone_query']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '201': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-clone/', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_campaign_message_assign_template(self, campaign_message_assign_template_query : Annotated[CampaignMessageAssignTemplateQuery, Field(..., description="Takes a reusable template, clones it, and assigns the non-reusable clone to the message.")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Assign Campaign Message Template  # noqa: E501

        Creates a non-reusable version of the template and assigns it to the message.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_message_assign_template(campaign_message_assign_template_query, async_req=True)
        >>> result = thread.get()

        :param campaign_message_assign_template_query: Takes a reusable template, clones it, and assigns the non-reusable clone to the message. (required)
        :type campaign_message_assign_template_query: CampaignMessageAssignTemplateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_campaign_message_assign_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_campaign_message_assign_template_with_http_info(campaign_message_assign_template_query, **kwargs)  # noqa: E501

    @validate_arguments
    def create_campaign_message_assign_template_with_http_info(self, campaign_message_assign_template_query : Annotated[CampaignMessageAssignTemplateQuery, Field(..., description="Takes a reusable template, clones it, and assigns the non-reusable clone to the message.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Assign Campaign Message Template  # noqa: E501

        Creates a non-reusable version of the template and assigns it to the message.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_message_assign_template_with_http_info(campaign_message_assign_template_query, async_req=True)
        >>> result = thread.get()

        :param campaign_message_assign_template_query: Takes a reusable template, clones it, and assigns the non-reusable clone to the message. (required)
        :type campaign_message_assign_template_query: CampaignMessageAssignTemplateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'campaign_message_assign_template_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_campaign_message_assign_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['campaign_message_assign_template_query'] is not None:
            _body_params = _params['campaign_message_assign_template_query']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '201': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-message-assign-template/', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_campaign_recipient_estimation_job(self, campaign_recipient_estimation_job_create_query : Annotated[CampaignRecipientEstimationJobCreateQuery, Field(..., description="Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Create Campaign Recipient Estimation Job  # noqa: E501

        Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_recipient_estimation_job(campaign_recipient_estimation_job_create_query, async_req=True)
        >>> result = thread.get()

        :param campaign_recipient_estimation_job_create_query: Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign. (required)
        :type campaign_recipient_estimation_job_create_query: CampaignRecipientEstimationJobCreateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_campaign_recipient_estimation_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_campaign_recipient_estimation_job_with_http_info(campaign_recipient_estimation_job_create_query, **kwargs)  # noqa: E501

    @validate_arguments
    def create_campaign_recipient_estimation_job_with_http_info(self, campaign_recipient_estimation_job_create_query : Annotated[CampaignRecipientEstimationJobCreateQuery, Field(..., description="Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create Campaign Recipient Estimation Job  # noqa: E501

        Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_recipient_estimation_job_with_http_info(campaign_recipient_estimation_job_create_query, async_req=True)
        >>> result = thread.get()

        :param campaign_recipient_estimation_job_create_query: Trigger an asynchronous job to update the estimated number of recipients for the given campaign ID. Use the `Get Campaign Recipient Estimation Job` endpoint to retrieve the status of this estimation job. Use the `Get Campaign Recipient Estimation` endpoint to retrieve the estimated recipient count for a given campaign. (required)
        :type campaign_recipient_estimation_job_create_query: CampaignRecipientEstimationJobCreateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'campaign_recipient_estimation_job_create_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_campaign_recipient_estimation_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['campaign_recipient_estimation_job_create_query'] is not None:
            _body_params = _params['campaign_recipient_estimation_job_create_query']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '202': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-recipient-estimation-jobs/', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_campaign_send_job(self, campaign_send_job_create_query : Annotated[CampaignSendJobCreateQuery, Field(..., description="Trigger the campaign to send asynchronously")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Create Campaign Send Job  # noqa: E501

        Trigger a campaign to send asynchronously<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_send_job(campaign_send_job_create_query, async_req=True)
        >>> result = thread.get()

        :param campaign_send_job_create_query: Trigger the campaign to send asynchronously (required)
        :type campaign_send_job_create_query: CampaignSendJobCreateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the create_campaign_send_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.create_campaign_send_job_with_http_info(campaign_send_job_create_query, **kwargs)  # noqa: E501

    @validate_arguments
    def create_campaign_send_job_with_http_info(self, campaign_send_job_create_query : Annotated[CampaignSendJobCreateQuery, Field(..., description="Trigger the campaign to send asynchronously")], **kwargs) -> ApiResponse:  # noqa: E501
        """Create Campaign Send Job  # noqa: E501

        Trigger a campaign to send asynchronously<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_campaign_send_job_with_http_info(campaign_send_job_create_query, async_req=True)
        >>> result = thread.get()

        :param campaign_send_job_create_query: Trigger the campaign to send asynchronously (required)
        :type campaign_send_job_create_query: CampaignSendJobCreateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'campaign_send_job_create_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_campaign_send_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['campaign_send_job_create_query'] is not None:
            _body_params = _params['campaign_send_job_create_query']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '202': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-send-jobs/', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_campaign(self, id : Annotated[StrictStr, Field(..., description="The campaign ID to be deleted")], **kwargs) -> None:  # noqa: E501
        """Delete Campaign  # noqa: E501

        Delete a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_campaign(id, async_req=True)
        >>> result = thread.get()

        :param id: The campaign ID to be deleted (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the delete_campaign_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.delete_campaign_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def delete_campaign_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The campaign ID to be deleted")], **kwargs) -> ApiResponse:  # noqa: E501
        """Delete Campaign  # noqa: E501

        Delete a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_campaign_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The campaign ID to be deleted (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api/campaigns/{id}/', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign(self, id : Annotated[StrictStr, Field(..., description="The campaign ID to be retrieved")], fields_campaign_message : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_tag : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, include : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign  # noqa: E501

        Returns a specific campaign based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign(id, fields_campaign_message, fields_campaign, fields_tag, include, async_req=True)
        >>> result = thread.get()

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships
        :type include: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_with_http_info(id, fields_campaign_message, fields_campaign, fields_tag, include, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The campaign ID to be retrieved")], fields_campaign_message : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_tag : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, include : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign  # noqa: E501

        Returns a specific campaign based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_with_http_info(id, fields_campaign_message, fields_campaign, fields_tag, include, async_req=True)
        >>> result = thread.get()

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships
        :type include: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_campaign_message',
            'fields_campaign',
            'fields_tag',
            'include'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_campaign_message') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign_message'], EnumMeta):
                _query_params.append(('fields[campaign-message]', _params['fields_campaign_message']))
            else:
                _query_params.append(('fields[campaign-message]', _params['fields_campaign_message']))
            _collection_formats['fields[campaign-message]'] = 'csv'

        if _params.get('fields_campaign') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign'], EnumMeta):
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            else:
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            _collection_formats['fields[campaign]'] = 'csv'

        if _params.get('fields_tag') is not None:  # noqa: E501
            if isinstance(_params['fields_tag'], EnumMeta):
                _query_params.append(('fields[tag]', _params['fields_tag']))
            else:
                _query_params.append(('fields[tag]', _params['fields_tag']))
            _collection_formats['fields[tag]'] = 'csv'

        if _params.get('include') is not None:  # noqa: E501
            if isinstance(_params['include'], EnumMeta):
                _query_params.append(('include', _params['include']))
            else:
                _query_params.append(('include', _params['include']))
            _collection_formats['include'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaigns/{id}/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_campaign_messages(self, id : StrictStr, fields_campaign_message : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_template : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, include : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Campaign Messages  # noqa: E501

        Return all messages that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_campaign_messages(id, fields_campaign_message, fields_campaign, fields_template, include, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships
        :type include: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_campaign_messages_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_campaign_messages_with_http_info(id, fields_campaign_message, fields_campaign, fields_template, include, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_campaign_messages_with_http_info(self, id : StrictStr, fields_campaign_message : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_template : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, include : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Campaign Messages  # noqa: E501

        Return all messages that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_campaign_messages_with_http_info(id, fields_campaign_message, fields_campaign, fields_template, include, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships
        :type include: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_campaign_message',
            'fields_campaign',
            'fields_template',
            'include'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_campaign_messages" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_campaign_message') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign_message'], EnumMeta):
                _query_params.append(('fields[campaign-message]', _params['fields_campaign_message']))
            else:
                _query_params.append(('fields[campaign-message]', _params['fields_campaign_message']))
            _collection_formats['fields[campaign-message]'] = 'csv'

        if _params.get('fields_campaign') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign'], EnumMeta):
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            else:
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            _collection_formats['fields[campaign]'] = 'csv'

        if _params.get('fields_template') is not None:  # noqa: E501
            if isinstance(_params['fields_template'], EnumMeta):
                _query_params.append(('fields[template]', _params['fields_template']))
            else:
                _query_params.append(('fields[template]', _params['fields_template']))
            _collection_formats['fields[template]'] = 'csv'

        if _params.get('include') is not None:  # noqa: E501
            if isinstance(_params['include'], EnumMeta):
                _query_params.append(('include', _params['include']))
            else:
                _query_params.append(('include', _params['include']))
            _collection_formats['include'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaigns/{id}/campaign-messages/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_message(self, id : Annotated[StrictStr, Field(..., description="The message ID to be retrieved")], fields_campaign_message : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_template : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, include : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Message  # noqa: E501

        Returns a specific message based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message(id, fields_campaign_message, fields_campaign, fields_template, include, async_req=True)
        >>> result = thread.get()

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships
        :type include: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_message_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_message_with_http_info(id, fields_campaign_message, fields_campaign, fields_template, include, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_message_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The message ID to be retrieved")], fields_campaign_message : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_template : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, include : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Message  # noqa: E501

        Returns a specific message based on a required id.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_with_http_info(id, fields_campaign_message, fields_campaign, fields_template, include, async_req=True)
        >>> result = thread.get()

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships
        :type include: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_campaign_message',
            'fields_campaign',
            'fields_template',
            'include'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_message" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_campaign_message') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign_message'], EnumMeta):
                _query_params.append(('fields[campaign-message]', _params['fields_campaign_message']))
            else:
                _query_params.append(('fields[campaign-message]', _params['fields_campaign_message']))
            _collection_formats['fields[campaign-message]'] = 'csv'

        if _params.get('fields_campaign') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign'], EnumMeta):
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            else:
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            _collection_formats['fields[campaign]'] = 'csv'

        if _params.get('fields_template') is not None:  # noqa: E501
            if isinstance(_params['fields_template'], EnumMeta):
                _query_params.append(('fields[template]', _params['fields_template']))
            else:
                _query_params.append(('fields[template]', _params['fields_template']))
            _collection_formats['fields[template]'] = 'csv'

        if _params.get('include') is not None:  # noqa: E501
            if isinstance(_params['include'], EnumMeta):
                _query_params.append(('include', _params['include']))
            else:
                _query_params.append(('include', _params['include']))
            _collection_formats['include'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-messages/{id}/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_message_campaign(self, id : StrictStr, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Message Campaign  # noqa: E501

        Return the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_campaign(id, fields_campaign, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_message_campaign_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_message_campaign_with_http_info(id, fields_campaign, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_message_campaign_with_http_info(self, id : StrictStr, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Message Campaign  # noqa: E501

        Return the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_campaign_with_http_info(id, fields_campaign, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_campaign'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_message_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_campaign') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign'], EnumMeta):
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            else:
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            _collection_formats['fields[campaign]'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-messages/{id}/campaign/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_message_relationships_campaign(self, id : StrictStr, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Message Relationships Campaign  # noqa: E501

        Returns the ID of the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_relationships_campaign(id, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_message_relationships_campaign_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_message_relationships_campaign_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_message_relationships_campaign_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Message Relationships Campaign  # noqa: E501

        Returns the ID of the related campaign<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_relationships_campaign_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_message_relationships_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-messages/{id}/relationships/campaign/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_message_relationships_template(self, id : StrictStr, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Message Relationships Template  # noqa: E501

        Returns the ID of the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_relationships_template(id, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_message_relationships_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_message_relationships_template_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_message_relationships_template_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Message Relationships Template  # noqa: E501

        Returns the ID of the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_relationships_template_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_message_relationships_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-messages/{id}/relationships/template/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_message_template(self, id : StrictStr, fields_template : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Message Template  # noqa: E501

        Return the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_template(id, fields_template, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_message_template_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_message_template_with_http_info(id, fields_template, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_message_template_with_http_info(self, id : StrictStr, fields_template : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Message Template  # noqa: E501

        Return the related template<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read` `templates:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_message_template_with_http_info(id, fields_template, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param fields_template: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_template: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_template'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_message_template" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_template') is not None:  # noqa: E501
            if isinstance(_params['fields_template'], EnumMeta):
                _query_params.append(('fields[template]', _params['fields_template']))
            else:
                _query_params.append(('fields[template]', _params['fields_template']))
            _collection_formats['fields[template]'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-messages/{id}/template/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_recipient_estimation(self, id : Annotated[StrictStr, Field(..., description="The ID of the campaign for which to get the estimated number of recipients")], fields_campaign_recipient_estimation : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Recipient Estimation  # noqa: E501

        Get the estimated recipient count for a campaign with the provided campaign ID. You can refresh this count by using the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_recipient_estimation(id, fields_campaign_recipient_estimation, async_req=True)
        >>> result = thread.get()

        :param id: The ID of the campaign for which to get the estimated number of recipients (required)
        :type id: str
        :param fields_campaign_recipient_estimation: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_recipient_estimation_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_recipient_estimation_with_http_info(id, fields_campaign_recipient_estimation, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_recipient_estimation_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The ID of the campaign for which to get the estimated number of recipients")], fields_campaign_recipient_estimation : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Recipient Estimation  # noqa: E501

        Get the estimated recipient count for a campaign with the provided campaign ID. You can refresh this count by using the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_recipient_estimation_with_http_info(id, fields_campaign_recipient_estimation, async_req=True)
        >>> result = thread.get()

        :param id: The ID of the campaign for which to get the estimated number of recipients (required)
        :type id: str
        :param fields_campaign_recipient_estimation: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_campaign_recipient_estimation'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_recipient_estimation" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_campaign_recipient_estimation') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign_recipient_estimation'], EnumMeta):
                _query_params.append(('fields[campaign-recipient-estimation]', _params['fields_campaign_recipient_estimation']))
            else:
                _query_params.append(('fields[campaign-recipient-estimation]', _params['fields_campaign_recipient_estimation']))
            _collection_formats['fields[campaign-recipient-estimation]'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-recipient-estimations/{id}/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_recipient_estimation_job(self, id : Annotated[StrictStr, Field(..., description="The ID of the campaign to get recipient estimation status")], fields_campaign_recipient_estimation_job : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Recipient Estimation Job  # noqa: E501

        Retrieve the status of a recipient estimation job triggered with the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_recipient_estimation_job(id, fields_campaign_recipient_estimation_job, async_req=True)
        >>> result = thread.get()

        :param id: The ID of the campaign to get recipient estimation status (required)
        :type id: str
        :param fields_campaign_recipient_estimation_job: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation_job: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_recipient_estimation_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_recipient_estimation_job_with_http_info(id, fields_campaign_recipient_estimation_job, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_recipient_estimation_job_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The ID of the campaign to get recipient estimation status")], fields_campaign_recipient_estimation_job : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Recipient Estimation Job  # noqa: E501

        Retrieve the status of a recipient estimation job triggered with the `Create Campaign Recipient Estimation Job` endpoint.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_recipient_estimation_job_with_http_info(id, fields_campaign_recipient_estimation_job, async_req=True)
        >>> result = thread.get()

        :param id: The ID of the campaign to get recipient estimation status (required)
        :type id: str
        :param fields_campaign_recipient_estimation_job: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_recipient_estimation_job: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_campaign_recipient_estimation_job'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_recipient_estimation_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_campaign_recipient_estimation_job') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign_recipient_estimation_job'], EnumMeta):
                _query_params.append(('fields[campaign-recipient-estimation-job]', _params['fields_campaign_recipient_estimation_job']))
            else:
                _query_params.append(('fields[campaign-recipient-estimation-job]', _params['fields_campaign_recipient_estimation_job']))
            _collection_formats['fields[campaign-recipient-estimation-job]'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-recipient-estimation-jobs/{id}/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_relationships_campaign_messages(self, id : StrictStr, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Relationships Campaign Messages  # noqa: E501

        Returns the IDs of all messages associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_relationships_campaign_messages(id, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_relationships_campaign_messages_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_relationships_campaign_messages_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_relationships_campaign_messages_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Relationships Campaign Messages  # noqa: E501

        Returns the IDs of all messages associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_relationships_campaign_messages_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_relationships_campaign_messages" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaigns/{id}/relationships/campaign-messages/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_relationships_tags(self, id : StrictStr, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Relationships Tags  # noqa: E501

        Returns the IDs of all tags associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_relationships_tags(id, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_relationships_tags_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_relationships_tags_with_http_info(id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_relationships_tags_with_http_info(self, id : StrictStr, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Relationships Tags  # noqa: E501

        Returns the IDs of all tags associated with the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_relationships_tags_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_relationships_tags" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaigns/{id}/relationships/tags/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_send_job(self, id : Annotated[StrictStr, Field(..., description="The ID of the campaign to send")], fields_campaign_send_job : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Send Job  # noqa: E501

        Get a campaign send job<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_send_job(id, fields_campaign_send_job, async_req=True)
        >>> result = thread.get()

        :param id: The ID of the campaign to send (required)
        :type id: str
        :param fields_campaign_send_job: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_send_job: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_send_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_send_job_with_http_info(id, fields_campaign_send_job, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_send_job_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The ID of the campaign to send")], fields_campaign_send_job : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Send Job  # noqa: E501

        Get a campaign send job<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_send_job_with_http_info(id, fields_campaign_send_job, async_req=True)
        >>> result = thread.get()

        :param id: The ID of the campaign to send (required)
        :type id: str
        :param fields_campaign_send_job: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_send_job: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_campaign_send_job'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_send_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_campaign_send_job') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign_send_job'], EnumMeta):
                _query_params.append(('fields[campaign-send-job]', _params['fields_campaign_send_job']))
            else:
                _query_params.append(('fields[campaign-send-job]', _params['fields_campaign_send_job']))
            _collection_formats['fields[campaign-send-job]'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-send-jobs/{id}/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaign_tags(self, id : StrictStr, fields_tag : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaign Tags  # noqa: E501

        Return all tags that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_tags(id, fields_tag, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaign_tags_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaign_tags_with_http_info(id, fields_tag, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaign_tags_with_http_info(self, id : StrictStr, fields_tag : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaign Tags  # noqa: E501

        Return all tags that belong to the given campaign.<br><br>*Rate limits*:<br>Burst: `3/s`<br>Steady: `60/m`  **Scopes:** `campaigns:read` `tags:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaign_tags_with_http_info(id, fields_tag, async_req=True)
        >>> result = thread.get()

        :param id:  (required)
        :type id: str
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'fields_tag'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaign_tags" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        if _params.get('fields_tag') is not None:  # noqa: E501
            if isinstance(_params['fields_tag'], EnumMeta):
                _query_params.append(('fields[tag]', _params['fields_tag']))
            else:
                _query_params.append(('fields[tag]', _params['fields_tag']))
            _collection_formats['fields[tag]'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaigns/{id}/tags/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_campaigns(self, filter : Annotated[StrictStr, Field(..., description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`")], fields_campaign_message : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_tag : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, include : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships")] = None, page_cursor : Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#pagination")] = None, sort : Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sorting")] = None, **kwargs) -> Dict[str, object]:  # noqa: E501
        """Get Campaigns  # noqa: E501

        Returns some or all campaigns based on filters.  A channel filter is required to list campaigns. Please provide either: `?filter=equals(messages.channel,'email')` to list email campaigns, or `?filter=equals(messages.channel,'sms')` to list SMS campaigns.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaigns(filter, fields_campaign_message, fields_campaign, fields_tag, include, page_cursor, sort, async_req=True)
        >>> result = thread.get()

        :param filter: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than` (required)
        :type filter: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships
        :type include: List[str]
        :param page_cursor: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#pagination
        :type page_cursor: str
        :param sort: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sorting
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the get_campaigns_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.get_campaigns_with_http_info(filter, fields_campaign_message, fields_campaign, fields_tag, include, page_cursor, sort, **kwargs)  # noqa: E501

    @validate_arguments
    def get_campaigns_with_http_info(self, filter : Annotated[StrictStr, Field(..., description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`")], fields_campaign_message : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_campaign : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, fields_tag : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets")] = None, include : Annotated[Optional[conlist(StrictStr)], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships")] = None, page_cursor : Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#pagination")] = None, sort : Annotated[Optional[StrictStr], Field(description="For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sorting")] = None, **kwargs) -> ApiResponse:  # noqa: E501
        """Get Campaigns  # noqa: E501

        Returns some or all campaigns based on filters.  A channel filter is required to list campaigns. Please provide either: `?filter=equals(messages.channel,'email')` to list email campaigns, or `?filter=equals(messages.channel,'sms')` to list SMS campaigns.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:read`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_campaigns_with_http_info(filter, fields_campaign_message, fields_campaign, fields_tag, include, page_cursor, sort, async_req=True)
        >>> result = thread.get()

        :param filter: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#filtering<br>Allowed field(s)/operator(s):<br>`messages.channel`: `equals`<br>`name`: `contains`<br>`status`: `any`, `equals`<br>`archived`: `equals`<br>`created_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`scheduled_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than`<br>`updated_at`: `greater-or-equal`, `greater-than`, `less-or-equal`, `less-than` (required)
        :type filter: str
        :param fields_campaign_message: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign_message: List[str]
        :param fields_campaign: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_campaign: List[str]
        :param fields_tag: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sparse-fieldsets
        :type fields_tag: List[str]
        :param include: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#relationships
        :type include: List[str]
        :param page_cursor: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#pagination
        :type page_cursor: str
        :param sort: For more information please visit https://developers.klaviyo.com/en/v2024-02-15/reference/api-overview#sorting
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'filter',
            'fields_campaign_message',
            'fields_campaign',
            'fields_tag',
            'include',
            'page_cursor',
            'sort'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_campaigns" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('filter') is not None:  # noqa: E501
            if isinstance(_params['filter'], EnumMeta):
                _query_params.append(('filter', _params['filter']))
            else:
                _query_params.append(('filter', _params['filter']))

        if _params.get('fields_campaign_message') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign_message'], EnumMeta):
                _query_params.append(('fields[campaign-message]', _params['fields_campaign_message']))
            else:
                _query_params.append(('fields[campaign-message]', _params['fields_campaign_message']))
            _collection_formats['fields[campaign-message]'] = 'csv'

        if _params.get('fields_campaign') is not None:  # noqa: E501
            if isinstance(_params['fields_campaign'], EnumMeta):
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            else:
                _query_params.append(('fields[campaign]', _params['fields_campaign']))
            _collection_formats['fields[campaign]'] = 'csv'

        if _params.get('fields_tag') is not None:  # noqa: E501
            if isinstance(_params['fields_tag'], EnumMeta):
                _query_params.append(('fields[tag]', _params['fields_tag']))
            else:
                _query_params.append(('fields[tag]', _params['fields_tag']))
            _collection_formats['fields[tag]'] = 'csv'

        if _params.get('include') is not None:  # noqa: E501
            if isinstance(_params['include'], EnumMeta):
                _query_params.append(('include', _params['include']))
            else:
                _query_params.append(('include', _params['include']))
            _collection_formats['include'] = 'csv'

        if _params.get('page_cursor') is not None:  # noqa: E501
            if isinstance(_params['page_cursor'], EnumMeta):
                _query_params.append(('page[cursor]', _params['page_cursor']))
            else:
                _query_params.append(('page[cursor]', _params['page_cursor']))

        if _params.get('sort') is not None:  # noqa: E501
            if isinstance(_params['sort'], EnumMeta):
                _query_params.append(('sort', _params['sort']))
            else:
                _query_params.append(('sort', _params['sort']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaigns/', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_campaign(self, id : Annotated[StrictStr, Field(..., description="The campaign ID to be retrieved")], campaign_partial_update_query : Annotated[CampaignPartialUpdateQuery, Field(..., description="Update a campaign and return it")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Update Campaign  # noqa: E501

        Update a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign(id, campaign_partial_update_query, async_req=True)
        >>> result = thread.get()

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param campaign_partial_update_query: Update a campaign and return it (required)
        :type campaign_partial_update_query: CampaignPartialUpdateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_campaign_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_campaign_with_http_info(id, campaign_partial_update_query, **kwargs)  # noqa: E501

    @validate_arguments
    def update_campaign_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The campaign ID to be retrieved")], campaign_partial_update_query : Annotated[CampaignPartialUpdateQuery, Field(..., description="Update a campaign and return it")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update Campaign  # noqa: E501

        Update a campaign with the given campaign ID.<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign_with_http_info(id, campaign_partial_update_query, async_req=True)
        >>> result = thread.get()

        :param id: The campaign ID to be retrieved (required)
        :type id: str
        :param campaign_partial_update_query: Update a campaign and return it (required)
        :type campaign_partial_update_query: CampaignPartialUpdateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'campaign_partial_update_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_campaign" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['campaign_partial_update_query'] is not None:
            _body_params = _params['campaign_partial_update_query']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaigns/{id}/', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_campaign_message(self, id : Annotated[StrictStr, Field(..., description="The message ID to be retrieved")], campaign_message_partial_update_query : Annotated[CampaignMessagePartialUpdateQuery, Field(..., description="Update a message and return it")], **kwargs) -> Dict[str, object]:  # noqa: E501
        """Update Campaign Message  # noqa: E501

        Update a campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign_message(id, campaign_message_partial_update_query, async_req=True)
        >>> result = thread.get()

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param campaign_message_partial_update_query: Update a message and return it (required)
        :type campaign_message_partial_update_query: CampaignMessagePartialUpdateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Dict[str, object]
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_campaign_message_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_campaign_message_with_http_info(id, campaign_message_partial_update_query, **kwargs)  # noqa: E501

    @validate_arguments
    def update_campaign_message_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The message ID to be retrieved")], campaign_message_partial_update_query : Annotated[CampaignMessagePartialUpdateQuery, Field(..., description="Update a message and return it")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update Campaign Message  # noqa: E501

        Update a campaign message<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign_message_with_http_info(id, campaign_message_partial_update_query, async_req=True)
        >>> result = thread.get()

        :param id: The message ID to be retrieved (required)
        :type id: str
        :param campaign_message_partial_update_query: Update a message and return it (required)
        :type campaign_message_partial_update_query: CampaignMessagePartialUpdateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Dict[str, object], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'id',
            'campaign_message_partial_update_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_campaign_message" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['campaign_message_partial_update_query'] is not None:
            _body_params = _params['campaign_message_partial_update_query']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {
            '200': "Dict[str, object]",
            '4XX': "GetAccounts4XXResponse",
            '5XX': "GetAccounts4XXResponse",
        }

        return self.api_client.call_api(
            '/api/campaign-messages/{id}/', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_campaign_send_job(self, id : Annotated[StrictStr, Field(..., description="The ID of the currently sending campaign to cancel or revert")], campaign_send_job_partial_update_query : Annotated[CampaignSendJobPartialUpdateQuery, Field(..., description="Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT")], **kwargs) -> None:  # noqa: E501
        """Update Campaign Send Job  # noqa: E501

        Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign_send_job(id, campaign_send_job_partial_update_query, async_req=True)
        >>> result = thread.get()

        :param id: The ID of the currently sending campaign to cancel or revert (required)
        :type id: str
        :param campaign_send_job_partial_update_query: Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT (required)
        :type campaign_send_job_partial_update_query: CampaignSendJobPartialUpdateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        if '_preload_content' in kwargs:
            raise ValueError("Error! Please call the update_campaign_send_job_with_http_info method with `_preload_content` instead and obtain raw data from ApiResponse.raw_data")
        return self.update_campaign_send_job_with_http_info(id, campaign_send_job_partial_update_query, **kwargs)  # noqa: E501

    @validate_arguments
    def update_campaign_send_job_with_http_info(self, id : Annotated[StrictStr, Field(..., description="The ID of the currently sending campaign to cancel or revert")], campaign_send_job_partial_update_query : Annotated[CampaignSendJobPartialUpdateQuery, Field(..., description="Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT")], **kwargs) -> ApiResponse:  # noqa: E501
        """Update Campaign Send Job  # noqa: E501

        Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT<br><br>*Rate limits*:<br>Burst: `10/s`<br>Steady: `150/m`  **Scopes:** `campaigns:write`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_campaign_send_job_with_http_info(id, campaign_send_job_partial_update_query, async_req=True)
        >>> result = thread.get()

        :param id: The ID of the currently sending campaign to cancel or revert (required)
        :type id: str
        :param campaign_send_job_partial_update_query: Permanently cancel the campaign, setting the status to CANCELED or revert the campaign, setting the status back to DRAFT (required)
        :type campaign_send_job_partial_update_query: CampaignSendJobPartialUpdateQuery
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the ApiResponse.data will
                                 be set to none and raw_data will store the 
                                 HTTP response body without reading/decoding.
                                 Default is True.
        :type _preload_content: bool, optional
        :param _return_http_data_only: response data instead of ApiResponse
                                       object with status code, headers, etc
        :type _return_http_data_only: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        _params = locals()

        _all_params = [
            'id',
            'campaign_send_job_partial_update_query'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_campaign_send_job" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['id']:
            _path_params['id'] = _params['id']


        # process the query parameters
        _query_params = []
        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))
        # process the form parameters
        _form_params = []
        _files = {}
        # process the body parameter
        _body_params = None
        if _params['campaign_send_job_partial_update_query'] is not None:
            _body_params = _params['campaign_send_job_partial_update_query']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['Klaviyo-API-Key', 'OAuth']  # noqa: E501

        _response_types_map = {}

        return self.api_client.call_api(
            '/api/campaign-send-jobs/{id}/', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
