"use strict";
const cdk = require("@aws-cdk/core");
const artifact_1 = require("../lib/artifact");
const pipeline_1 = require("../lib/pipeline");
const validation_1 = require("../lib/validation");
const fake_source_action_1 = require("./fake-source-action");
function stageForTesting() {
    const stack = new cdk.Stack();
    const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
    return pipeline.addStage({ stageName: 'stage' });
}
module.exports = {
    'name validation'(test) {
        const cases = [
            { name: 'BlahBleep123.@-_', shouldPassValidation: true, explanation: 'should be valid' },
            { name: '', shouldPassValidation: false, explanation: 'the empty string should be invalid' },
            { name: ' BlahBleep', shouldPassValidation: false, explanation: 'spaces should be invalid' },
            { name: '!BlahBleep', shouldPassValidation: false, explanation: '\'!\' should be invalid' }
        ];
        cases.forEach(testCase => {
            const name = testCase.name;
            const validationBlock = () => { validation_1.validateName('test thing', name); };
            if (testCase.shouldPassValidation) {
                test.doesNotThrow(validationBlock, Error, `${name} failed validation but ${testCase.explanation}`);
            }
            else {
                test.throws(validationBlock, Error, `${name} passed validation but ${testCase.explanation}`);
            }
        });
        test.done();
    },
    'Stage validation': {
        'should fail if Stage has no Actions'(test) {
            const stage = stageForTesting();
            test.deepEqual(stage.validate().length, 1);
            test.done();
        }
    },
    'Pipeline validation': {
        'should fail if Pipeline has no Stages'(test) {
            const stack = new cdk.Stack();
            const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
            test.deepEqual(cdk.ConstructNode.validate(pipeline.node).length, 1);
            test.done();
        },
        'should fail if Pipeline has a Source Action in a non-first Stage'(test) {
            const stack = new cdk.Stack();
            const pipeline = new pipeline_1.Pipeline(stack, 'Pipeline');
            pipeline.addStage({
                stageName: 'FirstStage',
                actions: [
                    new fake_source_action_1.FakeSourceAction({
                        actionName: 'FakeSource',
                        output: new artifact_1.Artifact(),
                    }),
                ],
            });
            test.deepEqual(cdk.ConstructNode.validate(pipeline.node).length, 1);
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,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