# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import Union
from pydantic import BaseModel, Field, StrictStr, confloat, conint
from empire_platform_api_public_client.models.auction_timescale import AuctionTimescale
from empire_platform_api_public_client.models.border_direction import BorderDirection
from empire_platform_api_public_client.models.noticeboard_entry_type import NoticeboardEntryType

class SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching(BaseModel):
    """
    SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    type: NoticeboardEntryType = Field(...)
    delivery_day_from: date = Field(..., alias="deliveryDayFrom", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    delivery_day_to: date = Field(..., alias="deliveryDayTo", description="One single calendar day, interpreted in **System Time**  - ISO 8601 compliant string in `yyyy-mm-dd` format ")
    timescale: AuctionTimescale = Field(...)
    direction: BorderDirection = Field(...)
    posted_at: datetime = Field(..., alias="postedAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    expires_at: datetime = Field(..., alias="expiresAt", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    matching_percentage: Union[confloat(le=100, ge=0, multiple_of=0.01, strict=True), conint(le=100, ge=0, strict=True)] = Field(..., alias="matchingPercentage", description="Percentage values, accepted with a precision of maximum 2 decimal places")
    __properties = ["id", "type", "deliveryDayFrom", "deliveryDayTo", "timescale", "direction", "postedAt", "expiresAt", "matchingPercentage"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching:
        """Create an instance of SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching.parse_obj(obj)

        _obj = SecondaryMarketDayAheadOrIntraDayNoticeboardEntryMatching.parse_obj({
            "id": obj.get("id"),
            "type": obj.get("type"),
            "delivery_day_from": obj.get("deliveryDayFrom"),
            "delivery_day_to": obj.get("deliveryDayTo"),
            "timescale": obj.get("timescale"),
            "direction": obj.get("direction"),
            "posted_at": obj.get("postedAt"),
            "expires_at": obj.get("expiresAt"),
            "matching_percentage": obj.get("matchingPercentage")
        })
        return _obj


