# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, confloat, conint, conlist
from empire_platform_api_public_client.models.auction_result_participant import AuctionResultParticipant
from empire_platform_api_public_client.models.public_long_term_auction_results_bids import PublicLongTermAuctionResultsBids

class PublicLongTermAuctionResults(BaseModel):
    """
    PublicLongTermAuctionResults
    """
    bids: conlist(PublicLongTermAuctionResultsBids) = Field(...)
    successful_participants: conlist(AuctionResultParticipant) = Field(..., alias="successfulParticipants")
    marginal_price: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="marginalPrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    reserve_price: Optional[Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)]] = Field(None, alias="reservePrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    __properties = ["bids", "successfulParticipants", "marginalPrice", "reservePrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PublicLongTermAuctionResults:
        """Create an instance of PublicLongTermAuctionResults from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in bids (list)
        _items = []
        if self.bids:
            for _item in self.bids:
                if _item:
                    _items.append(_item.to_dict())
            _dict['bids'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in successful_participants (list)
        _items = []
        if self.successful_participants:
            for _item in self.successful_participants:
                if _item:
                    _items.append(_item.to_dict())
            _dict['successfulParticipants'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PublicLongTermAuctionResults:
        """Create an instance of PublicLongTermAuctionResults from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return PublicLongTermAuctionResults.parse_obj(obj)

        _obj = PublicLongTermAuctionResults.parse_obj({
            "bids": [PublicLongTermAuctionResultsBids.from_dict(_item) for _item in obj.get("bids")] if obj.get("bids") is not None else None,
            "successful_participants": [AuctionResultParticipant.from_dict(_item) for _item in obj.get("successfulParticipants")] if obj.get("successfulParticipants") is not None else None,
            "marginal_price": obj.get("marginalPrice"),
            "reserve_price": obj.get("reservePrice")
        })
        return _obj


