# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt
from empire_platform_api_public_client.models.auction_result_participant import AuctionResultParticipant

class LongTermAuctionResultsAllocatedCapacity(BaseModel):
    """
    * `requestedCapacity` - Sum of ALL bids from the given Participant in kilowatts * `allocatedTrs` - Transmission rights allocated for the given Participant in the Auction   # noqa: E501
    """
    participant: AuctionResultParticipant = Field(...)
    requested_capacity: Optional[StrictInt] = Field(None, alias="requestedCapacity", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    allocated_trs: StrictInt = Field(..., alias="allocatedTrs", description="Capacity value in kilowatts (kW) - the required system precision allows for handling capacity values as integers")
    __properties = ["participant", "requestedCapacity", "allocatedTrs"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LongTermAuctionResultsAllocatedCapacity:
        """Create an instance of LongTermAuctionResultsAllocatedCapacity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of participant
        if self.participant:
            _dict['participant'] = self.participant.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LongTermAuctionResultsAllocatedCapacity:
        """Create an instance of LongTermAuctionResultsAllocatedCapacity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LongTermAuctionResultsAllocatedCapacity.parse_obj(obj)

        _obj = LongTermAuctionResultsAllocatedCapacity.parse_obj({
            "participant": AuctionResultParticipant.from_dict(obj.get("participant")) if obj.get("participant") is not None else None,
            "requested_capacity": obj.get("requestedCapacity"),
            "allocated_trs": obj.get("allocatedTrs")
        })
        return _obj


