# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field
from empire_platform_api_public_client.models.finance_information_lockable_amount import FinanceInformationLockableAmount
from empire_platform_api_public_client.models.finance_information_lockable_date import FinanceInformationLockableDate

class FinanceInformationLockablePeriod(BaseModel):
    """
    FinanceInformationLockablePeriod
    """
    validity_from: FinanceInformationLockableDate = Field(..., alias="validityFrom")
    validity_to: FinanceInformationLockableDate = Field(..., alias="validityTo")
    amount: FinanceInformationLockableAmount = Field(...)
    __properties = ["validityFrom", "validityTo", "amount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FinanceInformationLockablePeriod:
        """Create an instance of FinanceInformationLockablePeriod from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of validity_from
        if self.validity_from:
            _dict['validityFrom'] = self.validity_from.to_dict()
        # override the default output from pydantic by calling `to_dict()` of validity_to
        if self.validity_to:
            _dict['validityTo'] = self.validity_to.to_dict()
        # override the default output from pydantic by calling `to_dict()` of amount
        if self.amount:
            _dict['amount'] = self.amount.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FinanceInformationLockablePeriod:
        """Create an instance of FinanceInformationLockablePeriod from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FinanceInformationLockablePeriod.parse_obj(obj)

        _obj = FinanceInformationLockablePeriod.parse_obj({
            "validity_from": FinanceInformationLockableDate.from_dict(obj.get("validityFrom")) if obj.get("validityFrom") is not None else None,
            "validity_to": FinanceInformationLockableDate.from_dict(obj.get("validityTo")) if obj.get("validityTo") is not None else None,
            "amount": FinanceInformationLockableAmount.from_dict(obj.get("amount")) if obj.get("amount") is not None else None
        })
        return _obj


