# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field

class AuctionProcessStepsAbsolute(BaseModel):
    """
    Deadlines of each phase of the auction  # noqa: E501
    """
    preliminary_spec_publish: datetime = Field(..., alias="preliminarySpecPublish", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    returns_window_close: Optional[datetime] = Field(None, alias="returnsWindowClose", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    final_spec_publish: datetime = Field(..., alias="finalSpecPublish", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    bidding_open: datetime = Field(..., alias="biddingOpen", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    show_bids_for_open_auctions: Optional[datetime] = Field(None, alias="showBidsForOpenAuctions", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    bidding_close: datetime = Field(..., alias="biddingClose", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    provisional_results_publish: datetime = Field(..., alias="provisionalResultsPublish", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    final_results_publish: datetime = Field(..., alias="finalResultsPublish", description="Date and time with zone information, marks an **absolute point** on the timeline  - theoretically can be sent and received with any zone offset (until it marks the desired **absolute point** on the timeline) - in practice it is advised to transfer it in UTC timezone (with Z offset, \"Zulu time\") - ISO 8601 compliant string in `yyyy-mm-ddThh:mm:ss.SSSZ` format ")
    __properties = ["preliminarySpecPublish", "returnsWindowClose", "finalSpecPublish", "biddingOpen", "showBidsForOpenAuctions", "biddingClose", "provisionalResultsPublish", "finalResultsPublish"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuctionProcessStepsAbsolute:
        """Create an instance of AuctionProcessStepsAbsolute from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuctionProcessStepsAbsolute:
        """Create an instance of AuctionProcessStepsAbsolute from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AuctionProcessStepsAbsolute.parse_obj(obj)

        _obj = AuctionProcessStepsAbsolute.parse_obj({
            "preliminary_spec_publish": obj.get("preliminarySpecPublish"),
            "returns_window_close": obj.get("returnsWindowClose"),
            "final_spec_publish": obj.get("finalSpecPublish"),
            "bidding_open": obj.get("biddingOpen"),
            "show_bids_for_open_auctions": obj.get("showBidsForOpenAuctions"),
            "bidding_close": obj.get("biddingClose"),
            "provisional_results_publish": obj.get("provisionalResultsPublish"),
            "final_results_publish": obj.get("finalResultsPublish")
        })
        return _obj


