# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, StrictBool, confloat, conint
from empire_platform_api_public_client.models.auction_bidding_mode import AuctionBiddingMode

class AuctionBiddingConfiguration(BaseModel):
    """
    AuctionBiddingConfiguration
    """
    mode: AuctionBiddingMode = Field(...)
    pre_bidding_allowed: StrictBool = Field(..., alias="preBiddingAllowed", description="Specify if pre-bidding is allowed or not.")
    max_bids_per_participants: conint(strict=True, ge=0) = Field(..., alias="maxBidsPerParticipants", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    min_bid_price: Union[confloat(multiple_of=0.01, strict=True), conint(strict=True)] = Field(..., alias="minBidPrice", description="Currency value in Euros (€), accepted with a precision of maximum 2 decimal places")
    __properties = ["mode", "preBiddingAllowed", "maxBidsPerParticipants", "minBidPrice"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuctionBiddingConfiguration:
        """Create an instance of AuctionBiddingConfiguration from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuctionBiddingConfiguration:
        """Create an instance of AuctionBiddingConfiguration from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AuctionBiddingConfiguration.parse_obj(obj)

        _obj = AuctionBiddingConfiguration.parse_obj({
            "mode": obj.get("mode"),
            "pre_bidding_allowed": obj.get("preBiddingAllowed"),
            "max_bids_per_participants": obj.get("maxBidsPerParticipants"),
            "min_bid_price": obj.get("minBidPrice")
        })
        return _obj


