# coding: utf-8

"""
    Platform API

    _OpenAPI specification for the **Platform API** of **Empire**, the allocation and nomination platform of BritNed_  ---  Additional documentation available in the API's [GitHub repository](https://github.com/britned/empire-platform-api) 

    The version of the OpenAPI document: 3.0.2
    Contact: britned.info@britned.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictStr, conint

class Attachment(BaseModel):
    """
    Represents an attachment (file) stored in a persistent way  - `fileName`: Name of the attachment including extension, example: `attachment.xls` - `fileSize`: Size of the file in bytes, example: `2338` - `mimeType`: Standard MIME type of attachment, example: `application/vnd.ms-excel` - `url`: Address from where the binary file can be downloaded, example: `https://example.com/document.xls`   # noqa: E501
    """
    id: StrictStr = Field(..., description="Unique identifier for the record in UUID4 format")
    file_name: StrictStr = Field(..., alias="fileName")
    file_size: conint(strict=True, ge=0) = Field(..., alias="fileSize", description="Natural numbers {0, 1, 2, 3, ...} used for counting elements")
    mime_type: StrictStr = Field(..., alias="mimeType")
    url: StrictStr = Field(...)
    __properties = ["id", "fileName", "fileSize", "mimeType", "url"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Attachment:
        """Create an instance of Attachment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Attachment:
        """Create an instance of Attachment from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Attachment.parse_obj(obj)

        _obj = Attachment.parse_obj({
            "id": obj.get("id"),
            "file_name": obj.get("fileName"),
            "file_size": obj.get("fileSize"),
            "mime_type": obj.get("mimeType"),
            "url": obj.get("url")
        })
        return _obj


