# Generated by Django 3.2.11 on 2022-01-17 15:23

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="WebSocketSession",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("connection_id", models.CharField(max_length=255, unique=True)),
                (
                    "channel_name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Used to group connections together",
                        max_length=128,
                    ),
                ),
                (
                    "connected",
                    models.BooleanField(
                        default=True,
                        help_text="Indicates is the connection is current or not",
                    ),
                ),
                ("request_count", models.PositiveBigIntegerField(default=1)),
                ("created_on", models.DateTimeField(auto_now_add=True)),
                ("updated_on", models.DateTimeField(auto_now=True)),
                (
                    "author",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="websocket_sessions",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="websocketsession",
            index=models.Index(
                fields=["connection_id", "connected"],
                name="django_aws__connect_fee1eb_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="websocketsession",
            index=models.Index(
                fields=["channel_name", "connection_id"],
                name="django_aws__channel_dd10fa_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="websocketsession",
            index=models.Index(
                fields=["channel_name", "connected"],
                name="django_aws__channel_1de026_idx",
            ),
        ),
    ]
