/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.HsqlDateTime;
import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.lib.ArrayUtil;
import com.datapps.linkoopdb.jdbc.lib.StringConverter;
import com.datapps.linkoopdb.jdbc.lib.StringUtil;
import com.datapps.linkoopdb.jdbc.lib.java.JavaSystem;
import com.datapps.linkoopdb.jdbc.types.BlobData;
import com.datapps.linkoopdb.jdbc.types.Charset;
import com.datapps.linkoopdb.jdbc.types.ClobData;
import com.datapps.linkoopdb.jdbc.types.ClobDataID;
import com.datapps.linkoopdb.jdbc.types.ClobType;
import com.datapps.linkoopdb.jdbc.types.Collation;
import com.datapps.linkoopdb.jdbc.types.DateTimeType;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;

public class CharacterType
extends Type {
    public static final int defaultVarcharPrecision = 32768;
    public static final long maxCharPrecision = Integer.MAX_VALUE;
    static final int defaultCharPrecision = 256;
    private static final int fixedTypesLength = 32;
    static CharacterType[] charArray = new CharacterType[32];
    transient Collation collation;
    transient Charset charset;
    String nameString;

    public CharacterType(Collation collation, int type, long precision) {
        super(12, type, precision, 0);
        if (collation == null) {
            collation = Collation.getDefaultInstance();
        }
        this.collation = collation;
        this.charset = Charset.getDefaultInstance();
        this.nameString = this.getNameStringPrivate();
    }

    public CharacterType(int type, long precision) {
        super(12, type, precision, 0);
        this.collation = Collation.getDefaultInstance();
        this.charset = Charset.getDefaultInstance();
        this.nameString = this.getNameStringPrivate();
    }

    public static int getRightTrimSize(String s, char trim) {
        int endindex = s.length();
        --endindex;
        while (endindex >= 0 && s.charAt(endindex) == trim) {
            --endindex;
        }
        return ++endindex;
    }

    public static CharacterType getCharacterType(int type, long length) {
        switch (type) {
            case 1: {
                if (length < 32L) {
                    return charArray[(int)length];
                }
            }
            case 12: {
                return new CharacterType(type, (int)length);
            }
            case 40: {
                return new ClobType(length);
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public static CharacterType getCharacterType(int type, long length, Collation collation) {
        if (collation == null) {
            collation = Collation.getDefaultInstance();
        }
        switch (type) {
            case 1: 
            case 12: {
                return new CharacterType(collation, type, (int)length);
            }
            case 40: {
                ClobType typeObject = new ClobType(length);
                typeObject.collation = collation;
                return typeObject;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 1: {
                return 1;
            }
            case 12: {
                return 12;
            }
            case 40: {
                return 2005;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Class getJDBCClass() {
        return String.class;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public String getJDBCClassName() {
        return "java.lang.String";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode == 1 ? this.typeCode : 12;
    }

    @Override
    public String getNameString() {
        return this.nameString;
    }

    private String getNameStringPrivate() {
        switch (this.typeCode) {
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case 40: {
                return "CLOB";
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "CHARACTER VARYING";
            }
            case 40: {
                return "CHARACTER LARGE OBJECT";
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(this.precision);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean isCharacterType() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean requiresPrecision() {
        return this.typeCode == 12;
    }

    @Override
    public int precedenceDegree(Type other) {
        if (other.typeCode == this.typeCode) {
            return 0;
        }
        if (!other.isCharacterType()) {
            return Integer.MIN_VALUE;
        }
        switch (this.typeCode) {
            case 1: {
                return other.typeCode == 40 ? 4 : 2;
            }
            case 12: {
                return other.typeCode == 40 ? 4 : 2;
            }
            case 40: {
                return other.typeCode == 1 ? -4 : -2;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == other.typeCode) {
            return this.precision >= other.precision ? this : other;
        }
        switch (other.typeCode) {
            case 91: {
                return DateTimeType.getDateTimeType(other.typeCode, other.scale);
            }
            case 1: {
                return this.precision >= other.precision ? this : CharacterType.getCharacterType(this.typeCode, other.precision, other.getCollation());
            }
            case 12: {
                if (this.typeCode == 40) {
                    return this.precision >= other.precision ? this : CharacterType.getCharacterType(this.typeCode, other.precision, other.getCollation());
                }
                return other.precision >= this.precision ? other : CharacterType.getCharacterType(other.typeCode, this.precision, other.getCollation());
            }
            case 40: {
                return other.precision >= this.precision ? other : CharacterType.getCharacterType(other.typeCode, this.precision, other.getCollation());
            }
            case 14: 
            case 15: 
            case 30: 
            case 60: 
            case 61: 
            case 1111: {
                throw Error.error(5562);
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(SessionInterface session, Type other, int operation) {
        Type newType;
        if (operation != 36) {
            return this.getAggregateType(other);
        }
        long newPrecision = this.precision + other.precision;
        switch (other.typeCode) {
            case 0: {
                return this;
            }
            case 1: {
                newType = this;
                break;
            }
            case 12: {
                newType = this.typeCode == 40 ? this : other;
                break;
            }
            case 40: {
                newType = other;
                break;
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (newPrecision > Integer.MAX_VALUE) {
            if (this.typeCode == 60) {
                newPrecision = Integer.MAX_VALUE;
            } else if (this.typeCode == 1) {
                newPrecision = Integer.MAX_VALUE;
            } else if (this.typeCode == 12) {
                newPrecision = Integer.MAX_VALUE;
            }
        }
        return CharacterType.getCharacterType(newType.typeCode, newPrecision, this.collation);
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b) {
        return this.compare(session, a, b, 40);
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b, int opType) {
        int lb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (b instanceof ClobData) {
            return -typeHelper.compareClob(this.collation, session, b, a);
        }
        String as = (String)a;
        String bs = (String)b;
        int la = as.length();
        if (la != (lb = bs.length())) {
            if (la > lb) {
                if (this.collation.isPadSpace() && opType != 42) {
                    char[] buffer = new char[la];
                    bs.getChars(0, lb, buffer, 0);
                    ArrayUtil.fillArray(buffer, lb, ' ');
                    bs = String.valueOf(buffer);
                }
            } else if (this.collation.isPadSpace() && opType != 42) {
                char[] buffer = new char[lb];
                as.getChars(0, la, buffer, 0);
                ArrayUtil.fillArray(buffer, la, ' ');
                as = String.valueOf(buffer);
            }
        }
        return this.collation.compare(as, bs);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (this.precision == 0L) {
            return a;
        }
        switch (this.typeCode) {
            case 1: {
                int slen = ((String)a).length();
                if ((long)slen == this.precision) {
                    return a;
                }
                if ((long)slen > this.precision) {
                    if ((long)CharacterType.getRightTrimSize((String)a, ' ') <= this.precision) {
                        return ((String)a).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                char[] b = new char[(int)this.precision];
                ((String)a).getChars(0, slen, b, 0);
                int i = slen;
                while ((long)i < this.precision) {
                    b[i] = 32;
                    ++i;
                }
                return new String(b);
            }
            case 12: {
                int slen = ((String)a).length();
                if ((long)slen > this.precision) {
                    if ((long)CharacterType.getRightTrimSize((String)a, ' ') <= this.precision) {
                        return ((String)a).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                return a;
            }
            case 40: {
                ClobData clob = (ClobData)a;
                if (clob.length(session) > this.precision) {
                    throw Error.error(3401);
                }
                return a;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public Object castToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        return this.castOrConvertToType(session, a, otherType, true);
    }

    public Object castOrConvertToType(SessionInterface session, Object a, Type otherType, boolean cast) {
        switch (otherType.typeCode) {
            case 1: 
            case 12: {
                if (a instanceof BigDecimal) {
                    a = a.toString();
                }
                int length = ((String)a).length();
                if (this.precision != 0L && (long)length > this.precision) {
                    if ((long)StringUtil.rightTrimSize((String)a) > this.precision) {
                        if (!cast) {
                            throw Error.error(3401);
                        }
                        session.addWarning(Error.error(1004));
                    }
                    a = ((String)a).substring(0, (int)this.precision);
                }
                switch (this.typeCode) {
                    case 1: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 12: {
                        return a;
                    }
                    case 40: {
                        ClobDataID clob = session.createClob(((String)a).length());
                        clob.setString(session, 0L, (String)a);
                        return clob;
                    }
                }
                throw Error.runtimeError(201, "CharacterType");
            }
            case 40: {
                long length = ((ClobData)a).length(session);
                if (this.precision != 0L && length > this.precision) {
                    if (!cast) {
                        throw Error.error(3401);
                    }
                    session.addWarning(Error.error(1004));
                }
                switch (this.typeCode) {
                    case 1: 
                    case 12: {
                        if (length > Integer.MAX_VALUE) {
                            if (!cast) {
                                throw Error.error(3401);
                            }
                            length = Integer.MAX_VALUE;
                        }
                        a = ((ClobData)a).getSubString(session, 0L, (int)length);
                        return this.convertToTypeLimits(session, a);
                    }
                    case 40: {
                        if (this.precision != 0L && length > this.precision) {
                            return ((ClobData)a).getClob(session, 0L, this.precision);
                        }
                        return a;
                    }
                }
                throw Error.runtimeError(201, "CharacterType");
            }
            case 1111: {
                throw Error.error(5561);
            }
            case 30: {
                long blobLength = ((BlobData)a).length(session);
                if (this.precision != 0L && blobLength * 2L > this.precision) {
                    throw Error.error(3401);
                }
                byte[] bytes = ((BlobData)a).getBytes(session, 0L, (int)blobLength);
                a = StringConverter.byteArrayToHexString(bytes);
                return this.convertToTypeLimits(session, a);
            }
        }
        String s = otherType.convertToString(a);
        if (this.precision != 0L && (long)s.length() > this.precision) {
            throw Error.error(3401);
        }
        a = s;
        return this.convertToTypeLimits(session, a);
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        return this.castOrConvertToType(session, a, otherType, false);
    }

    @Override
    public Object convertWorkerToDb(SessionInterface session, Object a, Type type) {
        if (a == null) {
            return a;
        }
        return this.castOrConvertToType(session, a, type, true);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        if (otherType.typeCode == 30) {
            throw Error.error(5561);
        }
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        String s;
        if (a == null) {
            return a;
        }
        if (a instanceof Boolean) {
            s = a.toString();
        } else if (a instanceof BigDecimal) {
            s = JavaSystem.toString((BigDecimal)a);
        } else if (a instanceof Number) {
            s = a.toString();
        } else if (a instanceof String) {
            s = (String)a;
        } else if (a instanceof Date) {
            s = a.toString();
        } else if (a instanceof Time) {
            s = a.toString();
        } else if (a instanceof Timestamp) {
            s = a.toString();
        } else if (a instanceof java.util.Date) {
            s = HsqlDateTime.getTimestampString(((java.util.Date)a).getTime());
        } else if (a instanceof UUID) {
            s = a.toString();
        } else {
            s = this.convertJavaTimeObject(session, a);
            if (s == null) {
                throw Error.error(5561);
            }
        }
        return s;
    }

    String convertJavaTimeObject(SessionInterface session, Object a) {
        switch (a.getClass().getName()) {
            case "java.time.LocalDate": 
            case "java.time.LocalTime": {
                return a.toString();
            }
            case "java.time.LocalDateTime": 
            case "java.time.OffsetDateTime": 
            case "java.time.OffsetTime": {
                return a.toString().replace('T', ' ');
            }
        }
        return null;
    }

    @Override
    public Object convertJavaToSQL(SessionInterface session, Object a) {
        return this.convertToDefaultType(session, a);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 1: {
                int slen = ((String)a).length();
                if (this.precision == 0L || (long)slen == this.precision) {
                    return (String)a;
                }
                char[] b = new char[(int)this.precision];
                ((String)a).getChars(0, slen, b, 0);
                int i = slen;
                while ((long)i < this.precision) {
                    b[i] = 32;
                    ++i;
                }
                return new String(b);
            }
            case 12: {
                return (String)a;
            }
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        String s = this.convertToString(a);
        return StringConverter.toQuotedString(s, '\'', true);
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return !otherType.isObjectType() && !otherType.isArrayType();
    }

    @Override
    public int canMoveFrom(Type otherType) {
        if (otherType == this) {
            return 0;
        }
        if (!otherType.isCharacterType()) {
            return -1;
        }
        switch (this.typeCode) {
            case 12: {
                if (otherType.typeCode == this.typeCode) {
                    return this.precision >= otherType.precision ? 0 : 1;
                }
                if (otherType.typeCode == 1) {
                    return this.precision >= otherType.precision ? 0 : -1;
                }
                return -1;
            }
            case 40: {
                if (otherType.typeCode == 40) {
                    return this.precision >= otherType.precision ? 0 : 1;
                }
                return -1;
            }
            case 1: {
                return otherType.typeCode == 1 && this.precision == otherType.precision ? 0 : -1;
            }
        }
        return -1;
    }

    @Override
    public Collation getCollation() {
        return this.collation;
    }

    public void setCollation(Collation collation) {
        this.collation = collation;
    }

    @Override
    public Charset getCharacterSet() {
        return this.charset;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    public long position(SessionInterface session, Object data, Object otherData, Type otherType, long offset) {
        if (data == null || otherData == null) {
            return -1L;
        }
        if (otherType.typeCode == 40) {
            long otherLength = ((ClobData)otherData).length(session);
            if (offset + otherLength > (long)((String)data).length()) {
                return -1L;
            }
            if (otherLength > Integer.MAX_VALUE) {
                throw Error.error(3459);
            }
            String otherString = ((ClobData)otherData).getSubString(session, 0L, (int)otherLength);
            return ((String)data).indexOf(otherString, (int)offset);
        }
        if (otherType.isCharacterType()) {
            long otherLength = ((String)otherData).length();
            if (offset + otherLength > (long)((String)data).length()) {
                return -1L;
            }
            return ((String)data).indexOf((String)otherData, (int)offset);
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public Object substring(SessionInterface session, Object data, long offset, long length, boolean hasLength, boolean trailing) {
        long end;
        long dataLength;
        long l = dataLength = this.typeCode == 40 ? ((ClobData)data).length(session) : (long)((String)data).length();
        if (trailing) {
            end = dataLength;
            offset = length > dataLength ? 0L : dataLength - length;
        } else if (hasLength) {
            end = offset + length;
        } else {
            long l2 = end = dataLength > offset ? dataLength : offset;
        }
        if (end < offset) {
            throw Error.error(3431);
        }
        if (offset > end || end < 0L) {
            offset = 0L;
            end = 0L;
        }
        if (offset < 0L) {
            offset = 0L;
        }
        if (end > dataLength) {
            end = dataLength;
        }
        length = end - offset;
        if (data instanceof String) {
            return ((String)data).substring((int)offset, (int)(offset + length));
        }
        if (data instanceof ClobData) {
            ClobDataID clob = session.createClob(length);
            if (length > Integer.MAX_VALUE) {
                throw Error.error(3401);
            }
            String result = ((ClobData)data).getSubString(session, offset, (int)length);
            clob.setString(session, 0L, result);
            return clob;
        }
        throw Error.runtimeError(201, "CharacterType");
    }

    public Object upper(SessionInterface session, Object data) {
        if (data == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String result = ((ClobData)data).getSubString(session, 0L, (int)((ClobData)data).length(session));
            result = this.collation.toUpperCase(result);
            ClobDataID clob = session.createClob(result.length());
            clob.setString(session, 0L, result);
            return clob;
        }
        return this.collation.toUpperCase((String)data);
    }

    public Object lower(SessionInterface session, Object data) {
        if (data == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String result = ((ClobData)data).getSubString(session, 0L, (int)((ClobData)data).length(session));
            result = this.collation.toLowerCase(result);
            ClobDataID clob = session.createClob(result.length());
            clob.setString(session, 0L, result);
            return clob;
        }
        return this.collation.toLowerCase((String)data);
    }

    public Object trim(SessionInterface session, Object data, char trim, boolean leading, boolean trailing) {
        int startindex;
        String s;
        if (data == null) {
            return null;
        }
        if (this.typeCode == 40) {
            long length = ((ClobData)data).length(session);
            if (length > Integer.MAX_VALUE) {
                throw Error.error(3459);
            }
            s = ((ClobData)data).getSubString(session, 0L, (int)length);
        } else {
            s = (String)data;
        }
        int endindex = s.length();
        if (trailing) {
            --endindex;
            while (endindex >= 0 && s.charAt(endindex) == trim) {
                --endindex;
            }
            ++endindex;
        }
        if (leading) {
            for (startindex = 0; startindex < endindex && s.charAt(startindex) == trim; ++startindex) {
            }
        }
        if (startindex != 0 || endindex != s.length()) {
            s = s.substring(startindex, endindex);
        }
        if (this.typeCode == 40) {
            ClobDataID clob = session.createClob(s.length());
            clob.setString(session, 0L, s);
            return clob;
        }
        return s;
    }

    public Object overlay(SessionInterface session, Object data, Object overlay, long offset, long length, boolean hasLength) {
        if (data == null || overlay == null) {
            return null;
        }
        if (!hasLength) {
            length = this.typeCode == 40 ? ((ClobData)overlay).length(session) : (long)((String)overlay).length();
        }
        Object temp = this.concat(null, this.substring(session, data, 0L, offset, true, false), overlay);
        return this.concat(null, temp, this.substring(session, data, offset + length, 0L, false, false));
    }

    @Override
    public Object concat(SessionInterface session, Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        String left = a instanceof ClobData ? ((ClobData)a).getSubString(session, 0L, (int)((ClobData)a).length(session)) : (String)a;
        String right = b instanceof ClobData ? ((ClobData)b).getSubString(session, 0L, (int)((ClobData)b).length(session)) : (String)b;
        if (this.typeCode == 40) {
            ClobDataID clob = session.createClob(left.length() + right.length());
            clob.setString(session, 0L, left);
            clob.setString(session, left.length(), right);
            return clob;
        }
        return left + right;
    }

    public long size(SessionInterface session, Object data) {
        if (this.typeCode == 40) {
            return ((ClobData)data).length(session);
        }
        return ((String)data).length();
    }

    public Boolean match(SessionInterface session, String string, String[] array) {
        if (string == null || array == null) {
            return null;
        }
        String s = null;
        int offset = 0;
        boolean match = true;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                ++offset;
                match = true;
            } else if (array[i].length() == 0) {
                match = false;
            }
            if (match) {
                if (offset + array[i].length() > string.length()) {
                    return Boolean.FALSE;
                }
                s = string.substring(offset, offset + array[i].length());
                if (this.collation.compare(s, array[i]) != 0) {
                    return Boolean.FALSE;
                }
                offset += array[i].length();
                continue;
            }
            int index = string.indexOf(array[i], offset);
            if (index < 0) {
                return Boolean.FALSE;
            }
            offset = index + array[i].length();
            match = true;
        }
        return Boolean.TRUE;
    }

    public Type getCharacterType(long length) {
        if (length == this.precision) {
            return this;
        }
        return CharacterType.getCharacterType(this.typeCode, length, this.collation);
    }

    @Override
    public Object convertDbToWorker(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        return a.toString();
    }

    static {
        for (int i = 0; i < charArray.length; ++i) {
            CharacterType.charArray[i] = new CharacterType(1, i);
        }
    }
}

