from __future__ import print_function, unicode_literals
from ..tokens import Tokens
from ..config import Config
from ..singleton import Singleton
from youtrack.connection import Connection
from youtrack.youtrack import YouTrackException
from PyInquirer import prompt

import os
import re

tokens = Tokens()
config = Config().load()


class YoutrackHandler(metaclass=Singleton):
    _client = None

    def __init__(self):
        self._client = Connection(
            url=config['youtrack']['url'], token=tokens.youtrack)

    def get_users(self):
        return self._client.get_users()

    def get_issue(self, issue_id):
        return self._client.get_issue(issue_id)

    def get_issues(self, slug, filter, min, max):
        return self._client.get_issues(slug, filter, min, max)

    def get_boards(self):
        return self._client.get_all_agiles()

    def validate_issue(self, issue_id):
        try:
            if self.get_issue(issue_id):
                return True
        except (YouTrackException) as e:
            return False

    def comment(self, issue_id, comment):
        self._client.execute_command(issue_id, 'comment', comment=comment)

    def update_state(self, issue_id, status):
        self._client.execute_command(issue_id, 'State {}'.format(status))

    def add_tag(self, issue_id, label):
        self._client.execute_command(issue_id, 'tag {}'.format(label))

    def assign_to(self, issue_id, user):
        self._client.execute_command(issue_id, "Assignee {}".format(user))

    def select_issue(self):
        issue = prompt([
            {
                'type': 'input',
                'name': 'name',
                'message': "Inserisci il numero della issue su youtrack",
                'default': "PRIMA-000",
                'validate': lambda val: self.validate_issue(val)
            }
        ])

        return self.get_issue(issue['name'])

    def get_link(self, issue_id):
        return "https://prima-assicurazioni-spa.myjetbrains.com/youtrack/issue/{}".format(issue_id)

    def update_issue(self, issue_id, summary, description):
        return self._client.update_issue(issue_id, summary, description)

    def get_issue_ids(self, commits):
        issue_ids = []
        for c in commits:
            issue_id = self.get_card_from_name(c.commit.message)
            if issue_id:
                issue_ids.append(issue_id)
        return issue_ids

    def get_card_from_name(self, name):
        regex = '[A-Z]+-[0-9]+'
        if re.search(regex, name):
            id_card = re.findall(regex, name)[0]
            if not self.validate_issue(id_card):
                return None
            return id_card
