## How to Use

### 1. Clone the repository

```bash
git clone https://github.com/SoarAILabs/glide.git
```

### 2. Navigate to the project directory

```bash
cd glide
```

### 3. Start the server

```bash
uv run python -m src.mcp.app
```

> **Note:** Currently, only [Cursor](https://www.cursor.so/) is supported as the MCP Client.

### 4. Configure Cursor to use your local MCP server

**One-Click Install:**

[![Install MCP Server](https://cursor.com/deeplink/mcp-install-dark.svg)](https://cursor.com/en-US/install-mcp?name=glide-mcp&config=eyJlbnYiOnsiVk9ZQUdFQUlfQVBJX0tFWSI6IiIsIkhFTElYX0FQSV9FTkRQT0lOVCI6IiIsIkNFUkVCUkFTX0FQSV9LRVkiOiIiLCJDRVJFQlJBU19NT0RFTF9JRCI6InF3ZW4tMy0zMmIiLCJIRUxJWF9MT0NBTCI6IiJ9LCJjb21tYW5kIjoidXZ4IC0tZnJvbSBnbGlkZS1tY3AgZ2xpZGUifQ%3D%3D)

**Manual Installation:**

Add the following to your `mcp.json` configuration in Cursor:

```json
{
  "mcpServers": {
    "glide": {
      "url": "http://127.0.0.1:8000/mcp"
    }
  }
}
```

> **Note:** The port (`8000` above) is just an example.  
> To use a different port, open `src/mcp/app.py` and update the following lines accordingly:

```python
if __name__ == "__main__":
    mcp.run(transport="streamable-http", host="127.0.0.1", port=8000)
```

Replace `8000` with your desired port number.