"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Probe = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const k8s = require("./imports/k8s");
/**
 * Probe describes a health check to be performed against a container to
 * determine whether it is alive or ready to receive traffic.
 */
class Probe {
    /**
     * Defines a probe based on an HTTP GET request to the IP address of the container.
     *
     * @param path The URL path to hit
     * @param options Options
     */
    static fromHttpGet(path, options = {}) {
        return {
            _toKube(container) {
                var _b, _c;
                return {
                    ...parseProbeOptions(options),
                    httpGet: {
                        path,
                        port: k8s.IntOrString.fromNumber((_c = (_b = options.port) !== null && _b !== void 0 ? _b : container.port) !== null && _c !== void 0 ? _c : 80),
                    },
                };
            },
        };
    }
    /**
     * Defines a probe based on a command which is executed within the container.
     *
     * @param command The command to execute
     * @param options Options
     */
    static fromCommand(command, options = {}) {
        return {
            _toKube: _ => ({
                ...parseProbeOptions(options),
                exec: { command },
            }),
        };
    }
    /**
     * Defines a probe based opening a connection to a TCP socket on the container.
     *
     * @param options Options
     */
    static fromTcpSocket(options = {}) {
        return {
            _toKube(container) {
                var _b, _c;
                return {
                    ...parseProbeOptions(options),
                    tcpSocket: {
                        port: k8s.IntOrString.fromNumber((_c = (_b = options.port) !== null && _b !== void 0 ? _b : container.port) !== null && _c !== void 0 ? _c : 80),
                        host: options.host,
                    },
                };
            },
        };
    }
}
exports.Probe = Probe;
_a = JSII_RTTI_SYMBOL_1;
Probe[_a] = { fqn: "cdk8s-plus-22.Probe", version: "1.0.0-beta.136" };
function parseProbeOptions(options = {}) {
    var _b;
    return {
        failureThreshold: (_b = options.failureThreshold) !== null && _b !== void 0 ? _b : 3,
        initialDelaySeconds: options.initialDelaySeconds ? options.initialDelaySeconds.toSeconds() : undefined,
        periodSeconds: options.periodSeconds ? options.periodSeconds.toSeconds() : undefined,
        successThreshold: options.successThreshold,
        timeoutSeconds: options.timeoutSeconds ? options.timeoutSeconds.toSeconds() : undefined,
    };
}
//# sourceMappingURL=data:application/json;base64,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