//------------------------------------------------------------------------------
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.
//
// © H2O.ai 2018
//------------------------------------------------------------------------------
#include <limits>
#include "read/constants.h"
#include "utils/macros.h"
namespace dt {
namespace read {


// characters re-interpreted as hex digits (or 99 for characters that are not
// valid digits). Thus, this table maps
//   '0' .. '9'  into  0 .. 9
//   'a' .. 'f'  into  10 .. 15
//   'A' .. 'F'  into  10 .. 15
//   everything else into 99
const uint8_t hexdigits[256] = {
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 00 .. 0F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 10 .. 1F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 20 .. 2F
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9,  99, 99, 99, 99, 99, 99,  // 30 .. 3F
  99, 10, 11, 12, 13, 14, 15, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 40 .. 4F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 50 .. 5F
  99, 10, 11, 12, 13, 14, 15, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 60 .. 6F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 70 .. 7F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 80 .. 8F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // 90 .. 9F
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // A0 .. AF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // B0 .. BF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // C0 .. CF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // D0 .. DF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99,  // E0 .. EF
  99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99, 99   // F0 .. FF
};

// Prohibited seps:
//   * «\n» (0x0A), «\r» (0x0D)
//   * «"» (0x22), «'» (0x27), «\» (0x5C)
//   * «(», «)» (0x28, 0x29), «<», «>» (0x3C, 0x3E), «[», «]» (0x5B, 0x5D),
//     «{», «}» (0x7B, 0x7D)
//   * «+» (0x2B), «-» (0x2D), «.» (0x2E)
//   * «0» .. «9» (0x30 .. 0x39)
//   * «A» .. «Z» (0x41 .. 0x5A), «a» .. «z» (0x61 .. 0x7A)
// Seps with elevated priority:
//   * «,» (0x2C), «\t» (0x09), «;» (0x3B), «|» (0x7C), «:» (0x3A)
// Seps with reduced priority:
//   * «@» (0x40), «^» (0x5E), «_» (0x5F), « » (0x20)
// Seps with lowest priority:
//   * «!» (0x21), «#» (0x23), «$» (0x24), «%» (0x25), «&» (0x26), «*» (0x2A),
//     «=» (0x3D), «?» (0x3F), «`» (0x60)
//
const uint8_t allowedseps[128] = {
  // 1  2  3  4  5  6  7  8  9  A  B  C  D  E  F
  5, 5, 5, 5, 5, 5, 5, 5, 5, 8, 0, 5, 5, 0, 5, 5,  // 00 .. 0F
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,  // 10 .. 1F
  3, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 9, 0, 0, 5,  // 20 .. 2F
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 7, 0, 1, 0, 1,  // 30 .. 3F
  4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 40 .. 4F
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 4,  // 50 .. 5F
  1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  // 60 .. 6F
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 5, 5,  // 70 .. 7F
};


#if DT_OS_WINDOWS
  #define LDBL(value) std::numeric_limits<double>::max()
#else
  #define LDBL(value) value
#endif

const long double pow10lookup[701] = {
  1.0E-350L, 1.0E-349L, 1.0E-348L, 1.0E-347L, 1.0E-346L, 1.0E-345L, 1.0E-344L, 1.0E-343L, 1.0E-342L, 1.0E-341L,
  1.0E-340L, 1.0E-339L, 1.0E-338L, 1.0E-337L, 1.0E-336L, 1.0E-335L, 1.0E-334L, 1.0E-333L, 1.0E-332L, 1.0E-331L,
  1.0E-330L, 1.0E-329L, 1.0E-328L, 1.0E-327L, 1.0E-326L, 1.0E-325L, 1.0E-324L, 1.0E-323L, 1.0E-322L, 1.0E-321L,
  1.0E-320L, 1.0E-319L, 1.0E-318L, 1.0E-317L, 1.0E-316L, 1.0E-315L, 1.0E-314L, 1.0E-313L, 1.0E-312L, 1.0E-311L,
  1.0E-310L, 1.0E-309L, 1.0E-308L, 1.0E-307L, 1.0E-306L, 1.0E-305L, 1.0E-304L, 1.0E-303L, 1.0E-302L, 1.0E-301L,
  1.0E-300L, 1.0E-299L, 1.0E-298L, 1.0E-297L, 1.0E-296L, 1.0E-295L, 1.0E-294L, 1.0E-293L, 1.0E-292L, 1.0E-291L,
  1.0E-290L, 1.0E-289L, 1.0E-288L, 1.0E-287L, 1.0E-286L, 1.0E-285L, 1.0E-284L, 1.0E-283L, 1.0E-282L, 1.0E-281L,
  1.0E-280L, 1.0E-279L, 1.0E-278L, 1.0E-277L, 1.0E-276L, 1.0E-275L, 1.0E-274L, 1.0E-273L, 1.0E-272L, 1.0E-271L,
  1.0E-270L, 1.0E-269L, 1.0E-268L, 1.0E-267L, 1.0E-266L, 1.0E-265L, 1.0E-264L, 1.0E-263L, 1.0E-262L, 1.0E-261L,
  1.0E-260L, 1.0E-259L, 1.0E-258L, 1.0E-257L, 1.0E-256L, 1.0E-255L, 1.0E-254L, 1.0E-253L, 1.0E-252L, 1.0E-251L,
  1.0E-250L, 1.0E-249L, 1.0E-248L, 1.0E-247L, 1.0E-246L, 1.0E-245L, 1.0E-244L, 1.0E-243L, 1.0E-242L, 1.0E-241L,
  1.0E-240L, 1.0E-239L, 1.0E-238L, 1.0E-237L, 1.0E-236L, 1.0E-235L, 1.0E-234L, 1.0E-233L, 1.0E-232L, 1.0E-231L,
  1.0E-230L, 1.0E-229L, 1.0E-228L, 1.0E-227L, 1.0E-226L, 1.0E-225L, 1.0E-224L, 1.0E-223L, 1.0E-222L, 1.0E-221L,
  1.0E-220L, 1.0E-219L, 1.0E-218L, 1.0E-217L, 1.0E-216L, 1.0E-215L, 1.0E-214L, 1.0E-213L, 1.0E-212L, 1.0E-211L,
  1.0E-210L, 1.0E-209L, 1.0E-208L, 1.0E-207L, 1.0E-206L, 1.0E-205L, 1.0E-204L, 1.0E-203L, 1.0E-202L, 1.0E-201L,
  1.0E-200L, 1.0E-199L, 1.0E-198L, 1.0E-197L, 1.0E-196L, 1.0E-195L, 1.0E-194L, 1.0E-193L, 1.0E-192L, 1.0E-191L,
  1.0E-190L, 1.0E-189L, 1.0E-188L, 1.0E-187L, 1.0E-186L, 1.0E-185L, 1.0E-184L, 1.0E-183L, 1.0E-182L, 1.0E-181L,
  1.0E-180L, 1.0E-179L, 1.0E-178L, 1.0E-177L, 1.0E-176L, 1.0E-175L, 1.0E-174L, 1.0E-173L, 1.0E-172L, 1.0E-171L,
  1.0E-170L, 1.0E-169L, 1.0E-168L, 1.0E-167L, 1.0E-166L, 1.0E-165L, 1.0E-164L, 1.0E-163L, 1.0E-162L, 1.0E-161L,
  1.0E-160L, 1.0E-159L, 1.0E-158L, 1.0E-157L, 1.0E-156L, 1.0E-155L, 1.0E-154L, 1.0E-153L, 1.0E-152L, 1.0E-151L,
  1.0E-150L, 1.0E-149L, 1.0E-148L, 1.0E-147L, 1.0E-146L, 1.0E-145L, 1.0E-144L, 1.0E-143L, 1.0E-142L, 1.0E-141L,
  1.0E-140L, 1.0E-139L, 1.0E-138L, 1.0E-137L, 1.0E-136L, 1.0E-135L, 1.0E-134L, 1.0E-133L, 1.0E-132L, 1.0E-131L,
  1.0E-130L, 1.0E-129L, 1.0E-128L, 1.0E-127L, 1.0E-126L, 1.0E-125L, 1.0E-124L, 1.0E-123L, 1.0E-122L, 1.0E-121L,
  1.0E-120L, 1.0E-119L, 1.0E-118L, 1.0E-117L, 1.0E-116L, 1.0E-115L, 1.0E-114L, 1.0E-113L, 1.0E-112L, 1.0E-111L,
  1.0E-110L, 1.0E-109L, 1.0E-108L, 1.0E-107L, 1.0E-106L, 1.0E-105L, 1.0E-104L, 1.0E-103L, 1.0E-102L, 1.0E-101L,
  1.0E-100L, 1.0E-099L, 1.0E-098L, 1.0E-097L, 1.0E-096L, 1.0E-095L, 1.0E-094L, 1.0E-093L, 1.0E-092L, 1.0E-091L,
  1.0E-090L, 1.0E-089L, 1.0E-088L, 1.0E-087L, 1.0E-086L, 1.0E-085L, 1.0E-084L, 1.0E-083L, 1.0E-082L, 1.0E-081L,
  1.0E-080L, 1.0E-079L, 1.0E-078L, 1.0E-077L, 1.0E-076L, 1.0E-075L, 1.0E-074L, 1.0E-073L, 1.0E-072L, 1.0E-071L,
  1.0E-070L, 1.0E-069L, 1.0E-068L, 1.0E-067L, 1.0E-066L, 1.0E-065L, 1.0E-064L, 1.0E-063L, 1.0E-062L, 1.0E-061L,
  1.0E-060L, 1.0E-059L, 1.0E-058L, 1.0E-057L, 1.0E-056L, 1.0E-055L, 1.0E-054L, 1.0E-053L, 1.0E-052L, 1.0E-051L,
  1.0E-050L, 1.0E-049L, 1.0E-048L, 1.0E-047L, 1.0E-046L, 1.0E-045L, 1.0E-044L, 1.0E-043L, 1.0E-042L, 1.0E-041L,
  1.0E-040L, 1.0E-039L, 1.0E-038L, 1.0E-037L, 1.0E-036L, 1.0E-035L, 1.0E-034L, 1.0E-033L, 1.0E-032L, 1.0E-031L,
  1.0E-030L, 1.0E-029L, 1.0E-028L, 1.0E-027L, 1.0E-026L, 1.0E-025L, 1.0E-024L, 1.0E-023L, 1.0E-022L, 1.0E-021L,
  1.0E-020L, 1.0E-019L, 1.0E-018L, 1.0E-017L, 1.0E-016L, 1.0E-015L, 1.0E-014L, 1.0E-013L, 1.0E-012L, 1.0E-011L,
  1.0E-010L, 1.0E-009L, 1.0E-008L, 1.0E-007L, 1.0E-006L, 1.0E-005L, 1.0E-004L, 1.0E-003L, 1.0E-002L, 1.0E-001L,
  1.0E+000L, 1.0E+001L, 1.0E+002L, 1.0E+003L, 1.0E+004L, 1.0E+005L, 1.0E+006L, 1.0E+007L, 1.0E+008L, 1.0E+009L,
  1.0E+010L, 1.0E+011L, 1.0E+012L, 1.0E+013L, 1.0E+014L, 1.0E+015L, 1.0E+016L, 1.0E+017L, 1.0E+018L, 1.0E+019L,
  1.0E+020L, 1.0E+021L, 1.0E+022L, 1.0E+023L, 1.0E+024L, 1.0E+025L, 1.0E+026L, 1.0E+027L, 1.0E+028L, 1.0E+029L,
  1.0E+030L, 1.0E+031L, 1.0E+032L, 1.0E+033L, 1.0E+034L, 1.0E+035L, 1.0E+036L, 1.0E+037L, 1.0E+038L, 1.0E+039L,
  1.0E+040L, 1.0E+041L, 1.0E+042L, 1.0E+043L, 1.0E+044L, 1.0E+045L, 1.0E+046L, 1.0E+047L, 1.0E+048L, 1.0E+049L,
  1.0E+050L, 1.0E+051L, 1.0E+052L, 1.0E+053L, 1.0E+054L, 1.0E+055L, 1.0E+056L, 1.0E+057L, 1.0E+058L, 1.0E+059L,
  1.0E+060L, 1.0E+061L, 1.0E+062L, 1.0E+063L, 1.0E+064L, 1.0E+065L, 1.0E+066L, 1.0E+067L, 1.0E+068L, 1.0E+069L,
  1.0E+070L, 1.0E+071L, 1.0E+072L, 1.0E+073L, 1.0E+074L, 1.0E+075L, 1.0E+076L, 1.0E+077L, 1.0E+078L, 1.0E+079L,
  1.0E+080L, 1.0E+081L, 1.0E+082L, 1.0E+083L, 1.0E+084L, 1.0E+085L, 1.0E+086L, 1.0E+087L, 1.0E+088L, 1.0E+089L,
  1.0E+090L, 1.0E+091L, 1.0E+092L, 1.0E+093L, 1.0E+094L, 1.0E+095L, 1.0E+096L, 1.0E+097L, 1.0E+098L, 1.0E+099L,
  1.0E+100L, 1.0E+101L, 1.0E+102L, 1.0E+103L, 1.0E+104L, 1.0E+105L, 1.0E+106L, 1.0E+107L, 1.0E+108L, 1.0E+109L,
  1.0E+110L, 1.0E+111L, 1.0E+112L, 1.0E+113L, 1.0E+114L, 1.0E+115L, 1.0E+116L, 1.0E+117L, 1.0E+118L, 1.0E+119L,
  1.0E+120L, 1.0E+121L, 1.0E+122L, 1.0E+123L, 1.0E+124L, 1.0E+125L, 1.0E+126L, 1.0E+127L, 1.0E+128L, 1.0E+129L,
  1.0E+130L, 1.0E+131L, 1.0E+132L, 1.0E+133L, 1.0E+134L, 1.0E+135L, 1.0E+136L, 1.0E+137L, 1.0E+138L, 1.0E+139L,
  1.0E+140L, 1.0E+141L, 1.0E+142L, 1.0E+143L, 1.0E+144L, 1.0E+145L, 1.0E+146L, 1.0E+147L, 1.0E+148L, 1.0E+149L,
  1.0E+150L, 1.0E+151L, 1.0E+152L, 1.0E+153L, 1.0E+154L, 1.0E+155L, 1.0E+156L, 1.0E+157L, 1.0E+158L, 1.0E+159L,
  1.0E+160L, 1.0E+161L, 1.0E+162L, 1.0E+163L, 1.0E+164L, 1.0E+165L, 1.0E+166L, 1.0E+167L, 1.0E+168L, 1.0E+169L,
  1.0E+170L, 1.0E+171L, 1.0E+172L, 1.0E+173L, 1.0E+174L, 1.0E+175L, 1.0E+176L, 1.0E+177L, 1.0E+178L, 1.0E+179L,
  1.0E+180L, 1.0E+181L, 1.0E+182L, 1.0E+183L, 1.0E+184L, 1.0E+185L, 1.0E+186L, 1.0E+187L, 1.0E+188L, 1.0E+189L,
  1.0E+190L, 1.0E+191L, 1.0E+192L, 1.0E+193L, 1.0E+194L, 1.0E+195L, 1.0E+196L, 1.0E+197L, 1.0E+198L, 1.0E+199L,
  1.0E+200L, 1.0E+201L, 1.0E+202L, 1.0E+203L, 1.0E+204L, 1.0E+205L, 1.0E+206L, 1.0E+207L, 1.0E+208L, 1.0E+209L,
  1.0E+210L, 1.0E+211L, 1.0E+212L, 1.0E+213L, 1.0E+214L, 1.0E+215L, 1.0E+216L, 1.0E+217L, 1.0E+218L, 1.0E+219L,
  1.0E+220L, 1.0E+221L, 1.0E+222L, 1.0E+223L, 1.0E+224L, 1.0E+225L, 1.0E+226L, 1.0E+227L, 1.0E+228L, 1.0E+229L,
  1.0E+230L, 1.0E+231L, 1.0E+232L, 1.0E+233L, 1.0E+234L, 1.0E+235L, 1.0E+236L, 1.0E+237L, 1.0E+238L, 1.0E+239L,
  1.0E+240L, 1.0E+241L, 1.0E+242L, 1.0E+243L, 1.0E+244L, 1.0E+245L, 1.0E+246L, 1.0E+247L, 1.0E+248L, 1.0E+249L,
  1.0E+250L, 1.0E+251L, 1.0E+252L, 1.0E+253L, 1.0E+254L, 1.0E+255L, 1.0E+256L, 1.0E+257L, 1.0E+258L, 1.0E+259L,
  1.0E+260L, 1.0E+261L, 1.0E+262L, 1.0E+263L, 1.0E+264L, 1.0E+265L, 1.0E+266L, 1.0E+267L, 1.0E+268L, 1.0E+269L,
  1.0E+270L, 1.0E+271L, 1.0E+272L, 1.0E+273L, 1.0E+274L, 1.0E+275L, 1.0E+276L, 1.0E+277L, 1.0E+278L, 1.0E+279L,
  1.0E+280L, 1.0E+281L, 1.0E+282L, 1.0E+283L, 1.0E+284L, 1.0E+285L, 1.0E+286L, 1.0E+287L, 1.0E+288L, 1.0E+289L,
  1.0E+290L, 1.0E+291L, 1.0E+292L, 1.0E+293L, 1.0E+294L, 1.0E+295L, 1.0E+296L, 1.0E+297L, 1.0E+298L, 1.0E+299L,
  1.0E+300L, 1.0E+301L, 1.0E+302L, 1.0E+303L, 1.0E+304L, 1.0E+305L, 1.0E+306L, 1.0E+307L, 1.0E+308L, LDBL(1.0E+309L),
  LDBL(1.0E+310L), LDBL(1.0E+311L), LDBL(1.0E+312L), LDBL(1.0E+313L), LDBL(1.0E+314L), LDBL(1.0E+315L), LDBL(1.0E+316L), LDBL(1.0E+317L), LDBL(1.0E+318L), LDBL(1.0E+319L),
  LDBL(1.0E+320L), LDBL(1.0E+321L), LDBL(1.0E+322L), LDBL(1.0E+323L), LDBL(1.0E+324L), LDBL(1.0E+325L), LDBL(1.0E+326L), LDBL(1.0E+327L), LDBL(1.0E+328L), LDBL(1.0E+329L),
  LDBL(1.0E+330L), LDBL(1.0E+331L), LDBL(1.0E+332L), LDBL(1.0E+333L), LDBL(1.0E+334L), LDBL(1.0E+335L), LDBL(1.0E+336L), LDBL(1.0E+337L), LDBL(1.0E+338L), LDBL(1.0E+339L),
  LDBL(1.0E+340L), LDBL(1.0E+341L), LDBL(1.0E+342L), LDBL(1.0E+343L), LDBL(1.0E+344L), LDBL(1.0E+345L), LDBL(1.0E+346L), LDBL(1.0E+347L), LDBL(1.0E+348L), LDBL(1.0E+349L),
  LDBL(1.0E+350L)
};


}}  // namespace dt::read::
