/*
 * Decompiled with CFR 0.152.
 */
package org.micromanager.plugins.pythoneventserver;

import com.google.common.eventbus.Subscribe;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;
import mmcorej.CMMCore;
import mmcorej.org.json.JSONObject;
import org.micromanager.Studio;
import org.micromanager.acquisition.AcquisitionEndedEvent;
import org.micromanager.acquisition.AcquisitionSequenceStartedEvent;
import org.micromanager.acquisition.AcquisitionStartedEvent;
import org.micromanager.acquisition.SequenceSettings;
import org.micromanager.data.DataProviderHasNewImageEvent;
import org.micromanager.display.internal.event.DataViewerAddedEvent;
import org.micromanager.events.ConfigGroupChangedEvent;
import org.micromanager.events.ExposureChangedEvent;
import org.micromanager.events.GUIRefreshEvent;
import org.micromanager.events.LiveModeEvent;
import org.micromanager.events.StagePositionChangedEvent;
import org.micromanager.events.XYStagePositionChangedEvent;
import org.micromanager.internal.ConfigGroupPad;
import org.micromanager.internal.MMStudio;
import org.micromanager.internal.dialogs.AcqControlDlg;
import org.micromanager.internal.interfaces.AcqSettingsListener;
import org.micromanager.internal.utils.WindowPositioning;
import org.micromanager.internal.zmq.ZMQUtil;
import org.micromanager.plugins.pythoneventserver.CustomMDAEvent;
import org.micromanager.plugins.pythoneventserver.CustomSettingsEvent;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;

public class PythonEventServerFrame
extends JFrame {
    private final JCheckBox liveCheckBox_;
    private Studio studio_;
    private ConfigGroupPad pad_;
    private final JTextArea logTextArea;
    private final JScrollPane scrollPane;
    private ZMQ.Socket socket_;
    private ServerThread server;
    private JPanel panel = new JPanel();
    private BoxLayout boxLayout = new BoxLayout(this.panel, 1);
    public ZMQUtil util_;
    private AcqControlDlg acw_;
    private long lastStageTime;

    public PythonEventServerFrame(Studio studio) {
        super("Python Event Server GUI");
        this.studio_ = studio;
        this.acw_ = ((MMStudio)this.studio_).uiManager().getAcquisitionWindow();
        this.server = new ServerThread();
        this.server.init();
        this.server.start();
        System.out.println("Server started");
        CMMCore core = this.studio_.getCMMCore();
        HashSet<ClassLoader> classLoaders = new HashSet<ClassLoader>();
        classLoaders.add(core.getClass().getClassLoader());
        this.util_ = new ZMQUtil(classLoaders, new String[0]);
        super.setDefaultCloseOperation(0);
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PythonEventServerFrame.this.exitPlugin();
            }
        });
        JLabel title = new JLabel("Python Event Server");
        title.setFont(new Font("Arial", 1, 14));
        title.setMaximumSize(new Dimension(200, 30));
        title.setAlignmentX(0.5f);
        this.liveCheckBox_ = new JCheckBox();
        this.liveCheckBox_.setText("Live Mode Events");
        this.logTextArea = new JTextArea(30, 100);
        this.logTextArea.setAlignmentX(0.5f);
        this.scrollPane = new JScrollPane(this.logTextArea);
        DefaultCaret caret = (DefaultCaret)this.logTextArea.getCaret();
        caret.setUpdatePolicy(1);
        this.panel.setLayout(this.boxLayout);
        this.panel.add(title);
        this.panel.add(this.scrollPane);
        this.panel.add(this.liveCheckBox_);
        this.panel.setAlignmentX(0.5f);
        super.add(this.panel);
        super.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/micromanager/icons/microscope.gif")));
        super.setLocation(100, 100);
        super.setSize(new Dimension(100, 100));
        WindowPositioning.setUpLocationMemory((Window)this, this.getClass(), null);
        super.pack();
    }

    public void exitPlugin() {
        this.server.close();
        super.dispose();
        System.out.println("Closed Server and Frame");
    }

    public class ServerThread
    extends Thread
    implements AcqSettingsListener {
        public void init() {
            ZMQ.Context context = ZMQ.context((int)1);
            PythonEventServerFrame.this.socket_ = context.socket(SocketType.PUB);
            PythonEventServerFrame.this.socket_.bind("tcp://*:5556");
            PythonEventServerFrame.this.studio_.events().registerForEvents((Object)this);
            MMStudio studio = (MMStudio)PythonEventServerFrame.this.studio_;
            PythonEventServerFrame.this.pad_ = studio.uiManager().frame().getConfigPad();
            ((MMStudio)PythonEventServerFrame.this.studio_).getAcquisitionEngine().addSettingsListener((AcqSettingsListener)this);
            PythonEventServerFrame.this.lastStageTime = System.currentTimeMillis();
        }

        public void close() {
            PythonEventServerFrame.this.socket_.unbind("tcp://*:5556");
            PythonEventServerFrame.this.socket_.close();
            PythonEventServerFrame.this.studio_.events().unregisterForEvents((Object)this);
            super.interrupt();
        }

        @Subscribe
        public void onConfigGroupChanged(ConfigGroupChangedEvent event) {
            this.addLog("ConfigGroupChangedEvent " + event.getGroupName());
        }

        @Subscribe
        public void onGUIRefresh(GUIRefreshEvent event) {
            String group = PythonEventServerFrame.this.pad_.getSelectedGroup();
            ArrayList<CustomSettingsEvent> changedSettings = new ArrayList<CustomSettingsEvent>();
            try {
                String[] changeList;
                String state = PythonEventServerFrame.this.studio_.core().getConfigGroupState(group).getVerbose();
                System.out.println(state);
                for (String change : changeList = state.substring(6, state.length() - 7).split("<br>")) {
                    System.out.println(change);
                    String device = change.split(":")[0];
                    String setting = change.split(":")[1].split("=")[0];
                    String value = change.split(":")[1].split("=")[1];
                    changedSettings.add(new CustomSettingsEvent(device, setting, value));
                }
            }
            catch (Exception e) {
                System.out.println("Error");
                e.printStackTrace();
            }
            if (changedSettings.isEmpty()) {
                double exposure = 0.0;
                try {
                    exposure = PythonEventServerFrame.this.studio_.core().getExposure();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                PythonEventServerFrame.this.studio_.events().post((Object)new CustomSettingsEvent("exposure", "time_ms", String.valueOf(exposure)));
            }
            for (CustomSettingsEvent setting : changedSettings) {
                PythonEventServerFrame.this.studio_.events().post((Object)setting);
            }
            this.addLog("GUIRefreshEvent");
        }

        @Subscribe
        public void onSettingsChanged(CustomSettingsEvent event) {
            this.sendJSON(event);
            this.addLog("CustomSettingsEvent " + event.getDevice() + ":" + event.getProperty() + "=" + event.getValue());
        }

        public void settingsChanged() {
            System.out.println("Setting changed");
            SequenceSettings sequenceSettings = PythonEventServerFrame.this.studio_.acquisitions().getAcquisitionSettings();
            CustomMDAEvent settingsEvent = new CustomMDAEvent(sequenceSettings);
            PythonEventServerFrame.this.studio_.events().post((Object)settingsEvent);
        }

        @Subscribe
        public void onCustomMDA(CustomMDAEvent event) {
            this.sendJSON(event);
            this.addLog("CustomMDAEvent");
        }

        @Subscribe
        public void onExposureChanged(ExposureChangedEvent event) {
            this.sendJSON(event);
            this.addLog("ExposureChangedEvent " + event.getNewExposureTime());
        }

        @Subscribe
        public void onStagePositionChanged(StagePositionChangedEvent event) {
            long now = System.currentTimeMillis();
            System.out.println(now - PythonEventServerFrame.this.lastStageTime);
            this.sendJSON(event);
            this.addLog("StagePositionChangedEvent");
            PythonEventServerFrame.this.lastStageTime = now;
        }

        @Subscribe
        public void onXYStagePositionChanged(XYStagePositionChangedEvent event) {
            this.sendJSON(event);
            this.addLog("XYStagePositionChangedEvent");
        }

        @Subscribe
        public void onAcquisitionEnded(AcquisitionEndedEvent event) {
            this.sendJSON(event);
            this.addLog("AcquisitionEndedEvent");
        }

        @Subscribe
        public void onAcquisitionStarted(AcquisitionStartedEvent event) {
            this.sendJSON(event);
            event.getDatastore().registerForEvents((Object)this);
            this.addLog("AcquisitionStartedEvent");
        }

        public void onWindowAddedEvent(DataViewerAddedEvent event) {
            this.sendJSON(event);
            event.getDataViewer().getDataProvider().registerForEvents((Object)this);
            this.addLog("DataViewerAddedEvent");
        }

        @Subscribe
        public void onAcquisitionStarted(AcquisitionSequenceStartedEvent event) {
            this.sendJSON(event);
            this.addLog("AcquisitionSequenceStartedEvent");
        }

        @Subscribe
        public void onNewImage(DataProviderHasNewImageEvent event) {
            this.sendJSON(event);
            this.addLog("DataProviderHasNewImageEvent");
        }

        @Subscribe
        public void onDataViewerAddedEvent(DataViewerAddedEvent event) {
            this.addLog("DataViewerAddedEvent");
        }

        @Subscribe
        public void onLiveMode(LiveModeEvent event) {
            if (event.isOn() & PythonEventServerFrame.this.liveCheckBox_.isSelected()) {
                PythonEventServerFrame.this.studio_.getSnapLiveManager().getDisplay().getDataProvider().registerForEvents((Object)this);
            } else {
                PythonEventServerFrame.this.studio_.getSnapLiveManager().getDisplay().getDataProvider().unregisterForEvents((Object)this);
            }
            this.sendJSON(event);
            this.addLog("LiveModeEvent");
        }

        void addLog(String eventMsg) {
            String currentText = PythonEventServerFrame.this.logTextArea.getText();
            String newEvent = new Date() + " " + eventMsg;
            PythonEventServerFrame.this.logTextArea.setText(newEvent + "\n" + currentText);
        }

        public void sendJSON(Object event) {
            JSONObject json = new JSONObject();
            PythonEventServerFrame.this.util_.serialize(event, json, 5556);
            PythonEventServerFrame.this.socket_.send("StandardEvent " + json);
        }
    }
}

