# Database Tools

A collection of database tools written in Python for handling basic actions with CSV files, numpy dictionary, SQLite
databases and MySQL databases.

## Getting Started

These instructions will get you a copy of the project up and running on your local machine for development and testing purposes. See deployment for notes on how to deploy the project on a live system.

### PyPi installation

PyPi distribution

```
pip install databasetools
```

## Example Usage

Outlined below are basic uses of the main modules of the databasetools python package.

* CSV - Import csv file as list or export data to csv file 
* JSON - Save or load data to or from a .json file
* MySQL - Connect to MySQL database and execute queries
* PHPArray - Encode data as a sequential or associative PHP array
* Pickle - Read or write data to .pkl files
* SQLiteTools - Generate and execute SQLite queries with a single call

## Built With

* [differentiate](https://github.com/mrstephenneal/differentiate) - Compare multiple data sets and retrieve the unique, non-repeated elements.
* [looptools](https://github.com/mrstephenneal/looptools) - Logging output, timing processes and counting iterations.
* [mysql-connector](https://dev.mysql.com/doc/connector-python/en/) - Self-container driver for communication with 
MySQL servers
* [tqdm](https://github.com/tqdm/tqdm) - A fast, extensible progress bar for Python

## Contributing

Please read [CONTRIBUTING.md](https://github.com/mrstephenneal/databasetools/contributing.md) for details on our code of
 conduct, and the process for submitting pull requests to us.

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/mrstephenneal/databasetools).

## Authors

* **Stephen Neal** - *Initial work* - [databasetools](https://github.com/mrstephenneal/databasetools)


## License

This project is licensed under the MIT License - see the [LICENSE.md](LICENSE.md) file for details
