import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ExtensionConfig extends cdktf.TerraformMetaArguments {
    /**
     * When true, will also create any extensions that this extension depends on that are not already installed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#create_cascade Extension#create_cascade}
     *
     * @stability stable
     */
    readonly createCascade?: boolean | cdktf.IResolvable;
    /**
     * Sets the database to add the extension to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#database Extension#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * When true, will also drop all the objects that depend on the extension, and in turn all objects that depend on those objects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#drop_cascade Extension#drop_cascade}
     *
     * @stability stable
     */
    readonly dropCascade?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#name Extension#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Sets the schema of an extension.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#schema Extension#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Sets the version number of the extension.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/extension#version Extension#version}
     *
     * @stability stable
     */
    readonly version?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/extension postgresql_extension}.
 *
 * @stability stable
 */
export declare class Extension extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/extension postgresql_extension} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ExtensionConfig);
    private _createCascade?;
    /**
     * @stability stable
     */
    get createCascade(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set createCascade(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetCreateCascade(): void;
    /**
     * @stability stable
     */
    get createCascadeInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    resetDatabase(): void;
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _dropCascade?;
    /**
     * @stability stable
     */
    get dropCascade(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dropCascade(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDropCascade(): void;
    /**
     * @stability stable
     */
    get dropCascadeInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    resetSchema(): void;
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
