"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LabelSelector = exports.Workload = exports.LabelSelectorRequirementOperator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const pod_1 = require("./pod");
/**
 * Possible operators.
 */
var LabelSelectorRequirementOperator;
(function (LabelSelectorRequirementOperator) {
    /**
     * In.
     */
    LabelSelectorRequirementOperator["IN"] = "In";
    /**
     * NotIn.
     */
    LabelSelectorRequirementOperator["NOT_IN"] = "NotIn";
    /**
     * Exists.
     */
    LabelSelectorRequirementOperator["EXISTS"] = "Exists";
    /**
     * DoesNotExist.
     */
    LabelSelectorRequirementOperator["DOES_NOT_EXIST"] = "DoesNotExist";
})(LabelSelectorRequirementOperator = exports.LabelSelectorRequirementOperator || (exports.LabelSelectorRequirementOperator = {}));
/**
 * A workload is an application running on Kubernetes. Whether your workload is a single
 * component or several that work together, on Kubernetes you run it inside a set of pods.
 * In Kubernetes, a Pod represents a set of running containers on your cluster.
 */
class Workload extends pod_1.AbstractPod {
    constructor(scope, id, props = {}) {
        var _c;
        super(scope, id, props);
        this._matchLabels = {};
        this._matchExpressions = [];
        this.podMetadata = new cdk8s_1.ApiObjectMetadataDefinition(props.podMetadata);
        if ((_c = props.select) !== null && _c !== void 0 ? _c : true) {
            const selector = `cdk8s.${this.constructor.name.toLowerCase()}`;
            const matcher = cdk8s_1.Names.toLabelValue(this);
            this.select(LabelSelector.is(selector, matcher, true));
        }
    }
    /**
     * Configure selectors for this workload.
     */
    select(...selectors) {
        for (const selector of selectors) {
            if (selector.operator) {
                this._matchExpressions.push({ key: selector.key, values: selector.values, operator: selector.operator });
            }
            else {
                const value = selector.values[0];
                this._matchLabels[selector.key] = value;
                if (selector.applyToTemplate) {
                    this.podMetadata.addLabel(selector.key, value);
                }
            }
        }
    }
    /**
     * The label matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add label matchers.
     */
    get matchLabels() {
        return { ...this._matchLabels };
    }
    /**
     * The expression matchers this workload will use in order to select pods.
     *
     * Returns a a copy. Use `select()` to add expression matchers.
     */
    get matchExpressions() {
        return [...this._matchExpressions];
    }
}
exports.Workload = Workload;
_a = JSII_RTTI_SYMBOL_1;
Workload[_a] = { fqn: "cdk8s-plus-22.Workload", version: "1.0.0-beta.216" };
/**
 * A label selector is a label query over a set of resources.
 *
 * @see https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
 */
class LabelSelector {
    constructor(applyToTemplate, key, values, operator) {
        this.applyToTemplate = applyToTemplate;
        this.key = key;
        this.values = values;
        this.operator = operator;
    }
    /**
     * Creates a `matchLabels` entry from the key and value.
     * Use `applyToTemplate` to also add this label to the pod metadata of the workload.
     */
    static is(key, value, applyToTemplate) {
        return new LabelSelector(applyToTemplate !== null && applyToTemplate !== void 0 ? applyToTemplate : false, key, [value], undefined);
    }
    /**
     * Creates a `matchExpressions` "In" entry.
     */
    static in(key, values) {
        return new LabelSelector(false, key, values, LabelSelectorRequirementOperator.IN);
    }
    /**
     * Creates a `matchExpressions` "NotIn" entry.
     */
    static notIn(key, values) {
        return new LabelSelector(false, key, values, LabelSelectorRequirementOperator.NOT_IN);
    }
    /**
     * Creates a `matchExpressions` "Exists" entry.
     */
    static exists(key) {
        return new LabelSelector(false, key, undefined, LabelSelectorRequirementOperator.EXISTS);
    }
    /**
     * Creates a `matchExpressions` "DoesNotExist" entry.
     */
    static doesNotExist(key) {
        return new LabelSelector(false, key, undefined, LabelSelectorRequirementOperator.DOES_NOT_EXIST);
    }
}
exports.LabelSelector = LabelSelector;
_b = JSII_RTTI_SYMBOL_1;
LabelSelector[_b] = { fqn: "cdk8s-plus-22.LabelSelector", version: "1.0.0-beta.216" };
//# sourceMappingURL=data:application/json;base64,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