"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Probe = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _action = require("./_action");
/**
 * Probe describes a health check to be performed against a container to
 * determine whether it is alive or ready to receive traffic.
 */
class Probe {
    constructor(probeOptions, tcpSocketOptions, commandOptions, httpGetOptions) {
        this.probeOptions = probeOptions;
        this.tcpSocketOptions = tcpSocketOptions;
        this.commandOptions = commandOptions;
        this.httpGetOptions = httpGetOptions;
    }
    /**
     * Defines a probe based on an HTTP GET request to the IP address of the container.
     *
     * @param path The URL path to hit
     * @param options Options
     */
    static fromHttpGet(path, options = {}) {
        return new Probe(options, undefined, undefined, { path, ...options });
    }
    /**
     * Defines a probe based on a command which is executed within the container.
     *
     * @param command The command to execute
     * @param options Options
     */
    static fromCommand(command, options = {}) {
        return new Probe(options, undefined, { command, ...options }, undefined);
    }
    /**
     * Defines a probe based opening a connection to a TCP socket on the container.
     *
     * @param options Options
     */
    static fromTcpSocket(options = {}) {
        return new Probe(options, options, undefined, undefined);
    }
    /**
     * @internal
     */
    _toKube(cont) {
        var _b;
        const exec = this.commandOptions ? _action.Action.fromCommand(this.commandOptions.command) : undefined;
        const httpGet = this.httpGetOptions ? _action.Action.fromHttpGet(cont, this.httpGetOptions.path, this.httpGetOptions) : undefined;
        const tcpSocket = this.tcpSocketOptions ? _action.Action.fromTcpSocket(cont, this.tcpSocketOptions) : undefined;
        return {
            failureThreshold: (_b = this.probeOptions.failureThreshold) !== null && _b !== void 0 ? _b : 3,
            initialDelaySeconds: this.probeOptions.initialDelaySeconds ? this.probeOptions.initialDelaySeconds.toSeconds() : undefined,
            periodSeconds: this.probeOptions.periodSeconds ? this.probeOptions.periodSeconds.toSeconds() : undefined,
            successThreshold: this.probeOptions.successThreshold,
            timeoutSeconds: this.probeOptions.timeoutSeconds ? this.probeOptions.timeoutSeconds.toSeconds() : undefined,
            exec: exec,
            httpGet,
            tcpSocket,
        };
    }
}
exports.Probe = Probe;
_a = JSII_RTTI_SYMBOL_1;
Probe[_a] = { fqn: "cdk8s-plus-22.Probe", version: "1.0.0-beta.216" };
//# sourceMappingURL=data:application/json;base64,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