"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceAccount = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const base = require("./base");
const k8s = require("./imports/k8s");
const utils_1 = require("./utils");
/**
 * A service account provides an identity for processes that run in a Pod.
 *
 * When you (a human) access the cluster (for example, using kubectl), you are
 * authenticated by the apiserver as a particular User Account (currently this
 * is usually admin, unless your cluster administrator has customized your
 * cluster). Processes in containers inside pods can also contact the apiserver.
 * When they do, they are authenticated as a particular Service Account (for
 * example, default).
 *
 * @see https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account
 */
class ServiceAccount extends base.Resource {
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        this._secrets = (_b = props.secrets) !== null && _b !== void 0 ? _b : [];
        this.automountToken = (_c = props.automountToken) !== null && _c !== void 0 ? _c : true;
        this.apiObject = new k8s.KubeServiceAccount(this, 'Resource', {
            metadata: props.metadata,
            secrets: cdk8s_1.Lazy.any({ produce: () => utils_1.undefinedIfEmpty(this._secrets.map(s => ({ name: s.name }))) }),
            automountServiceAccountToken: this.automountToken,
        });
    }
    /**
     * Imports a service account from the cluster as a reference.
     * @param name The name of the service account resource.
     */
    static fromServiceAccountName(name) {
        return { name: name };
    }
    /**
     * Allow a secret to be accessed by pods using this service account.
     * @param secr The secret
     */
    addSecret(secr) {
        this._secrets.push(secr);
    }
    /**
     * List of secrets allowed to be used by pods running using this service
     * account.
     *
     * Returns a copy. To add a secret, use `addSecret()`.
     */
    get secrets() {
        return [...this._secrets];
    }
}
exports.ServiceAccount = ServiceAccount;
_a = JSII_RTTI_SYMBOL_1;
ServiceAccount[_a] = { fqn: "cdk8s-plus-22.ServiceAccount", version: "1.0.0-beta.216" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VydmljZS1hY2NvdW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL3NlcnZpY2UtYWNjb3VudC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlDQUF3QztBQUV4QywrQkFBK0I7QUFDL0IscUNBQXFDO0FBRXJDLG1DQUEyQztBQW9DM0M7Ozs7Ozs7Ozs7O0dBV0c7QUFDSCxNQUFhLGNBQWUsU0FBUSxJQUFJLENBQUMsUUFBUTtJQXVCL0MsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUE2QixFQUFHOztRQUN4RSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLElBQUksQ0FBQyxRQUFRLFNBQUcsS0FBSyxDQUFDLE9BQU8sbUNBQUksRUFBRSxDQUFDO1FBQ3BDLElBQUksQ0FBQyxjQUFjLFNBQUcsS0FBSyxDQUFDLGNBQWMsbUNBQUksSUFBSSxDQUFDO1FBRW5ELElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxHQUFHLENBQUMsa0JBQWtCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM1RCxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsT0FBTyxFQUFFLFlBQUksQ0FBQyxHQUFHLENBQUMsRUFBRSxPQUFPLEVBQUUsR0FBRyxFQUFFLENBQUMsd0JBQWdCLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO1lBQ2xHLDRCQUE0QixFQUFFLElBQUksQ0FBQyxjQUFjO1NBQ2xELENBQUMsQ0FBQztJQUNMLENBQUM7SUFoQ0Q7OztPQUdHO0lBQ0ksTUFBTSxDQUFDLHNCQUFzQixDQUFDLElBQVk7UUFDL0MsT0FBTyxFQUFFLElBQUksRUFBRSxJQUFJLEVBQUUsQ0FBQztJQUN4QixDQUFDO0lBNEJEOzs7T0FHRztJQUNJLFNBQVMsQ0FBQyxJQUFvQjtRQUNuQyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUMzQixDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSCxJQUFXLE9BQU87UUFDaEIsT0FBTyxDQUFDLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQzVCLENBQUM7O0FBcERILHdDQXFEQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwaU9iamVjdCwgTGF6eSB9IGZyb20gJ2NkazhzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgYmFzZSBmcm9tICcuL2Jhc2UnO1xuaW1wb3J0ICogYXMgazhzIGZyb20gJy4vaW1wb3J0cy9rOHMnO1xuaW1wb3J0ICogYXMgc2VjcmV0IGZyb20gJy4vc2VjcmV0JztcbmltcG9ydCB7IHVuZGVmaW5lZElmRW1wdHkgfSBmcm9tICcuL3V0aWxzJztcblxuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGluaXRpYWxpemF0aW9uIG9mIGBTZXJ2aWNlQWNjb3VudGAuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgU2VydmljZUFjY291bnRQcm9wcyBleHRlbmRzIGJhc2UuUmVzb3VyY2VQcm9wcyB7XG5cbn1cblxuZXhwb3J0IGludGVyZmFjZSBJU2VydmljZUFjY291bnQgZXh0ZW5kcyBiYXNlLklSZXNvdXJjZSB7XG5cbn1cblxuLyoqXG4gKiBQcm9wZXJ0aWVzIGZvciBpbml0aWFsaXphdGlvbiBvZiBgU2VydmljZUFjY291bnRgLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFNlcnZpY2VBY2NvdW50UHJvcHMge1xuICAvKipcbiAgICogTGlzdCBvZiBzZWNyZXRzIGFsbG93ZWQgdG8gYmUgdXNlZCBieSBwb2RzIHJ1bm5pbmcgdXNpbmcgdGhpc1xuICAgKiBTZXJ2aWNlQWNjb3VudC5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2t1YmVybmV0ZXMuaW8vZG9jcy9jb25jZXB0cy9jb25maWd1cmF0aW9uL3NlY3JldFxuICAgKi9cbiAgcmVhZG9ubHkgc2VjcmV0cz86IHNlY3JldC5JU2VjcmV0W107XG5cbiAgLyoqXG4gICAqIEluZGljYXRlcyB3aGV0aGVyIHBvZHMgcnVubmluZyBhcyB0aGlzIHNlcnZpY2UgYWNjb3VudFxuICAgKiBzaG91bGQgaGF2ZSBhbiBBUEkgdG9rZW4gYXV0b21hdGljYWxseSBtb3VudGVkLiBDYW4gYmUgb3ZlcnJpZGRlbiBhdCB0aGUgcG9kIGxldmVsLlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqIEBzZWUgaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvdGFza3MvY29uZmlndXJlLXBvZC1jb250YWluZXIvY29uZmlndXJlLXNlcnZpY2UtYWNjb3VudC8jdXNlLXRoZS1kZWZhdWx0LXNlcnZpY2UtYWNjb3VudC10by1hY2Nlc3MtdGhlLWFwaS1zZXJ2ZXJcbiAgICovXG4gIHJlYWRvbmx5IGF1dG9tb3VudFRva2VuPzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBBIHNlcnZpY2UgYWNjb3VudCBwcm92aWRlcyBhbiBpZGVudGl0eSBmb3IgcHJvY2Vzc2VzIHRoYXQgcnVuIGluIGEgUG9kLlxuICpcbiAqIFdoZW4geW91IChhIGh1bWFuKSBhY2Nlc3MgdGhlIGNsdXN0ZXIgKGZvciBleGFtcGxlLCB1c2luZyBrdWJlY3RsKSwgeW91IGFyZVxuICogYXV0aGVudGljYXRlZCBieSB0aGUgYXBpc2VydmVyIGFzIGEgcGFydGljdWxhciBVc2VyIEFjY291bnQgKGN1cnJlbnRseSB0aGlzXG4gKiBpcyB1c3VhbGx5IGFkbWluLCB1bmxlc3MgeW91ciBjbHVzdGVyIGFkbWluaXN0cmF0b3IgaGFzIGN1c3RvbWl6ZWQgeW91clxuICogY2x1c3RlcikuIFByb2Nlc3NlcyBpbiBjb250YWluZXJzIGluc2lkZSBwb2RzIGNhbiBhbHNvIGNvbnRhY3QgdGhlIGFwaXNlcnZlci5cbiAqIFdoZW4gdGhleSBkbywgdGhleSBhcmUgYXV0aGVudGljYXRlZCBhcyBhIHBhcnRpY3VsYXIgU2VydmljZSBBY2NvdW50IChmb3JcbiAqIGV4YW1wbGUsIGRlZmF1bHQpLlxuICpcbiAqIEBzZWUgaHR0cHM6Ly9rdWJlcm5ldGVzLmlvL2RvY3MvdGFza3MvY29uZmlndXJlLXBvZC1jb250YWluZXIvY29uZmlndXJlLXNlcnZpY2UtYWNjb3VudFxuICovXG5leHBvcnQgY2xhc3MgU2VydmljZUFjY291bnQgZXh0ZW5kcyBiYXNlLlJlc291cmNlIGltcGxlbWVudHMgSVNlcnZpY2VBY2NvdW50IHtcblxuICAvKipcbiAgICogSW1wb3J0cyBhIHNlcnZpY2UgYWNjb3VudCBmcm9tIHRoZSBjbHVzdGVyIGFzIGEgcmVmZXJlbmNlLlxuICAgKiBAcGFyYW0gbmFtZSBUaGUgbmFtZSBvZiB0aGUgc2VydmljZSBhY2NvdW50IHJlc291cmNlLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tU2VydmljZUFjY291bnROYW1lKG5hbWU6IHN0cmluZyk6IElTZXJ2aWNlQWNjb3VudCB7XG4gICAgcmV0dXJuIHsgbmFtZTogbmFtZSB9O1xuICB9XG5cbiAgLyoqXG4gICAqIEBzZWUgYmFzZS5SZXNvdXJjZS5hcGlPYmplY3RcbiAgICovXG4gIHByb3RlY3RlZCByZWFkb25seSBhcGlPYmplY3Q6IEFwaU9iamVjdDtcblxuICBwcml2YXRlIHJlYWRvbmx5IF9zZWNyZXRzOiBzZWNyZXQuSVNlY3JldFtdO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIG9yIG5vdCBhIHRva2VuIGlzIGF1dG9tYXRpY2FsbHkgbW91bnRlZCBmb3IgdGhpc1xuICAgKiBzZXJ2aWNlIGFjY291bnQuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXV0b21vdW50VG9rZW46IGJvb2xlYW47XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFNlcnZpY2VBY2NvdW50UHJvcHMgPSB7IH0pIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5fc2VjcmV0cyA9IHByb3BzLnNlY3JldHMgPz8gW107XG4gICAgdGhpcy5hdXRvbW91bnRUb2tlbiA9IHByb3BzLmF1dG9tb3VudFRva2VuID8/IHRydWU7XG5cbiAgICB0aGlzLmFwaU9iamVjdCA9IG5ldyBrOHMuS3ViZVNlcnZpY2VBY2NvdW50KHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIG1ldGFkYXRhOiBwcm9wcy5tZXRhZGF0YSxcbiAgICAgIHNlY3JldHM6IExhenkuYW55KHsgcHJvZHVjZTogKCkgPT4gdW5kZWZpbmVkSWZFbXB0eSh0aGlzLl9zZWNyZXRzLm1hcChzID0+ICh7IG5hbWU6IHMubmFtZSB9KSkpIH0pLFxuICAgICAgYXV0b21vdW50U2VydmljZUFjY291bnRUb2tlbjogdGhpcy5hdXRvbW91bnRUb2tlbixcbiAgICB9KTtcbiAgfVxuXG4gIC8qKlxuICAgKiBBbGxvdyBhIHNlY3JldCB0byBiZSBhY2Nlc3NlZCBieSBwb2RzIHVzaW5nIHRoaXMgc2VydmljZSBhY2NvdW50LlxuICAgKiBAcGFyYW0gc2VjciBUaGUgc2VjcmV0XG4gICAqL1xuICBwdWJsaWMgYWRkU2VjcmV0KHNlY3I6IHNlY3JldC5JU2VjcmV0KSB7XG4gICAgdGhpcy5fc2VjcmV0cy5wdXNoKHNlY3IpO1xuICB9XG5cbiAgLyoqXG4gICAqIExpc3Qgb2Ygc2VjcmV0cyBhbGxvd2VkIHRvIGJlIHVzZWQgYnkgcG9kcyBydW5uaW5nIHVzaW5nIHRoaXMgc2VydmljZVxuICAgKiBhY2NvdW50LlxuICAgKlxuICAgKiBSZXR1cm5zIGEgY29weS4gVG8gYWRkIGEgc2VjcmV0LCB1c2UgYGFkZFNlY3JldCgpYC5cbiAgICovXG4gIHB1YmxpYyBnZXQgc2VjcmV0cygpIHtcbiAgICByZXR1cm4gWy4uLnRoaXMuX3NlY3JldHNdO1xuICB9XG59Il19