"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DaemonSet = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const k8s = require("./imports/k8s");
const workload = require("./workload");
/**
 * A DaemonSet ensures that all (or some) Nodes run a copy of a Pod.
 * As nodes are added to the cluster, Pods are added to them.
 * As nodes are removed from the cluster, those Pods are garbage collected.
 * Deleting a DaemonSet will clean up the Pods it created.
 *
 * Some typical uses of a DaemonSet are:
 *
 * - running a cluster storage daemon on every node
 * - running a logs collection daemon on every node
 * - running a node monitoring daemon on every node
 *
 * In a simple case, one DaemonSet, covering all nodes, would be used for each type of daemon.
 * A more complex setup might use multiple DaemonSets for a single type of daemon,
 * but with different flags and/or different memory and cpu requests for different hardware types.
 */
class DaemonSet extends workload.Workload {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id, props);
        this.apiObject = new k8s.KubeDaemonSet(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this.minReadySeconds = (_b = props.minReadySeconds) !== null && _b !== void 0 ? _b : 0;
    }
    /**
     * @internal
     */
    _toKube() {
        return {
            minReadySeconds: this.minReadySeconds,
            template: {
                metadata: this.podMetadata.toJson(),
                spec: this._toPodSpec(),
            },
            selector: {
                matchExpressions: this.matchExpressions,
                matchLabels: this.matchLabels,
            },
        };
    }
}
exports.DaemonSet = DaemonSet;
_a = JSII_RTTI_SYMBOL_1;
DaemonSet[_a] = { fqn: "cdk8s-plus-22.DaemonSet", version: "1.0.0-beta.216" };
//# sourceMappingURL=data:application/json;base64,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