import { ApiObjectMetadata, ApiObject, ApiObjectMetadataDefinition } from 'cdk8s';
import { Construct } from 'constructs';
/**
 * Initialization properties for resources.
 */
export interface ResourceProps {
    /**
     * Metadata that all persisted resources must have, which includes all objects
     * users must create.
     */
    readonly metadata?: ApiObjectMetadata;
}
/**
 * Represents a resource.
 */
export interface IResource {
    /**
     * The Kubernetes name of this resource.
     */
    readonly name: string;
}
/**
 * Base class for all Kubernetes objects in stdk8s. Represents a single
 * resource.
 */
export declare abstract class Resource extends Construct implements IResource {
    /**
     * The underlying cdk8s API object.
     */
    protected abstract readonly apiObject: ApiObject;
    get metadata(): ApiObjectMetadataDefinition;
    /**
     * The name of this API object.
     */
    get name(): string;
}
