# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ts_ids_core', 'ts_ids_core.base', 'ts_ids_core.scripts']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0',
 'datamodel-code-generator>=0.11.0',
 'pydantic>=1.8,<2',
 'typing-extensions>=4.0']

entry_points = \
{'console_scripts': ['export-schema = '
                     'ts_ids_core.scripts.programmatic_ids_to_jsonschema:write_jsonschema_ids',
                     'import-schema = '
                     'ts_ids_core.scripts.jsonschema_to_programmatic_ids:main_cli']}

setup_kwargs = {
    'name': 'ts-ids-core',
    'version': '0.1.0a3',
    'description': 'Programmatically define TetraScience Intermediate Data Schema (IDS).',
    'long_description': '# Welcome to ts-ids-core\'s documentation!\n\n`ts-ids-core` provides a programmatic way of defining TetraScience Intermediate Data Schema (IDS). An IDS defined using the `ts-ids-core` framework can be exported to IDS JSON (`jsonschema` v7) and is thus compatible with the Tetra Data Platform (TDP).\n\n## Install\n\n```shell\npip install ts-ids-core\n```\n\n## Quickstart\n\nTo define your own Programmatic IDS (PIDS), inherit from classes in `ts_ids_core.schema`; `ts_ids_core.schema.IdsSchema` contains the IDS metadata fields, e.g. IDS version, and should be the parent class to your top-level IDS class.\n\nIn addition to defining IDS metadata fields, in the example below we add a field named "samples" that conforms to the predefined component, `Schema`.\n\n```python\nfrom typing import List\n\nfrom ts_ids_core.schema import IdsSchema, Sample\nfrom ts_ids_core.base.ids_field import IdsField\nfrom ts_ids_core.base.ids_element import SchemaExtraMetadataType\n\n\nclass DemoIdsSchema(IdsSchema):\n    #: The type hint `SchemaExtraMetadataType` is required.\n    schema_extra_metadata: SchemaExtraMetadataType = {\n        "$id": "https://ids.tetrascience.com/my_namespace/demo_ids/v1.0.0/schema.json",\n        "$schema": "http://json-schema.org/draft-07/schema#",\n    }\n\n    ids_namespace: str = IdsField(\'my_namespace\', const=True)\n    ids_type: str = IdsField(\'my_unique_ids_name\', const=True)\n    ids_version: str = IdsField(\'v1.0.0\', const=True)\n\n    samples: List[Sample] = IdsField()\n```\n\nThat\'s it! You just defined an IDS class. To export the IDS to JSON Schema used by the TDP, run the following code:\n\n```python\nids_json_schema = DemoIdsSchema.schema_json(indent=2)\n```\n\nWhen printed, output will look like this:\n<details><summary><a>Expand to show output</a></summary>\n\n```json\n{\n  "$id": "https://ids.tetrascience.com/my_namespace/my_unique_ids_name/v1.0.0/schema.json",\n  "$schema": "http://json-schema.org/draft-07/schema#",\n  "description": "Top-level schema.",\n  "type": "object",\n  "properties": {\n    "ids_type": {\n      "const": "my_unique_ids_name",\n      "type": "string"\n    },\n    "ids_version": {\n      "const": "v1.0.0",\n      "type": "string"\n    },\n    "@idsConventionVersion": {\n      "const": "v1.0.0",\n      "type": "string"\n    },\n    "ids_namespace": {\n      "const": "my_namespace",\n      "type": "string"\n    },\n    "samples": {\n      "type": "array",\n      "items": {\n        "$ref": "#/definitions/Sample"\n      }\n    }\n  },\n  "additionalProperties": false,\n  "definitions": {\n    "Batch": {\n      "type": "object",\n      "properties": {\n        "id": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "name": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "barcode": {\n          "type": [\n            "string",\n            "null"\n          ]\n        }\n      },\n      "additionalProperties": false\n    },\n    "Set": {\n      "type": "object",\n      "properties": {\n        "id": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "name": {\n          "type": [\n            "string",\n            "null"\n          ]\n        }\n      },\n      "additionalProperties": false\n    },\n    "Lot": {\n      "type": "object",\n      "properties": {\n        "id": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "name": {\n          "type": [\n            "string",\n            "null"\n          ]\n        }\n      },\n      "additionalProperties": false\n    },\n    "Holder": {\n      "type": "object",\n      "properties": {\n        "name": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "type": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "barcode": {\n          "type": [\n            "string",\n            "null"\n          ]\n        }\n      },\n      "additionalProperties": false\n    },\n    "Location": {\n      "type": "object",\n      "properties": {\n        "position": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "row": {\n          "type": [\n            "number",\n            "null"\n          ]\n        },\n        "column": {\n          "type": [\n            "number",\n            "null"\n          ]\n        },\n        "index": {\n          "type": [\n            "number",\n            "null"\n          ]\n        },\n        "holder": {\n          "$ref": "#/definitions/Holder"\n        }\n      },\n      "additionalProperties": false\n    },\n    "Source": {\n      "type": "object",\n      "properties": {\n        "name": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "type": {\n          "type": [\n            "string",\n            "null"\n          ]\n        }\n      },\n      "required": [\n        "name",\n        "type"\n      ],\n      "additionalProperties": false\n    },\n    "ValueDataType": {\n      "title": "ValueDataType",\n      "description": "An enumeration.",\n      "enum": [\n        "string",\n        "number",\n        "boolean"\n      ],\n      "type": "string"\n    },\n    "RawSampleTime": {\n      "type": "object",\n      "properties": {\n        "start": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "created": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "stop": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "duration": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "last_updated": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "acquired": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "modified": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "lookup": {\n          "type": [\n            "string",\n            "null"\n          ]\n        }\n      },\n      "required": [\n        "lookup"\n      ],\n      "additionalProperties": false\n    },\n    "SampleTime": {\n      "type": "object",\n      "properties": {\n        "start": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "created": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "stop": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "duration": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "last_updated": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "acquired": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "modified": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "lookup": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "raw": {\n          "$ref": "#/definitions/RawSampleTime"\n        }\n      },\n      "required": [\n        "lookup"\n      ],\n      "additionalProperties": false\n    },\n    "Property": {\n      "type": "object",\n      "properties": {\n        "source": {\n          "$ref": "#/definitions/Source"\n        },\n        "name": {\n          "description": "This is the property name",\n          "type": "string"\n        },\n        "value": {\n          "description": "The original string value of the parameter",\n          "type": "string"\n        },\n        "value_data_type": {\n          "description": "This is the type of the original value",\n          "$ref": "#/definitions/ValueDataType"\n        },\n        "string_value": {\n          "description": "If string_value has a value, then numerical_value,\\nnumerical_value_unit, and boolean_value all have to be null",\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "numerical_value": {\n          "description": "If numerical_value has a value, then string_value and\\nboolean_value both have to be null",\n          "type": [\n            "number",\n            "null"\n          ]\n        },\n        "numerical_value_unit": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "boolean_value": {\n          "description": "If boolean_value has a value, then numerical_value, numerical_value_unit,\\nand string_value all have to be null",\n          "type": [\n            "boolean",\n            "null"\n          ]\n        },\n        "time": {\n          "$ref": "#/definitions/SampleTime"\n        }\n      },\n      "required": [\n        "source",\n        "name",\n        "value",\n        "value_data_type",\n        "string_value",\n        "numerical_value",\n        "numerical_value_unit",\n        "boolean_value",\n        "time"\n      ],\n      "additionalProperties": false\n    },\n    "Label": {\n      "type": "object",\n      "properties": {\n        "source": {\n          "$ref": "#/definitions/Source"\n        },\n        "name": {\n          "type": "string"\n        },\n        "value": {\n          "type": "string"\n        },\n        "time": {\n          "$ref": "#/definitions/SampleTime"\n        }\n      },\n      "required": [\n        "source",\n        "name",\n        "value",\n        "time"\n      ],\n      "additionalProperties": false\n    },\n    "Sample": {\n      "description": "See [here](https://developers.tetrascience.com/docs/ids-design-conventions-schema-templates#samples)\\nfor specification of \\"samples\\". An instance of this class is one item in the\\n`samples` array.",\n      "type": "object",\n      "properties": {\n        "id": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "name": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "barcode": {\n          "type": [\n            "string",\n            "null"\n          ]\n        },\n        "batch": {\n          "$ref": "#/definitions/Batch"\n        },\n        "set": {\n          "$ref": "#/definitions/Set"\n        },\n        "lot": {\n          "$ref": "#/definitions/Lot"\n        },\n        "location": {\n          "$ref": "#/definitions/Location"\n        },\n        "properties": {\n          "type": "array",\n          "items": {\n            "$ref": "#/definitions/Property"\n          }\n        },\n        "labels": {\n          "type": "array",\n          "items": {\n            "$ref": "#/definitions/Label"\n          }\n        }\n      },\n      "additionalProperties": false\n    }\n  }\n}\n```\n\n</details>\n',
    'author': 'TetraScience',
    'author_email': 'developers@tetrascience.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
