"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Job = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s_1 = require("cdk8s");
const base_1 = require("./base");
const k8s = require("./imports/k8s");
const pod_1 = require("./pod");
/**
 * A Job creates one or more Pods and ensures that a specified number of them successfully terminate. As pods successfully complete,
 * the Job tracks the successful completions. When a specified number of successful completions is reached, the task (ie, Job) is complete.
 * Deleting a Job will clean up the Pods it created. A simple case is to create one Job object in order to reliably run one Pod to completion.
 * The Job object will start a new Pod if the first Pod fails or is deleted (for example due to a node hardware failure or a node reboot).
 * You can also use a Job to run multiple Pods in parallel.
 */
class Job extends base_1.Resource {
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        this.apiObject = new k8s.KubeJob(this, 'Resource', {
            metadata: props.metadata,
            spec: cdk8s_1.Lazy.any({ produce: () => this._toKube() }),
        });
        this._podTemplate = new pod_1.PodTemplate({
            ...props,
            restartPolicy: (_b = props.restartPolicy) !== null && _b !== void 0 ? _b : pod_1.RestartPolicy.NEVER,
        });
        this.activeDeadline = props.activeDeadline;
        this.backoffLimit = props.backoffLimit;
        this.ttlAfterFinished = props.ttlAfterFinished;
    }
    get podMetadata() {
        return this._podTemplate.podMetadata;
    }
    get containers() {
        return this._podTemplate.containers;
    }
    get initContainers() {
        return this._podTemplate.initContainers;
    }
    get hostAliases() {
        return this._podTemplate.hostAliases;
    }
    get volumes() {
        return this._podTemplate.volumes;
    }
    get restartPolicy() {
        return this._podTemplate.restartPolicy;
    }
    get serviceAccount() {
        return this._podTemplate.serviceAccount;
    }
    get securityContext() {
        return this._podTemplate.securityContext;
    }
    addContainer(container) {
        return this._podTemplate.addContainer(container);
    }
    addInitContainer(container) {
        return this._podTemplate.addInitContainer(container);
    }
    addHostAlias(hostAlias) {
        return this._podTemplate.addHostAlias(hostAlias);
    }
    addVolume(volume) {
        return this._podTemplate.addVolume(volume);
    }
    /**
     * @internal
     */
    _toKube() {
        var _b;
        return {
            template: this._podTemplate._toPodTemplateSpec(),
            activeDeadlineSeconds: (_b = this.activeDeadline) === null || _b === void 0 ? void 0 : _b.toSeconds(),
            backoffLimit: this.backoffLimit,
            ttlSecondsAfterFinished: this.ttlAfterFinished ? this.ttlAfterFinished.toSeconds() : undefined,
        };
    }
}
exports.Job = Job;
_a = JSII_RTTI_SYMBOL_1;
Job[_a] = { fqn: "cdk8s-plus-22.Job", version: "1.0.0-beta.198" };
//# sourceMappingURL=data:application/json;base64,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