/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.thread;

import org.python.core.ClassDictInit;
import org.python.core.FunctionThread;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.modules.thread.PyLocal;
import org.python.modules.thread.PyLock;

public class thread
implements ClassDictInit {
    private static volatile long stack_size = 0L;
    private static ThreadGroup group = new ThreadGroup("jython-threads");
    public static PyString __doc__ = new PyString("This module provides primitive operations to write multi-threaded programs.\nThe 'threading' module provides a more convenient interface.");
    public static PyObject error = new PyString("thread.error");

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("LockType", (PyObject)PyType.fromClass(PyLock.class));
        dict.__setitem__("_local", (PyObject)PyLocal.TYPE);
        dict.__setitem__("interruptAllThreads", null);
    }

    public static void start_new_thread(PyObject func, PyTuple args2) {
        FunctionThread pt = thread._newFunctionThread(func, args2);
        PyObject currentThread = func.__findattr__("__self__");
        if (currentThread != null) {
            PyObject getName;
            PyObject isDaemon = currentThread.__findattr__("isDaemon");
            if (isDaemon != null && isDaemon.isCallable()) {
                PyObject po = isDaemon.__call__();
                pt.setDaemon(po.__nonzero__());
            }
            if ((getName = currentThread.__findattr__("getName")) != null && getName.isCallable()) {
                PyObject pname = getName.__call__();
                pt.setName(String.valueOf(pname));
            }
        }
        pt.start();
    }

    public static FunctionThread _newFunctionThread(PyObject func, PyTuple args2) {
        return new FunctionThread(func, args2.getArray(), stack_size, group);
    }

    public static void interruptAllThreads() {
        group.interrupt();
    }

    public static PyLock allocate_lock() {
        return new PyLock();
    }

    public static void exit() {
        thread.exit_thread();
    }

    public static void exit_thread() {
        throw new PyException(Py.SystemExit, new PyInteger(0));
    }

    public static long get_ident() {
        return Thread.currentThread().getId();
    }

    public static long stack_size(PyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return stack_size;
            }
            case 1: {
                long old_stack_size = stack_size;
                int proposed_stack_size = args2[0].asInt();
                if (proposed_stack_size != 0 && proposed_stack_size < 32768) {
                    throw Py.ValueError("size not valid: " + proposed_stack_size + " bytes");
                }
                stack_size = proposed_stack_size;
                return old_stack_size;
            }
        }
        throw Py.TypeError("stack_size() takes at most 1 argument (" + args2.length + "given)");
    }
}

