/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.python.icu.lang.UCharacter;
import org.python.icu.text.DecimalFormat;
import org.python.icu.text.DecimalFormatSymbols;
import org.python.icu.text.NumberFormat;

public final class ScientificFormatHelper {
    private static final char[] SUPERSCRIPT_DIGITS = new char[]{'\u2070', '\u00b9', '\u00b2', '\u00b3', '\u2074', '\u2075', '\u2076', '\u2077', '\u2078', '\u2079'};
    private static final char SUPERSCRIPT_PLUS_SIGN = '\u207a';
    private static final char SUPERSCRIPT_MINUS_SIGN = '\u207b';
    private final String preExponent;

    private ScientificFormatHelper(String preExponent) {
        this.preExponent = preExponent;
    }

    public static ScientificFormatHelper getInstance(DecimalFormatSymbols dfs) {
        StringBuilder preExponent = new StringBuilder();
        preExponent.append(ScientificFormatHelper.getMultiplicationSymbol(dfs));
        char[] digits = dfs.getDigits();
        preExponent.append(digits[1]).append(digits[0]);
        return new ScientificFormatHelper(preExponent.toString());
    }

    private static String getMultiplicationSymbol(DecimalFormatSymbols dfs) {
        return dfs.getExponentMultiplicationSign();
    }

    public String insertMarkup(AttributedCharacterIterator iterator2, CharSequence beginMarkup, CharSequence endMarkup) {
        int copyFromOffset = 0;
        StringBuilder result2 = new StringBuilder();
        boolean exponentSymbolFieldPresent = false;
        boolean exponentFieldPresent = false;
        iterator2.first();
        while (iterator2.current() != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attributeSet = iterator2.getAttributes();
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SYMBOL)) {
                exponentSymbolFieldPresent = true;
                ScientificFormatHelper.append(iterator2, copyFromOffset, iterator2.getRunStart(NumberFormat.Field.EXPONENT_SYMBOL), result2);
                copyFromOffset = iterator2.getRunLimit(NumberFormat.Field.EXPONENT_SYMBOL);
                iterator2.setIndex(copyFromOffset);
                result2.append(this.preExponent);
                result2.append(beginMarkup);
                continue;
            }
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT)) {
                exponentFieldPresent = true;
                int limit = iterator2.getRunLimit(NumberFormat.Field.EXPONENT);
                ScientificFormatHelper.append(iterator2, copyFromOffset, limit, result2);
                copyFromOffset = limit;
                iterator2.setIndex(copyFromOffset);
                result2.append(endMarkup);
                continue;
            }
            iterator2.next();
        }
        if (!exponentSymbolFieldPresent || !exponentFieldPresent) {
            throw new IllegalArgumentException("Must start with standard e notation.");
        }
        ScientificFormatHelper.append(iterator2, copyFromOffset, iterator2.getEndIndex(), result2);
        return result2.toString();
    }

    private static void append(AttributedCharacterIterator iterator2, int start, int limit, StringBuilder result2) {
        int oldIndex = iterator2.getIndex();
        iterator2.setIndex(start);
        for (int i = start; i < limit; ++i) {
            result2.append(iterator2.current());
            iterator2.next();
        }
        iterator2.setIndex(oldIndex);
    }

    public String toSuperscriptExponentDigits(AttributedCharacterIterator iterator2) {
        int copyFromOffset = 0;
        StringBuilder result2 = new StringBuilder();
        boolean exponentSymbolFieldPresent = false;
        boolean exponentFieldPresent = false;
        iterator2.first();
        while (iterator2.current() != '\uffff') {
            int limit;
            int start;
            Map<AttributedCharacterIterator.Attribute, Object> attributeSet = iterator2.getAttributes();
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SYMBOL)) {
                exponentSymbolFieldPresent = true;
                ScientificFormatHelper.append(iterator2, copyFromOffset, iterator2.getRunStart(NumberFormat.Field.EXPONENT_SYMBOL), result2);
                copyFromOffset = iterator2.getRunLimit(NumberFormat.Field.EXPONENT_SYMBOL);
                iterator2.setIndex(copyFromOffset);
                result2.append(this.preExponent);
                continue;
            }
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT_SIGN)) {
                start = iterator2.getRunStart(NumberFormat.Field.EXPONENT_SIGN);
                limit = iterator2.getRunLimit(NumberFormat.Field.EXPONENT_SIGN);
                int aChar = ScientificFormatHelper.char32AtAndAdvance(iterator2);
                if (DecimalFormat.minusSigns.contains(aChar)) {
                    ScientificFormatHelper.append(iterator2, copyFromOffset, start, result2);
                    result2.append('\u207b');
                } else if (DecimalFormat.plusSigns.contains(aChar)) {
                    ScientificFormatHelper.append(iterator2, copyFromOffset, start, result2);
                    result2.append('\u207a');
                } else {
                    throw new IllegalArgumentException();
                }
                copyFromOffset = limit;
                iterator2.setIndex(copyFromOffset);
                continue;
            }
            if (attributeSet.containsKey(NumberFormat.Field.EXPONENT)) {
                exponentFieldPresent = true;
                start = iterator2.getRunStart(NumberFormat.Field.EXPONENT);
                limit = iterator2.getRunLimit(NumberFormat.Field.EXPONENT);
                ScientificFormatHelper.append(iterator2, copyFromOffset, start, result2);
                ScientificFormatHelper.copyAsSuperscript(iterator2, start, limit, result2);
                copyFromOffset = limit;
                iterator2.setIndex(copyFromOffset);
                continue;
            }
            iterator2.next();
        }
        if (!exponentSymbolFieldPresent || !exponentFieldPresent) {
            throw new IllegalArgumentException("Must start with standard e notation.");
        }
        ScientificFormatHelper.append(iterator2, copyFromOffset, iterator2.getEndIndex(), result2);
        return result2.toString();
    }

    private static void copyAsSuperscript(AttributedCharacterIterator iterator2, int start, int limit, StringBuilder result2) {
        int oldIndex = iterator2.getIndex();
        iterator2.setIndex(start);
        while (iterator2.getIndex() < limit) {
            int aChar = ScientificFormatHelper.char32AtAndAdvance(iterator2);
            int digit = UCharacter.digit(aChar);
            if (digit < 0) {
                throw new IllegalArgumentException();
            }
            result2.append(SUPERSCRIPT_DIGITS[digit]);
        }
        iterator2.setIndex(oldIndex);
    }

    private static int char32AtAndAdvance(AttributedCharacterIterator iterator2) {
        char c2;
        char c1 = iterator2.current();
        iterator2.next();
        if (UCharacter.isHighSurrogate(c1) && (c2 = iterator2.current()) != '\uffff' && UCharacter.isLowSurrogate(c2)) {
            iterator2.next();
            return UCharacter.toCodePoint(c1, c2);
        }
        return c1;
    }
}

