/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.util.ArrayList;
import java.util.List;

public class SimplePatternFormatter {
    private final String patternWithoutPlaceholders;
    private final int placeholderCount;
    private final int[] placeholderIdsOrderedByOffset;

    private SimplePatternFormatter(String pattern, PlaceholdersBuilder builder) {
        this.patternWithoutPlaceholders = pattern;
        this.placeholderIdsOrderedByOffset = builder.getPlaceholderIdsOrderedByOffset();
        this.placeholderCount = builder.getPlaceholderCount();
    }

    public static SimplePatternFormatter compile(CharSequence pattern) {
        PlaceholdersBuilder placeholdersBuilder = new PlaceholdersBuilder();
        PlaceholderIdBuilder idBuilder = new PlaceholderIdBuilder();
        StringBuilder newPattern = new StringBuilder();
        State state = State.INIT;
        block10: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            switch (state) {
                case INIT: {
                    if (ch == '\'') {
                        state = State.APOSTROPHE;
                        continue block10;
                    }
                    if (ch == '{') {
                        state = State.PLACEHOLDER;
                        idBuilder.reset();
                        continue block10;
                    }
                    newPattern.append(ch);
                    continue block10;
                }
                case APOSTROPHE: {
                    if (ch == '\'') {
                        newPattern.append("'");
                    } else if (ch == '{') {
                        newPattern.append("{");
                    } else {
                        newPattern.append("'");
                        newPattern.append(ch);
                    }
                    state = State.INIT;
                    continue block10;
                }
                case PLACEHOLDER: {
                    if (ch >= '0' && ch <= '9') {
                        idBuilder.add(ch);
                        continue block10;
                    }
                    if (ch == '}' && idBuilder.isValid()) {
                        placeholdersBuilder.add(idBuilder.getId(), newPattern.length());
                        state = State.INIT;
                        continue block10;
                    }
                    newPattern.append('{');
                    idBuilder.appendTo(newPattern);
                    newPattern.append(ch);
                    state = State.INIT;
                    continue block10;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        switch (state) {
            case INIT: {
                break;
            }
            case APOSTROPHE: {
                newPattern.append("'");
                break;
            }
            case PLACEHOLDER: {
                newPattern.append('{');
                idBuilder.appendTo(newPattern);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return new SimplePatternFormatter(newPattern.toString(), placeholdersBuilder);
    }

    public int getPlaceholderCount() {
        return this.placeholderCount;
    }

    public boolean startsWithPlaceholder(int id) {
        if (this.placeholderIdsOrderedByOffset.length == 0) {
            return false;
        }
        return this.placeholderIdsOrderedByOffset[0] == 0 && this.placeholderIdsOrderedByOffset[1] == id;
    }

    public String format(CharSequence ... values2) {
        return this.format(new StringBuilder(), null, values2).toString();
    }

    public StringBuilder format(StringBuilder appendTo, int[] offsets, CharSequence ... values2) {
        int i;
        if (values2.length < this.placeholderCount) {
            throw new IllegalArgumentException("Too few values.");
        }
        int offsetLen = offsets == null ? 0 : offsets.length;
        for (i = 0; i < offsetLen; ++i) {
            offsets[i] = -1;
        }
        if (this.placeholderIdsOrderedByOffset.length == 0) {
            appendTo.append(this.patternWithoutPlaceholders);
            return appendTo;
        }
        if (this.placeholderIdsOrderedByOffset[0] > 0 || appendTo != values2[this.placeholderIdsOrderedByOffset[1]]) {
            appendTo.append(this.patternWithoutPlaceholders, 0, this.placeholderIdsOrderedByOffset[0]);
            SimplePatternFormatter.setPlaceholderOffset(this.placeholderIdsOrderedByOffset[1], appendTo.length(), offsets, offsetLen);
            appendTo.append(values2[this.placeholderIdsOrderedByOffset[1]]);
        } else {
            SimplePatternFormatter.setPlaceholderOffset(this.placeholderIdsOrderedByOffset[1], 0, offsets, offsetLen);
        }
        for (i = 2; i < this.placeholderIdsOrderedByOffset.length; i += 2) {
            appendTo.append(this.patternWithoutPlaceholders, this.placeholderIdsOrderedByOffset[i - 2], this.placeholderIdsOrderedByOffset[i]);
            SimplePatternFormatter.setPlaceholderOffset(this.placeholderIdsOrderedByOffset[i + 1], appendTo.length(), offsets, offsetLen);
            appendTo.append(values2[this.placeholderIdsOrderedByOffset[i + 1]]);
        }
        appendTo.append(this.patternWithoutPlaceholders, this.placeholderIdsOrderedByOffset[this.placeholderIdsOrderedByOffset.length - 2], this.patternWithoutPlaceholders.length());
        return appendTo;
    }

    public String toString() {
        CharSequence[] values2 = new String[this.getPlaceholderCount()];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = String.format("{%d}", i);
        }
        return this.format(new StringBuilder(), null, values2).toString();
    }

    private static void setPlaceholderOffset(int placeholderId, int offset, int[] offsets, int offsetLen) {
        if (placeholderId < offsetLen) {
            offsets[placeholderId] = offset;
        }
    }

    public String getPatternWithNoPlaceholders() {
        return this.patternWithoutPlaceholders;
    }

    private static class PlaceholdersBuilder {
        private List<Integer> placeholderIdsOrderedByOffset = new ArrayList<Integer>();
        private int placeholderCount = 0;

        private PlaceholdersBuilder() {
        }

        public void add(int placeholderId, int offset) {
            this.placeholderIdsOrderedByOffset.add(offset);
            this.placeholderIdsOrderedByOffset.add(placeholderId);
            if (placeholderId >= this.placeholderCount) {
                this.placeholderCount = placeholderId + 1;
            }
        }

        public int getPlaceholderCount() {
            return this.placeholderCount;
        }

        public int[] getPlaceholderIdsOrderedByOffset() {
            int[] result2 = new int[this.placeholderIdsOrderedByOffset.size()];
            for (int i = 0; i < result2.length; ++i) {
                result2[i] = this.placeholderIdsOrderedByOffset.get(i);
            }
            return result2;
        }
    }

    private static class PlaceholderIdBuilder {
        private int id = 0;
        private int idLen = 0;

        private PlaceholderIdBuilder() {
        }

        public void reset() {
            this.id = 0;
            this.idLen = 0;
        }

        public int getId() {
            return this.id;
        }

        public void appendTo(StringBuilder appendTo) {
            if (this.idLen > 0) {
                appendTo.append(this.id);
            }
        }

        public boolean isValid() {
            return this.idLen > 0;
        }

        public void add(char ch) {
            this.id = this.id * 10 + ch - 48;
            ++this.idLen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        APOSTROPHE,
        PLACEHOLDER;

    }
}

