/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyFastSequenceIter;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequenceList;
import org.python.core.PySlice;
import org.python.core.PyTuple$PyExposer;
import org.python.core.PyTupleDerived;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="tuple", base=PyObject.class, doc="tuple() -> empty tuple\ntuple(iterable) -> tuple initialized from iterable's items\n\nIf the argument is a tuple, the return value is the same object.")
public class PyTuple
extends PySequenceList
implements List {
    public static final PyType TYPE;
    private final PyObject[] array;
    private volatile List<PyObject> cachedList = null;
    private static final PyTuple EMPTY_TUPLE;

    public PyTuple() {
        this(TYPE, Py.EmptyObjects);
    }

    public PyTuple(PyObject ... elements) {
        this(TYPE, elements);
    }

    public PyTuple(PyType subtype, PyObject[] elements) {
        super(subtype);
        if (elements == null) {
            this.array = new PyObject[0];
        } else {
            this.array = new PyObject[elements.length];
            System.arraycopy(elements, 0, this.array, 0, elements.length);
        }
    }

    public PyTuple(PyObject[] elements, boolean copy2) {
        this(TYPE, elements, copy2);
    }

    public PyTuple(PyType subtype, PyObject[] elements, boolean copy2) {
        super(subtype);
        if (copy2) {
            this.array = new PyObject[elements.length];
            System.arraycopy(elements, 0, this.array, 0, elements.length);
        } else {
            this.array = elements;
        }
    }

    private static PyTuple fromArrayNoCopy(PyObject[] elements) {
        return new PyTuple(elements, false);
    }

    List<PyObject> getList() {
        if (this.cachedList == null) {
            this.cachedList = Arrays.asList(this.array);
        }
        return this.cachedList;
    }

    @ExposedNew
    static final PyObject tuple_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args2, String[] keywords) {
        ArgParser ap = new ArgParser("tuple", args2, keywords, new String[]{"sequence"}, 0);
        PyObject S = ap.getPyObject(0, null);
        if (new_.for_type == subtype) {
            if (S == null) {
                return EMPTY_TUPLE;
            }
            if (S instanceof PyTupleDerived) {
                return new PyTuple(((PyTuple)S).getArray());
            }
            if (S instanceof PyTuple) {
                return S;
            }
            return PyTuple.fromArrayNoCopy(Py.make_array(S));
        }
        if (S == null) {
            return new PyTupleDerived(subtype, Py.EmptyObjects);
        }
        return new PyTupleDerived(subtype, Py.make_array(S));
    }

    public static PyTuple fromIterable(PyObject iterable) {
        return PyTuple.fromArrayNoCopy(Py.make_array(iterable));
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (step > 0 && stop < start) {
            stop = start;
        }
        int n = PyTuple.sliceLength(start, stop, step);
        PyObject[] newArray = new PyObject[n];
        if (step == 1) {
            System.arraycopy(this.array, start, newArray, 0, stop - start);
            return PyTuple.fromArrayNoCopy(newArray);
        }
        int i = start;
        for (int j = 0; j < n; ++j) {
            newArray[j] = this.array[i];
            i += step;
        }
        return PyTuple.fromArrayNoCopy(newArray);
    }

    @Override
    protected PyObject repeat(int count2) {
        int newSize;
        int size;
        if (count2 < 0) {
            count2 = 0;
        }
        if ((size = this.size()) == 0 || count2 == 1) {
            if (this.getType() == TYPE) {
                return this;
            }
            if (size == 0) {
                return EMPTY_TUPLE;
            }
        }
        if ((newSize = size * count2) / size != count2) {
            throw Py.MemoryError("");
        }
        PyObject[] newArray = new PyObject[newSize];
        for (int i = 0; i < count2; ++i) {
            System.arraycopy(this.array, 0, newArray, i * size, size);
        }
        return PyTuple.fromArrayNoCopy(newArray);
    }

    @Override
    public int __len__() {
        return this.tuple___len__();
    }

    final int tuple___len__() {
        return this.size();
    }

    final boolean tuple___contains__(PyObject o) {
        return super.__contains__(o);
    }

    final PyObject tuple___ne__(PyObject o) {
        return super.__ne__(o);
    }

    final PyObject tuple___eq__(PyObject o) {
        return super.__eq__(o);
    }

    final PyObject tuple___gt__(PyObject o) {
        return super.__gt__(o);
    }

    final PyObject tuple___ge__(PyObject o) {
        return super.__ge__(o);
    }

    final PyObject tuple___lt__(PyObject o) {
        return super.__lt__(o);
    }

    final PyObject tuple___le__(PyObject o) {
        return super.__le__(o);
    }

    @Override
    public PyObject __add__(PyObject generic_other) {
        return this.tuple___add__(generic_other);
    }

    final PyObject tuple___add__(PyObject generic_other) {
        PyTuple sum = null;
        if (generic_other instanceof PyTuple) {
            PyTuple other = (PyTuple)generic_other;
            PyObject[] newArray = new PyObject[this.array.length + other.array.length];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            System.arraycopy(other.array, 0, newArray, this.array.length, other.array.length);
            sum = PyTuple.fromArrayNoCopy(newArray);
        }
        return sum;
    }

    @Override
    public PyObject __mul__(PyObject o) {
        return this.tuple___mul__(o);
    }

    final PyObject tuple___mul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o) {
        return this.tuple___rmul__(o);
    }

    final PyObject tuple___rmul__(PyObject o) {
        if (!o.isIndex()) {
            return null;
        }
        return this.repeat(o.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __iter__() {
        return this.tuple___iter__();
    }

    public PyObject tuple___iter__() {
        return new PyFastSequenceIter(this);
    }

    final PyObject tuple___getslice__(PyObject s_start, PyObject s_stop, PyObject s_step) {
        return this.seq___getslice__(s_start, s_stop, s_step);
    }

    final PyObject tuple___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + index);
        }
        return ret;
    }

    final PyTuple tuple___getnewargs__() {
        return new PyTuple(new PyTuple(this.getArray()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.tuple___getnewargs__();
    }

    @Override
    public int hashCode() {
        return this.tuple___hash__();
    }

    final int tuple___hash__() {
        int len = this.size();
        int mult = 1000003;
        int x = 3430008;
        while (--len >= 0) {
            int y = this.array[len].hashCode();
            x = (x ^ y) * mult;
            mult += 82520 + len + len;
        }
        return x + 97531;
    }

    private String subobjRepr(PyObject o) {
        if (o == null) {
            return "null";
        }
        return o.__repr__().toString();
    }

    @Override
    public String toString() {
        return this.tuple___repr__();
    }

    final String tuple___repr__() {
        StringBuilder buf = new StringBuilder("(");
        for (int i = 0; i < this.array.length - 1; ++i) {
            buf.append(this.subobjRepr(this.array[i]));
            buf.append(", ");
        }
        if (this.array.length > 0) {
            buf.append(this.subobjRepr(this.array[this.array.length - 1]));
        }
        if (this.array.length == 1) {
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    @Override
    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        PyObject[] elements = new PyObject[toIndex - fromIndex];
        int i = 0;
        int j = fromIndex;
        while (i < elements.length) {
            elements[i] = this.array[j];
            ++i;
            ++j;
        }
        return new PyTuple(elements);
    }

    @Override
    public Iterator iterator() {
        return new Iterator(){
            private final Iterator<PyObject> iter;
            {
                this.iter = PyTuple.this.getList().iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }
        };
    }

    @Override
    public boolean add(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object set(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, Object element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            private final ListIterator<PyObject> iter;
            {
                this.iter = PyTuple.this.getList().listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Object next() {
                return this.iter.next().__tojava__(Object.class);
            }

            @Override
            public boolean hasPrevious() {
                return this.iter.hasPrevious();
            }

            public Object previous() {
                return this.iter.previous().__tojava__(Object.class);
            }

            @Override
            public int nextIndex() {
                return this.iter.nextIndex();
            }

            @Override
            public int previousIndex() {
                return this.iter.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "can only concatenate tuple (not \"{2}\") to tuple";
        }
        return super.unsupportedopMessage(op, o2);
    }

    @Override
    public void pyset(int index, PyObject value) {
        throw Py.TypeError("'tuple' object does not support item assignment");
    }

    @Override
    public boolean contains(Object o) {
        return this.getList().contains(Py.java2py(o));
    }

    @Override
    public boolean containsAll(Collection c) {
        if (c instanceof PyList) {
            return this.getList().containsAll(((PyList)c).getList());
        }
        if (c instanceof PyTuple) {
            return this.getList().containsAll(((PyTuple)c).getList());
        }
        return this.getList().containsAll(new PyList(c));
    }

    public int count(PyObject value) {
        return this.tuple_count(value);
    }

    final int tuple_count(PyObject value) {
        int count2 = 0;
        for (PyObject item : this.array) {
            if (!item.equals(value)) continue;
            ++count2;
        }
        return count2;
    }

    public int index(PyObject value) {
        return this.index(value, 0);
    }

    public int index(PyObject value, int start) {
        return this.index(value, start, this.size());
    }

    public int index(PyObject value, int start, int stop) {
        return this.tuple_index(value, start, stop);
    }

    final int tuple_index(PyObject value, PyObject start, PyObject stop) {
        int startInt = start == null ? 0 : PySlice.calculateSliceIndex(start);
        int stopInt = stop == null ? this.size() : PySlice.calculateSliceIndex(stop);
        return this.tuple_index(value, startInt, stopInt);
    }

    final int tuple_index(PyObject value, int start, int stop) {
        int validStart = this.boundToSequence(start);
        int validStop = this.boundToSequence(stop);
        for (int i = validStart; i < validStop; ++i) {
            if (!this.array[i].equals(value)) continue;
            return i;
        }
        throw Py.ValueError("tuple.index(x): x not in list");
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PyObject) {
            return this._eq((PyObject)other).__nonzero__();
        }
        if (other instanceof List) {
            return other.equals(this);
        }
        return false;
    }

    @Override
    public Object get(int index) {
        return this.array[index].__tojava__(Object.class);
    }

    @Override
    public PyObject[] getArray() {
        return this.array;
    }

    @Override
    public int indexOf(Object o) {
        return this.getList().indexOf(Py.java2py(o));
    }

    @Override
    public boolean isEmpty() {
        return this.array.length == 0;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(Py.java2py(o));
    }

    @Override
    public void pyadd(int index, PyObject element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean pyadd(PyObject o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PyObject pyget(int index) {
        return this.array[index];
    }

    @Override
    public void remove(int start, int stop) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public Object[] toArray() {
        Object[] converted = new Object[this.array.length];
        for (int i = 0; i < this.array.length; ++i) {
            converted[i] = this.array[i].__tojava__(Object.class);
        }
        return converted;
    }

    @Override
    public Object[] toArray(Object[] converted) {
        int i;
        Class<?> type = converted.getClass().getComponentType();
        if (converted.length < this.array.length) {
            converted = (Object[])Array.newInstance(type, this.array.length);
        }
        for (i = 0; i < this.array.length; ++i) {
            converted[i] = type.cast(this.array[i].__tojava__(type));
        }
        if (this.array.length < converted.length) {
            for (i = this.array.length; i < converted.length; ++i) {
                converted[i] = null;
            }
        }
        return converted;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        for (PyObject ob : this.array) {
            if (ob == null || (retVal = visit.visit(ob, arg)) == 0) continue;
            return retVal;
        }
        if (this.cachedList != null) {
            for (PyObject ob : this.cachedList) {
                if (ob == null || (retVal = visit.visit(ob, arg)) == 0) continue;
                return retVal;
            }
        }
        return 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        if (ob == null) {
            return false;
        }
        for (PyObject obj : this.array) {
            if (obj != ob) continue;
            return true;
        }
        if (this.cachedList != null) {
            for (PyObject obj : this.cachedList) {
                if (obj != ob) continue;
                return true;
            }
        }
        return false;
    }

    static {
        PyType.addBuilder(PyTuple.class, new PyTuple$PyExposer());
        TYPE = PyType.fromClass(PyTuple.class);
        EMPTY_TUPLE = new PyTuple();
    }
}

